/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.util.Arrays;

@NpmPackage(value="@vaadin/tooltip", version="23.3.10")
@JsModule(value="@vaadin/tooltip/src/vaadin-tooltip.js")
public class Tooltip
implements Serializable {
    private static final String TOOLTIP_DATA_KEY = "tooltip";
    private final Element tooltipElement = new Element("vaadin-tooltip");

    private Tooltip() {
    }

    private static Tooltip forElement(Element element) {
        Tooltip tooltip = new Tooltip();
        SerializableRunnable & Serializable onTargetAttach = (SerializableRunnable & Serializable)() -> {
            tooltip.tooltipElement.removeFromTree();
            Element tooltipHost = UI.getCurrent().getElement();
            tooltipHost.appendChild(new Element[]{tooltip.tooltipElement});
            tooltip.tooltipElement.executeJs("this.target = $0;", new Serializable[]{element});
        };
        element.addAttachListener((ElementAttachListener & Serializable)e -> onTargetAttach.run());
        if (element.getNode().isAttached()) {
            onTargetAttach.run();
        }
        element.addDetachListener((ElementDetachListener & Serializable)e -> tooltip.tooltipElement.removeFromParent());
        return tooltip;
    }

    public static Tooltip forComponent(Component component) {
        return Tooltip.forElement(component.getElement());
    }

    static Tooltip getForElement(Element element) {
        Component component = ComponentUtil.getInnermostComponent((Element)element);
        return (Tooltip)ComponentUtil.getData((Component)component, (String)TOOLTIP_DATA_KEY);
    }

    static Tooltip forHasTooltip(HasTooltip hasTooltip) {
        SlotUtils.clearSlot(hasTooltip, TOOLTIP_DATA_KEY);
        Tooltip tooltip = new Tooltip();
        tooltip.tooltipElement.setAttribute("slot", TOOLTIP_DATA_KEY);
        hasTooltip.getElement().appendChild(new Element[]{tooltip.tooltipElement});
        Component component = ComponentUtil.getInnermostComponent((Element)hasTooltip.getElement());
        ComponentUtil.setData((Component)component, (String)TOOLTIP_DATA_KEY, (Object)tooltip);
        return tooltip;
    }

    public void setText(String text) {
        this.tooltipElement.setProperty("text", text);
    }

    public String getText() {
        return this.tooltipElement.getProperty("text");
    }

    public Tooltip withText(String text) {
        this.setText(text);
        return this;
    }

    public void setFocusDelay(int focusDelay) {
        this.tooltipElement.setProperty("focusDelay", (double)focusDelay);
    }

    public int getFocusDelay() {
        return this.tooltipElement.getProperty("focusDelay", 0);
    }

    public Tooltip withFocusDelay(int focusDelay) {
        this.setFocusDelay(focusDelay);
        return this;
    }

    public void setHideDelay(int hideDelay) {
        this.tooltipElement.setProperty("hideDelay", (double)hideDelay);
    }

    public int getHideDelay() {
        return this.tooltipElement.getProperty("hideDelay", 0);
    }

    public Tooltip withHideDelay(int hideDelay) {
        this.setHideDelay(hideDelay);
        return this;
    }

    public void setHoverDelay(int hoverDelay) {
        this.tooltipElement.setProperty("hoverDelay", (double)hoverDelay);
    }

    public int getHoverDelay() {
        return this.tooltipElement.getProperty("hoverDelay", 0);
    }

    public Tooltip withHoverDelay(int hoverDelay) {
        this.setHoverDelay(hoverDelay);
        return this;
    }

    public void setPosition(TooltipPosition position) {
        this.tooltipElement.setProperty("position", position.getPosition());
    }

    public TooltipPosition getPosition() {
        String positionString = this.tooltipElement.getProperty("position");
        return Arrays.stream(TooltipPosition.values()).filter(p -> p.getPosition().equals(positionString)).findFirst().orElse(null);
    }

    public Tooltip withPosition(TooltipPosition position) {
        this.setPosition(position);
        return this;
    }

    public void setManual(boolean manual) {
        this.tooltipElement.setProperty("manual", manual);
    }

    public boolean isManual() {
        return this.tooltipElement.getProperty("manual", false);
    }

    public Tooltip withManual(boolean manual) {
        this.setManual(manual);
        return this;
    }

    public void setOpened(boolean opened) {
        this.tooltipElement.setProperty("opened", opened);
    }

    public boolean isOpened() {
        return this.tooltipElement.getProperty("opened", false);
    }

    public static enum TooltipPosition {
        TOP_START("top-start"),
        TOP("top"),
        TOP_END("top-end"),
        BOTTOM_START("bottom-start"),
        BOTTOM("bottom"),
        BOTTOM_END("bottom-end"),
        START_TOP("start-top"),
        START("start"),
        START_BOTTOM("start-bottom"),
        END_TOP("end-top"),
        END("end"),
        END_BOTTOM("end-bottom");

        private final String position;

        private TooltipPosition(String position) {
            this.position = position;
        }

        public String getPosition() {
            return this.position;
        }
    }
}

