/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignAttributeHandler;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.v7.shared.ui.slider.SliderOrientation;
import com.vaadin.v7.shared.ui.slider.SliderServerRpc;
import com.vaadin.v7.shared.ui.slider.SliderState;
import com.vaadin.v7.ui.AbstractField;
import java.util.Collection;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

@Deprecated
public class Slider
extends AbstractField<Double> {
    private SliderServerRpc rpc = new SliderServerRpc(){

        public void valueChanged(double value) {
            Slider.this.getUI().getConnectorTracker().getDiffState((ClientConnector)Slider.this).put("value", value);
            try {
                Slider.this.setValue(value, true);
            }
            catch (ValueOutOfBoundsException e) {
                double out = e.getValue();
                if (out < Slider.this.getState().minValue) {
                    out = Slider.this.getState().minValue;
                }
                if (out > Slider.this.getState().maxValue) {
                    out = Slider.this.getState().maxValue;
                }
                Slider.super.setValue(new Double(out), false);
            }
        }
    };

    public Slider() {
        this.registerRpc((ServerRpc)this.rpc);
        super.setValue(new Double(this.getState().minValue));
    }

    public Slider(String caption) {
        this();
        this.setCaption(caption);
    }

    public Slider(double min, double max, int resolution) {
        this();
        this.setResolution(resolution);
        this.setMax(max);
        this.setMin(min);
    }

    public Slider(int min, int max) {
        this();
        this.setMin(min);
        this.setMax(max);
        this.setResolution(0);
    }

    public Slider(String caption, int min, int max) {
        this(min, max);
        this.setCaption(caption);
    }

    public SliderState getState() {
        return (SliderState)super.getState();
    }

    public SliderState getState(boolean markAsDirty) {
        return (SliderState)super.getState(markAsDirty);
    }

    public double getMax() {
        return this.getState((boolean)false).maxValue;
    }

    public void setMax(double max) {
        double roundedMax;
        this.getState().maxValue = roundedMax = this.getRoundedValue(max);
        if (this.getMin() > roundedMax) {
            this.getState().minValue = roundedMax;
        }
        if ((Double)this.getValue() > roundedMax) {
            this.setValue(roundedMax);
        }
    }

    public double getMin() {
        return this.getState((boolean)false).minValue;
    }

    public void setMin(double min) {
        double roundedMin;
        this.getState().minValue = roundedMin = this.getRoundedValue(min);
        if (this.getMax() < roundedMin) {
            this.getState().maxValue = roundedMin;
        }
        if ((Double)this.getValue() < roundedMin) {
            this.setValue(roundedMin);
        }
    }

    public SliderOrientation getOrientation() {
        return this.getState((boolean)false).orientation;
    }

    public void setOrientation(SliderOrientation orientation) {
        this.getState().orientation = orientation;
    }

    public int getResolution() {
        return this.getState((boolean)false).resolution;
    }

    public void setResolution(int resolution) {
        if (resolution < 0) {
            throw new IllegalArgumentException("Cannot set a negative resolution to Slider");
        }
        this.getState().resolution = resolution;
    }

    @Override
    protected void setValue(Double value, boolean repaintIsNotNeeded) {
        double newValue = this.getRoundedValue(value);
        if (this.getMin() > newValue || this.getMax() < newValue) {
            throw new ValueOutOfBoundsException(newValue);
        }
        this.getState().value = newValue;
        super.setValue(newValue, repaintIsNotNeeded);
    }

    private double getRoundedValue(Double value) {
        double v = value;
        int resolution = this.getResolution();
        double ratio = Math.pow(10.0, resolution);
        if (v >= 0.0) {
            return Math.floor(v * ratio) / ratio;
        }
        return Math.ceil(v * ratio) / ratio;
    }

    @Override
    public void setValue(Double newFieldValue) {
        super.setValue(newFieldValue);
        this.getState().value = newFieldValue;
    }

    @Override
    protected void setInternalValue(Double newValue) {
        super.setInternalValue(newValue);
        if (newValue == null) {
            newValue = 0.0;
        }
        this.getState().value = newValue;
    }

    @Override
    public Class<Double> getType() {
        return Double.class;
    }

    @Override
    public void clear() {
        super.setValue(this.getState().minValue);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void readDesign(Element design, DesignContext context) {
        super.readDesign(design, context);
        Attributes attr = design.attributes();
        if (attr.hasKey("vertical")) {
            this.setOrientation(SliderOrientation.VERTICAL);
        }
        if (attr.hasKey("value")) {
            Double newFieldValue = (Double)DesignAttributeHandler.readAttribute((String)"value", (Attributes)attr, Double.class);
            this.setValue(newFieldValue, false, true);
        }
    }

    @Override
    public void writeDesign(Element design, DesignContext context) {
        super.writeDesign(design, context);
        if (this.getOrientation() == SliderOrientation.VERTICAL) {
            design.attr("vertical", true);
        }
        Slider defaultSlider = (Slider)context.getDefaultInstance((Component)this);
        DesignAttributeHandler.writeAttribute((Object)this, (String)"value", (Attributes)design.attributes(), (Object)defaultSlider, (DesignContext)context);
    }

    @Override
    protected Collection<String> getCustomAttributes() {
        Collection<String> result = super.getCustomAttributes();
        result.add("orientation");
        result.add("vertical");
        return result;
    }

    @Deprecated
    public class ValueOutOfBoundsException
    extends RuntimeException {
        private final Double value;

        public ValueOutOfBoundsException(Double valueOutOfBounds) {
            super(String.format("Value %s is out of bounds: [%s, %s]", valueOutOfBounds, Slider.this.getMin(), Slider.this.getMax()));
            this.value = valueOutOfBounds;
        }

        public Double getValue() {
            return this.value;
        }
    }
}

