/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.client.ui;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.vaadin.client.SimpleTree;

/**
 * A placeholder widget class for when a component's connector cannot be
 * determined and a placeholder connector is used instead.
 *
 * @author Vaadin Ltd
 */
@SuppressWarnings("deprecation")
public class VUnknownComponent extends Composite {

    com.google.gwt.user.client.ui.Label caption = new com.google.gwt.user.client.ui.Label();
    /** Unused. Only here for historical reasons. */
    SimpleTree uidlTree;
    /** The base widget of this composite. */
    protected VerticalPanel panel;

    /**
     * Constructs a placeholder widget.
     */
    public VUnknownComponent() {
        panel = new VerticalPanel();
        panel.add(caption);
        initWidget(panel);
        setStyleName("vaadin-unknown");
        caption.setStyleName("vaadin-unknown-caption");
    }

    /**
     * Sets the content text for this placeholder. Can contain HTML.
     *
     * @param c
     *            the content text to set
     */
    public void setCaption(String c) {
        caption.getElement().setInnerHTML(c);
    }
}
