/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.button;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-button")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="22.0.12"), @NpmPackage(value="@vaadin/button", version="22.0.12"), @NpmPackage(value="@vaadin/vaadin-button", version="22.0.12")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/button/src/vaadin-button.js")})
public abstract class GeneratedVaadinButton<R extends GeneratedVaadinButton<R>>
extends Component
implements HasStyle,
ClickNotifier<R>,
HasText,
Focusable<R>,
HasTheme {
    public void addThemeVariants(ButtonVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(ButtonVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(ButtonVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(ButtonVariant::getVariantName).collect(Collectors.toList()));
    }

    protected boolean isAutofocusBoolean() {
        return this.getElement().getProperty("autofocus", false);
    }

    protected void setAutofocus(boolean autofocus) {
        this.getElement().setProperty("autofocus", autofocus);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    @Deprecated
    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected void addToPrefix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "prefix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void addToSuffix(Component ... components) {
        for (Component component : components) {
            component.getElement().setAttribute("slot", "suffix");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    protected void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public GeneratedVaadinButton(String text) {
        this.setText(text);
    }

    public GeneratedVaadinButton() {
    }
}

