/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.utils;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class Generics {
    public static Optional<Type> getExactIterableType(Class<?> cls) {
        try {
            Method method = cls.getMethod("iterator", new Class[0]);
            Type exactReturnType = GenericTypeReflector.getExactReturnType((Method)method, cls);
            if (exactReturnType instanceof ParameterizedType) {
                return Optional.of(((ParameterizedType)exactReturnType).getActualTypeArguments()[0]);
            }
            return Optional.empty();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is not an Iterable");
        }
    }
}

