/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.SourceSignatureModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import com.vaadin.hilla.parser.utils.Streams;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.HierarchicalTypeSignature;
import io.github.classgraph.ReferenceTypeSignature;
import io.github.classgraph.TypeParameter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

final class TypeParameterSourceModel
extends TypeParameterModel
implements SourceSignatureModel {
    private final TypeParameter origin;

    TypeParameterSourceModel(TypeParameter origin) {
        this.origin = origin;
    }

    public TypeParameter get() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        AnnotationInfoList annotations = this.origin.getTypeAnnotationInfo();
        return annotations == null ? List.of() : annotations.stream().map(AnnotationInfoModel::of).collect(Collectors.toList());
    }

    @Override
    protected List<SignatureModel> prepareBounds() {
        return Streams.combine((Stream[])new Stream[]{Stream.of(this.getClassBoundSignature()), this.origin.getInterfaceBounds().stream().map(SignatureModel::of)}).distinct().collect(Collectors.toList());
    }

    private @NonNull SignatureModel getClassBoundSignature() {
        ReferenceTypeSignature classBound = this.origin.getClassBound();
        if (classBound == null) {
            return ClassRefSignatureModel.of(Object.class);
        }
        return SignatureModel.of((HierarchicalTypeSignature)classBound);
    }
}

