/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotatedAbstractModel;
import com.vaadin.hilla.parser.models.ClassInfoReflectionModel;
import com.vaadin.hilla.parser.models.ClassInfoSourceModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.FieldInfoModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.Model;
import com.vaadin.hilla.parser.models.NamedModel;
import com.vaadin.hilla.parser.models.PackageInfoModel;
import com.vaadin.hilla.parser.models.ParameterizedModel;
import com.vaadin.hilla.parser.models.SpecializedModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import io.github.classgraph.ClassInfo;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;

public abstract class ClassInfoModel
extends AnnotatedAbstractModel
implements Model,
NamedModel,
SpecializedModel,
ParameterizedModel {
    static final Comparator<ClassInfoModel> CLASS_ORDER = Comparator.comparing(ClassInfoModel::getSimpleName);
    private static final Class<?>[] DATE_CLASSES = new Class[]{Date.class, LocalDate.class};
    private static final Class<?>[] DATE_TIME_CLASSES = new Class[]{LocalDateTime.class, Instant.class, LocalTime.class, OffsetDateTime.class, ZonedDateTime.class};
    private List<FieldInfoModel> fields;
    private List<ClassInfoModel> innerClasses;
    private List<ClassRefSignatureModel> interfaces;
    private List<MethodInfoModel> methods;
    private PackageInfoModel pkg;
    private List<PackageInfoModel> ancestors;
    private Optional<ClassRefSignatureModel> superClass;
    private List<TypeParameterModel> typeParameters;

    public static boolean is(Class<?> actor, String target) {
        return Objects.equals(actor.getName(), target);
    }

    @Deprecated
    public static boolean is(ClassInfo actor, String target) {
        return Objects.equals(actor.getName(), target);
    }

    public static boolean is(Class<?> actor, Class<?> target) {
        return Objects.equals(actor, target);
    }

    public static boolean is(AnnotatedType actor, AnnotatedType target) {
        return Objects.equals(actor, target);
    }

    public static boolean is(AnnotatedType actor, String target) {
        return Objects.equals(actor.getType().getTypeName(), target);
    }

    public static boolean is(Type actor, String target) {
        return Objects.equals(actor.getTypeName(), target);
    }

    @Deprecated
    public static boolean is(ClassInfo actor, Class<?> target) {
        return Objects.equals(actor.getName(), target.getName());
    }

    @Deprecated
    public static boolean is(Class<?> actor, ClassInfo target) {
        return Objects.equals(actor.getName(), target.getName());
    }

    @Deprecated
    public static boolean is(ClassInfo actor, ClassInfo target) {
        return Objects.equals(actor, target);
    }

    public static boolean isAssignableFrom(String target, Class<?> actor) {
        while (actor != null) {
            if (Objects.equals(target, actor.getName())) {
                return true;
            }
            actor = actor.getSuperclass();
        }
        return false;
    }

    @Deprecated
    public static boolean isAssignableFrom(String target, ClassInfo actor) {
        return ClassInfoModel.is(actor, target) || actor.implementsInterface(target) || actor.extendsSuperclass(target);
    }

    public static boolean isAssignableFrom(Class<?> target, Class<?> actor) {
        return target.isAssignableFrom(actor);
    }

    @Deprecated
    public static boolean isAssignableFrom(Class<?> target, ClassInfo actor) {
        return ClassInfoModel.isAssignableFrom(target.getName(), actor);
    }

    @Deprecated
    public static boolean isAssignableFrom(ClassInfo target, Class<?> actor) {
        return ClassInfoModel.isAssignableFrom(target.getName(), actor);
    }

    @Deprecated
    public static boolean isAssignableFrom(ClassInfo target, ClassInfo actor) {
        return ClassInfoModel.isAssignableFrom(target.getName(), actor);
    }

    public static boolean isAssignableFrom(Type target, Type actor) {
        return target instanceof Class && actor instanceof Class && ClassInfoModel.isAssignableFrom((Class)target, (Class)actor);
    }

    public static boolean isAssignableFrom(AnnotatedType target, AnnotatedType actor) {
        return ClassInfoModel.isAssignableFrom(target.getType(), actor.getType());
    }

    public static boolean isAssignableFrom(String target, Type actor) {
        return actor instanceof Class && ClassInfoModel.isAssignableFrom(target, (Class)actor);
    }

    public static boolean isAssignableFrom(String target, AnnotatedType actor) {
        return ClassInfoModel.isAssignableFrom(target, actor.getType());
    }

    public static boolean isAssignableFrom(String target, ClassInfoModel actor) {
        Object _actor = actor.get();
        return _actor instanceof ClassInfo ? ClassInfoModel.isAssignableFrom(target, (ClassInfo)_actor) : ClassInfoModel.isAssignableFrom(target, (Class)_actor);
    }

    public static boolean isAssignableFrom(Class<?> target, ClassInfoModel actor) {
        Object _actor = actor.get();
        return _actor instanceof ClassInfo ? ClassInfoModel.isAssignableFrom(target, (ClassInfo)_actor) : ClassInfoModel.isAssignableFrom(target, (Class)_actor);
    }

    @Deprecated
    public static boolean isAssignableFrom(ClassInfo target, ClassInfoModel actor) {
        Object _actor = actor.get();
        return _actor instanceof ClassInfo ? ClassInfoModel.isAssignableFrom(target, (ClassInfo)_actor) : ClassInfoModel.isAssignableFrom(target, (Class)_actor);
    }

    public static boolean isJDKClass(AnnotatedType cls) {
        return ClassInfoModel.isJDKClass(cls.getType().getTypeName());
    }

    public static boolean isJDKClass(Type cls) {
        return ClassInfoModel.isJDKClass(cls.getTypeName());
    }

    @Deprecated
    public static boolean isJDKClass(ClassInfo cls) {
        return ClassInfoModel.isJDKClass(cls.getName());
    }

    public static boolean isJDKClass(String name) {
        return name.startsWith("java") || name.startsWith("com.sun") || name.startsWith("sun") || name.startsWith("oracle") || name.startsWith("org.xml") || name.startsWith("com.oracle");
    }

    public static boolean isJDKClass(Class<?> cls) {
        return ClassInfoModel.isJDKClass(cls.getName());
    }

    public static boolean isNonJDKClass(String name) {
        return !ClassInfoModel.isJDKClass(name);
    }

    @Deprecated
    public static boolean isNonJDKClass(ClassInfo cls) {
        return !ClassInfoModel.isJDKClass(cls);
    }

    public static boolean isNonJDKClass(Class<?> cls) {
        return !ClassInfoModel.isJDKClass(cls);
    }

    public static boolean isNonJDKClass(Type cls) {
        return !ClassInfoModel.isJDKClass(cls);
    }

    public static boolean isNonJDKClass(AnnotatedType cls) {
        return !ClassInfoModel.isJDKClass(cls);
    }

    @Deprecated
    public static ClassInfoModel of(@Nonnull ClassInfo origin) {
        return new ClassInfoSourceModel(Objects.requireNonNull(origin));
    }

    public static ClassInfoModel of(@Nonnull Class<?> origin) {
        return new ClassInfoReflectionModel(Objects.requireNonNull(origin));
    }

    protected static <T> boolean isDateAssignable(T actor, BiPredicate<Class<?>, T> predicate) {
        return Arrays.stream(DATE_CLASSES).anyMatch(cls -> predicate.test((Class<?>)cls, actor));
    }

    protected static <T> boolean isDateTimeAssignable(T actor, BiPredicate<Class<?>, T> predicate) {
        return Arrays.stream(DATE_TIME_CLASSES).anyMatch(cls -> predicate.test((Class<?>)cls, actor));
    }

    public final Optional<ClassRefSignatureModel> getSuperClass() {
        if (this.superClass == null) {
            this.superClass = Optional.ofNullable(this.prepareSuperClass());
        }
        return this.superClass;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassInfoModel)) {
            return false;
        }
        ClassInfoModel other = (ClassInfoModel)obj;
        return this.getName().equals(other.getName());
    }

    public Class<ClassInfoModel> getCommonModelClass() {
        return ClassInfoModel.class;
    }

    public List<FieldInfoModel> getFields() {
        if (this.fields == null) {
            this.fields = this.prepareFields();
        }
        return this.fields;
    }

    public List<ClassInfoModel> getInheritanceChain() {
        ArrayList<ClassInfoModel> chain = new ArrayList<ClassInfoModel>();
        ClassInfoModel current = this;
        while (current != null && ClassInfoModel.isNonJDKClass(current.getName())) {
            chain.add(current);
            current = current.getSuperClass().map(ClassRefSignatureModel::getClassInfo).orElse(null);
        }
        return chain;
    }

    public List<ClassInfoModel> getInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = this.prepareInnerClasses();
        }
        return this.innerClasses;
    }

    public List<ClassRefSignatureModel> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.prepareInterfaces();
        }
        return this.interfaces;
    }

    public List<MethodInfoModel> getMethods() {
        if (this.methods == null) {
            this.methods = this.prepareMethods();
        }
        return this.methods;
    }

    public PackageInfoModel getPackage() {
        if (this.pkg == null) {
            this.pkg = this.preparePackage();
        }
        return this.pkg;
    }

    public abstract String getSimpleName();

    @Override
    public List<TypeParameterModel> getTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = this.prepareTypeParameters();
        }
        return this.typeParameters;
    }

    public int hashCode() {
        return 3 + this.getName().hashCode();
    }

    public boolean is(String name) {
        Object origin = this.get();
        return origin instanceof ClassInfo ? ClassInfoModel.is((ClassInfo)origin, name) : ClassInfoModel.is((Class)origin, name);
    }

    public boolean is(Class<?> cls) {
        Object origin = this.get();
        return origin instanceof ClassInfo ? ClassInfoModel.is((ClassInfo)origin, cls) : ClassInfoModel.is((Class)origin, cls);
    }

    public boolean is(Type cls) {
        return cls instanceof Class && this.is((Class)cls);
    }

    public boolean is(AnnotatedType cls) {
        return this.is(cls.getType());
    }

    @Deprecated
    public boolean is(ClassInfo cls) {
        Object origin = this.get();
        return origin instanceof ClassInfo ? ClassInfoModel.is((ClassInfo)origin, cls) : ClassInfoModel.is((Class)origin, cls);
    }

    public boolean is(ClassInfoModel model) {
        Object cls = model.get();
        return cls instanceof ClassInfo ? this.is((ClassInfo)cls) : this.is((Class)cls);
    }

    public abstract boolean isAbstract();

    public abstract boolean isAnnotation();

    public abstract boolean isArrayClass();

    public boolean isAssignableFrom(ClassInfoModel model) {
        Object _model = model.get();
        return _model instanceof ClassInfo ? this.isAssignableFrom((ClassInfo)_model) : this.isAssignableFrom((Class)_model);
    }

    @Deprecated
    public boolean isAssignableFrom(ClassInfo cls) {
        Object origin = this.get();
        return origin instanceof ClassInfo ? ClassInfoModel.isAssignableFrom((ClassInfo)origin, cls) : ClassInfoModel.isAssignableFrom((Class)origin, cls);
    }

    public boolean isAssignableFrom(Class<?> cls) {
        Object origin = this.get();
        return origin instanceof ClassInfo ? ClassInfoModel.isAssignableFrom((ClassInfo)origin, cls) : ClassInfoModel.isAssignableFrom((Class)origin, cls);
    }

    public boolean isAssignableFrom(AnnotatedType cls) {
        return this.isAssignableFrom(cls.getClass());
    }

    @Override
    public abstract boolean isEnum();

    public abstract boolean isFinal();

    public abstract boolean isInterface();

    public abstract boolean isInterfaceOrAnnotation();

    public boolean isNative() {
        return false;
    }

    public abstract boolean isPrivate();

    public abstract boolean isProtected();

    public abstract boolean isPublic();

    public abstract boolean isStandardClass();

    public abstract boolean isStatic();

    public abstract boolean isSynthetic();

    public String toString() {
        return "ClassInfoModel[" + this.get() + "]";
    }

    protected abstract List<FieldInfoModel> prepareFields();

    protected abstract List<ClassInfoModel> prepareInnerClasses();

    protected abstract List<ClassRefSignatureModel> prepareInterfaces();

    protected abstract List<MethodInfoModel> prepareMethods();

    protected abstract PackageInfoModel preparePackage();

    protected abstract ClassRefSignatureModel prepareSuperClass();

    protected abstract List<TypeParameterModel> prepareTypeParameters();
}

