/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.core;

import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.RootNode;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PluginExecutor.class);
    private final Set<NodePath<?>> enqueued = new HashSet();
    private final Plugin plugin;
    private final Deque<Task> queue = new LinkedList<Task>();
    private final RootNode rootNode;
    private final Map<Node<?, ?>, NodeScanResult> scanResults = new HashMap();

    public PluginExecutor(@Nonnull Plugin plugin, @Nonnull RootNode rootNode) {
        this.plugin = Objects.requireNonNull(plugin);
        this.rootNode = Objects.requireNonNull(rootNode);
    }

    public void execute() {
        NodePath<RootNode> rootPath = NodePath.forRoot(this.rootNode);
        this.enqueueEnterFirst(rootPath);
        while (!this.queue.isEmpty()) {
            this.queue.removeFirst().execute();
        }
    }

    private void enqueueEnterFirst(NodePath<?> path) {
        if (this.enqueued.contains(path)) {
            return;
        }
        this.queue.addFirst(new EnterTask(path));
        this.enqueued.add(path);
    }

    private void enqueueEnterLast(NodePath<?> path) {
        if (this.enqueued.contains(path)) {
            return;
        }
        Task lastTask = this.queue.removeLast();
        this.queue.addLast(new EnterTask(path));
        this.queue.addLast(lastTask);
        this.enqueued.add(path);
    }

    private void enqueueExitFirst(NodePath<?> path) {
        this.queue.addFirst(new ExitTask(path));
    }

    @Nonnull
    private NodeScanResult scanNodeDependencies(Node<?, ?> node) {
        return this.scanResults.computeIfAbsent(node, n -> new NodeScanResult(this.plugin.scan(new NodeDependencies((Node<?, ?>)n, Stream.empty(), Stream.empty()))));
    }

    private static abstract class Task {
        private final NodePath<?> path;

        public Task(@Nonnull NodePath<?> path) {
            this.path = Objects.requireNonNull(path);
        }

        protected NodePath<?> getPath() {
            return this.path;
        }

        abstract void execute();
    }

    private class EnterTask
    extends Task {
        public EnterTask(NodePath<?> path) {
            super(path);
        }

        @Override
        void execute() {
            NodeScanResult scanResult = PluginExecutor.this.scanNodeDependencies(this.getPath().getNode());
            PluginExecutor.this.plugin.enter(this.getPath());
            PluginExecutor.this.enqueueExitFirst(this.getPath());
            LinkedList reverseChildList = new LinkedList();
            scanResult.getChildNodes().stream().map(node -> PluginExecutor.this.plugin.resolve((Node<?, ?>)node, this.getPath())).map(this.getPath()::withChildNode).forEachOrdered(reverseChildList::addFirst);
            reverseChildList.forEach(PluginExecutor.this::enqueueEnterFirst);
            scanResult.getRelatedNodes().stream().map(node -> PluginExecutor.this.plugin.resolve((Node<?, ?>)node, this.getPath().getRootPath())).map(this.getPath().getRootPath()::withChildNode).forEachOrdered(PluginExecutor.this::enqueueEnterLast);
        }
    }

    private class ExitTask
    extends Task {
        public ExitTask(NodePath<?> path) {
            super(path);
        }

        @Override
        void execute() {
            PluginExecutor.this.plugin.exit(this.getPath());
        }
    }

    private static class NodeScanResult {
        private final List<Node<?, ?>> childNodes;
        private final Node<?, ?> node;
        private final List<Node<?, ?>> relatedNodes;

        public NodeScanResult(@Nonnull NodeDependencies nodeDependencies) {
            Objects.requireNonNull(nodeDependencies);
            this.node = nodeDependencies.getNode();
            this.childNodes = nodeDependencies.getChildNodes().collect(Collectors.toList());
            this.relatedNodes = nodeDependencies.getRelatedNodes().collect(Collectors.toList());
        }

        @Nonnull
        public List<Node<?, ?>> getChildNodes() {
            return this.childNodes;
        }

        @Nonnull
        public Node<?, ?> getNode() {
            return this.node;
        }

        @Nonnull
        public List<Node<?, ?>> getRelatedNodes() {
            return this.relatedNodes;
        }
    }
}

