/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.vaadin.hilla.engine.BrowserCallableFinderException;
import com.vaadin.hilla.engine.EngineAutoConfiguration;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.tools.MainClassFinder;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;

public class AotBrowserCallableFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AotBrowserCallableFinder.class);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final String SPRING_AOT_PROCESSOR = "org.springframework.boot.SpringApplicationAotProcessor";
    private static final String METADATA_FILE_NAME = "reachability-metadata.json";

    public static List<Class<?>> find(EngineAutoConfiguration engineConfiguration) throws BrowserCallableFinderException {
        try {
            String applicationClass = AotBrowserCallableFinder.determineApplicationClass(engineConfiguration);
            if (applicationClass == null) {
                throw new BrowserCallableFinderException("Application has no main class");
            }
            Path reflectConfigPath = AotBrowserCallableFinder.generateAotArtifacts(engineConfiguration, applicationClass);
            return AotBrowserCallableFinder.loadAnnotatedClasses(engineConfiguration, reflectConfigPath);
        }
        catch (Exception e) {
            if (e instanceof BrowserCallableFinderException) {
                BrowserCallableFinderException bce = (BrowserCallableFinderException)e;
                throw bce;
            }
            throw new BrowserCallableFinderException(e);
        }
    }

    private static String determineApplicationClass(EngineAutoConfiguration engineConfiguration) {
        String mainClass = engineConfiguration.getMainClass();
        if (mainClass != null) {
            return mainClass;
        }
        try {
            mainClass = engineConfiguration.getClassesDirs().stream().map(path -> {
                try {
                    return MainClassFinder.findSingleMainClass((File)path.toFile(), (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
                }
                catch (IOException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElse(null);
            if (mainClass == null) {
                LOGGER.debug("This project has not been recognized as a Spring Boot application because a main class could not be found.");
            }
            return mainClass;
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Spring Boot org.springframework.boot.loader.tools.MainClassFinder class not found. Can happen when a Maven project is configured to use com.vaadin:flow-maven-plugin instead of com.vaadin:vaadin-maven-plugin, for example projects using Vaadin Multiplatform Runtime. If Hilla is not a project requirement exclude it from the dependency tree, otherwise consider replacing com.vaadin:flow-maven-plugin with com.vaadin:hilla-maven-plugin.");
            return null;
        }
    }

    private static Path generateAotArtifacts(EngineAutoConfiguration engineConfiguration, String applicationClass) throws IOException, InterruptedException, BrowserCallableFinderException {
        Path json;
        Path aotOutput = engineConfiguration.getBuildDir().resolve("spring-aot/main");
        Path classesDirectory = aotOutput.resolve("classes");
        List<Path> classpath = engineConfiguration.getClasspath().stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        List<String> settings = Stream.of("-cp", classpath.stream().map(AotBrowserCallableFinder::quotePath).collect(Collectors.joining(File.pathSeparator)), SPRING_AOT_PROCESSOR, applicationClass, AotBrowserCallableFinder.quotePath(aotOutput.resolve("sources")), AotBrowserCallableFinder.quotePath(aotOutput.resolve("resources")), AotBrowserCallableFinder.quotePath(classesDirectory), engineConfiguration.getGroupId(), engineConfiguration.getArtifactId()).toList();
        Path argsFile = engineConfiguration.getBuildDir().resolve("hilla-aot-args.txt");
        Files.write(argsFile, settings, new OpenOption[0]);
        Path report = engineConfiguration.getBuildDir().resolve("hilla-aot-report.txt");
        String javaExecutable = ProcessHandle.current().info().command().orElse(Path.of(System.getProperty("java.home"), "bin", "java").toString());
        Process process = new ProcessBuilder(new String[0]).inheritIO().command(javaExecutable, "@" + String.valueOf(argsFile)).redirectOutput(report.toFile()).redirectErrorStream(true).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            LOGGER.debug("org.springframework.boot.SpringApplicationAotProcessor exited with code " + exitCode + ". The output of the process is available in " + String.valueOf(report));
        }
        if (!Files.isRegularFile(json = aotOutput.resolve(Path.of("resources", "META-INF", "native-image", engineConfiguration.getGroupId(), engineConfiguration.getArtifactId(), METADATA_FILE_NAME)), new LinkOption[0])) {
            throw new BrowserCallableFinderException(String.format("The `%s` tool has not produced the expected `%s` file, which is used to identify available endpoints.", SPRING_AOT_PROCESSOR, METADATA_FILE_NAME));
        }
        return json;
    }

    private static List<Class<?>> loadAnnotatedClasses(EngineAutoConfiguration engineConfiguration, Path reflectConfigPath) throws IOException, BrowserCallableFinderException {
        JsonNode reflectionsNode;
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonContent = Files.readString(reflectConfigPath);
        JsonNode rootNode = objectMapper.readTree(jsonContent);
        if (!rootNode.isObject()) {
            AotBrowserCallableFinder.throwUnknownMetadataFormat("root node is not an object");
        }
        if ((reflectionsNode = rootNode.get("reflection")) == null) {
            AotBrowserCallableFinder.throwUnknownMetadataFormat("\"reflection\" key is null");
        }
        if (!reflectionsNode.isArray()) {
            AotBrowserCallableFinder.throwUnknownMetadataFormat("\"reflection\" key is not an array");
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (JsonNode node : reflectionsNode) {
            JsonNode typeNode = node.get("type");
            if (typeNode.isString()) {
                String type2 = node.get("type").asString();
                candidates.add(type2);
                continue;
            }
            LOGGER.trace("Ignoring non-string type for property {}", (Object)typeNode);
        }
        List<String> annotationNames = engineConfiguration.getEndpointAnnotations().stream().map(Class::getName).toList();
        ClassLoader classLoader = engineConfiguration.getClassLoader();
        List<Class<?>> result = candidates.stream().map(type -> {
            try {
                return Class.forName(type, false, classLoader);
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to load class {}: {}", type, (Object)t.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(cls -> {
            List<String> annotations = Arrays.stream(cls.getAnnotations()).map(Annotation::annotationType).map(Class::getName).toList();
            return annotations.stream().anyMatch(annotationNames::contains);
        }).collect(Collectors.toList());
        return result;
    }

    private static String quotePath(Path path) {
        return "\"" + path.toString().replace("\\", "\\\\") + "\"";
    }

    private static void throwUnknownMetadataFormat(String reason) throws BrowserCallableFinderException {
        throw new BrowserCallableFinderException(String.format("Unable to read information about beans from the AOT metadata output file `%s`: %s", METADATA_FILE_NAME, reason));
    }
}

