/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.ParserException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.tools.MainClassFinder;

class AotBrowserCallableFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AotBrowserCallableFinder.class);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final String SPRING_AOT_PROCESSOR = "org.springframework.boot.SpringApplicationAotProcessor";

    AotBrowserCallableFinder() {
    }

    static List<Class<?>> findEndpointClasses(EngineConfiguration engineConfiguration) throws IOException, InterruptedException {
        String applicationClass = AotBrowserCallableFinder.determineApplicationClass(engineConfiguration);
        if (applicationClass == null) {
            return List.of();
        }
        Path reflectConfigPath = AotBrowserCallableFinder.generateAotArtifacts(engineConfiguration, applicationClass);
        return AotBrowserCallableFinder.loadAnnotatedClasses(engineConfiguration, reflectConfigPath);
    }

    private static String determineApplicationClass(EngineConfiguration engineConfiguration) {
        String mainClass = engineConfiguration.getMainClass();
        if (mainClass != null) {
            return mainClass;
        }
        try {
            mainClass = engineConfiguration.getClassesDirs().stream().map(path -> {
                try {
                    return MainClassFinder.findSingleMainClass((File)path.toFile(), (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
                }
                catch (IOException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElse(null);
            if (mainClass == null) {
                LOGGER.debug("This project has not been recognized as a Spring Boot application because a main class could not be found.");
            }
            return mainClass;
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Spring Boot org.springframework.boot.loader.tools.MainClassFinder class not found. Can happen when a Maven project is configured to use com.vaadin:flow-maven-plugin instead of com.vaadin:vaadin-maven-plugin, for example projects using Vaadin Multiplatform Runtime. If Hilla is not a project requirement exclude it from the dependency tree, otherwise consider replacing com.vaadin:flow-maven-plugin with com.vaadin:hilla-maven-plugin.");
            return null;
        }
    }

    private static Path generateAotArtifacts(EngineConfiguration engineConfiguration, String applicationClass) throws IOException, InterruptedException {
        Path json;
        Path aotOutput = engineConfiguration.getBuildDir().resolve("spring-aot/main");
        Path classesDirectory = aotOutput.resolve("classes");
        List<Path> classpath = engineConfiguration.getClasspath().stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        List<String> settings = Stream.of("-cp", classpath.stream().map(AotBrowserCallableFinder::quotePath).collect(Collectors.joining(File.pathSeparator)), SPRING_AOT_PROCESSOR, applicationClass, AotBrowserCallableFinder.quotePath(aotOutput.resolve("sources")), AotBrowserCallableFinder.quotePath(aotOutput.resolve("resources")), AotBrowserCallableFinder.quotePath(classesDirectory), engineConfiguration.getGroupId(), engineConfiguration.getArtifactId()).toList();
        Path argsFile = engineConfiguration.getBuildDir().resolve("hilla-aot-args.txt");
        Files.write(argsFile, settings, new OpenOption[0]);
        Path report = engineConfiguration.getBuildDir().resolve("hilla-aot-report.txt");
        String javaExecutable = ProcessHandle.current().info().command().orElse(Path.of(System.getProperty("java.home"), "bin", "java").toString());
        Process process = new ProcessBuilder(new String[0]).inheritIO().command(javaExecutable, "@" + argsFile).redirectOutput(report.toFile()).redirectErrorStream(true).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            LOGGER.debug("org.springframework.boot.SpringApplicationAotProcessor exited with code " + exitCode + ". The output of the process is available in " + report);
        }
        if (!Files.isRegularFile(json = aotOutput.resolve(Path.of("resources", "META-INF", "native-image", engineConfiguration.getGroupId(), engineConfiguration.getArtifactId(), "reflect-config.json")), new LinkOption[0])) {
            throw new ParserException(String.format("The `%s` tool has not produced the expected `reflect-config.json` file, which is used to identify available endpoints.", SPRING_AOT_PROCESSOR));
        }
        return json;
    }

    private static List<Class<?>> loadAnnotatedClasses(EngineConfiguration engineConfiguration, Path reflectConfigPath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonContent = Files.readString(reflectConfigPath);
        JsonNode rootNode = objectMapper.readTree(jsonContent);
        if (!rootNode.isArray()) {
            throw new ParserException("Aot output file reflect-config.json does not contain information about beans, so endpoint detection cannot be performed");
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (JsonNode node : rootNode) {
            String name2 = node.get("name").asText();
            candidates.add(name2);
        }
        List<Path> classpath = engineConfiguration.getClasspath().stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        URL[] urls = (URL[])classpath.stream().map(Path::toFile).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (Throwable t) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        List<String> annotationNames = engineConfiguration.getParser().getEndpointAnnotations().stream().map(Class::getName).toList();
        URLClassLoader classLoader = new URLClassLoader(urls, AotBrowserCallableFinder.class.getClassLoader());
        return candidates.stream().map(name -> {
            try {
                return Class.forName(name, false, classLoader);
            }
            catch (Throwable t) {
                return null;
            }
        }).filter(Objects::nonNull).filter(cls -> Arrays.stream(cls.getAnnotations()).map(Annotation::annotationType).map(Class::getName).anyMatch(annotationNames::contains)).collect(Collectors.toList());
    }

    private static String quotePath(Path path) {
        return "\"" + path.toString().replace("\\", "\\\\") + "\"";
    }
}

