/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.fusion;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.connect.generator.OpenApiSpecGenerator;
import com.vaadin.flow.server.frontend.TaskGenerateOpenApi;
import com.vaadin.flow.server.frontend.fusion.AbstractTaskConnectGenerator;
import java.io.File;
import java.util.Collections;
import java.util.Objects;

public class TaskGenerateOpenApiImpl
extends AbstractTaskConnectGenerator
implements TaskGenerateOpenApi {
    private final File javaSourceFolder;
    private final ClassLoader classLoader;
    private final File output;

    TaskGenerateOpenApiImpl(File properties, File javaSourceFolder, ClassLoader classLoader, File output) {
        super(properties);
        Objects.requireNonNull(javaSourceFolder, "Source paths should not be null.");
        Objects.requireNonNull(output, "OpenAPI output file should not be null.");
        Objects.requireNonNull(classLoader, "ClassLoader should not be null.");
        this.javaSourceFolder = javaSourceFolder;
        this.classLoader = classLoader;
        this.output = output;
    }

    public void execute() throws ExecutionFailedException {
        OpenApiSpecGenerator openApiSpecGenerator = new OpenApiSpecGenerator(this.readApplicationProperties());
        openApiSpecGenerator.generateOpenApiSpec(Collections.singletonList(this.javaSourceFolder.toPath()), this.classLoader, this.output.toPath());
    }
}

