/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.fusion;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.connect.generator.VaadinConnectClientGenerator;
import com.vaadin.flow.server.connect.generator.VaadinConnectTsGenerator;
import com.vaadin.flow.server.frontend.TaskGenerateConnect;
import com.vaadin.flow.server.frontend.fusion.AbstractTaskConnectGenerator;
import java.io.File;
import java.util.Objects;

public class TaskGenerateConnectImpl
extends AbstractTaskConnectGenerator
implements TaskGenerateConnect {
    private final File outputFolder;
    private final File openApi;
    private final File connectClientFile;
    private final File frontendDirectory;

    TaskGenerateConnectImpl(File applicationProperties, File openApi, File outputFolder, File frontendDirectory) {
        super(applicationProperties);
        Objects.requireNonNull(openApi, "Vaadin OpenAPI file should not be null.");
        Objects.requireNonNull(outputFolder, "Vaadin output folder should not be null.");
        this.openApi = openApi;
        this.outputFolder = outputFolder;
        this.connectClientFile = new File(outputFolder, "connect-client.default.ts");
        this.frontendDirectory = frontendDirectory;
    }

    public void execute() throws ExecutionFailedException {
        String customName;
        File customConnectClient = new File(this.frontendDirectory, "connect-client.ts");
        String string = customName = customConnectClient.exists() ? "../connect-client.ts" : null;
        if (VaadinConnectTsGenerator.launch(this.openApi, this.outputFolder, customName)) {
            new VaadinConnectClientGenerator(this.readApplicationProperties()).generateVaadinConnectClientFile(this.connectClientFile.toPath());
        }
    }
}

