/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.testbench.ElementQuery;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Element(value="vaadin-dev-tools")
public class DevToolsElement
extends TestBenchElement {
    private TestBenchElement getIcon() {
        return this.$("*").attributeContains("class", "dev-tools").first();
    }

    private List<TestBenchElement> getLogDivs(boolean onlyError) {
        ElementQuery<TestBenchElement> divs = this.getLogDivsQuery(onlyError);
        return divs.all();
    }

    private ElementQuery<TestBenchElement> getLogDivsQuery(boolean onlyError) {
        ElementQuery divs = this.$("div").attributeContains("class", "message");
        if (onlyError) {
            divs = divs.attributeContains("class", "error");
        }
        return divs;
    }

    public List<String> getLogRows() {
        return this.getLogDivs(false).stream().map(div -> div.getText()).collect(Collectors.toList());
    }

    public List<String> getErrorLogRows() {
        return this.getLogDivs(true).stream().map(div -> div.getText()).collect(Collectors.toList());
    }

    public String getFirstErrorLogRow() {
        return this.getLogDivsQuery(true).first().getText();
    }

    public String getLastErrorLogRow() {
        return this.getLogDivsQuery(true).last().getText();
    }

    public void waitForErrorMessage(Predicate<String> matcher) {
        this.expand();
        this.waitUntil(driver -> this.getErrorLogRows().stream().anyMatch(matcher));
    }

    public void waitForLastErrorMessageToMatch(Predicate<String> matcher) {
        this.expand();
        this.waitUntil(driver -> matcher.test(this.getLastErrorLogRow()));
    }

    public void expand() {
        if (this.isExpanded()) {
            return;
        }
        this.getIcon().click();
    }

    public boolean isExpanded() {
        return this.getPropertyBoolean(new String[]{"expanded"});
    }

    public int getNumberOfLogRows() {
        return this.getLogDivsQuery(false).all().size();
    }

    public int getNumberOfErrorLogRows() {
        return this.getLogDivsQuery(true).all().size();
    }

    public void setLiveReload(boolean enabled) {
        this.expand();
        this.showTab("info");
        TestBenchElement toggle = this.$("input").id("toggle");
        if (toggle.getPropertyBoolean(new String[]{"checked"}) != enabled) {
            toggle.click();
        }
    }

    private void showTab(String id) {
        this.$("button").attributeContains("class", "tab").id(id).click();
    }

    public void showExperimentalFeatures() {
        this.showTab("features");
    }

    public List<String> listExperimentalFeatures() {
        return (List)this.executeScript("return Array.from(arguments[0].shadowRoot.querySelectorAll('.features-tray .feature label')).map(e => e.textContent.trim())", new Object[]{this});
    }
}

