/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGenerateTailwindCss
extends AbstractTaskClientGenerator {
    private static final String RELATIVE_SOURCE_PATH_MARKER = "#relativeSourcePath#";
    private static final String CSS_IMPORT_MARKER = "/* #cssImport# */";
    private static final String STYLES_CSS = "styles.css";
    private static final Logger log = LoggerFactory.getLogger(TaskGenerateTailwindCss.class);
    private final String relativeSourcePath;
    private final String themeImportReplacement;
    private final File tailwindCss;

    TaskGenerateTailwindCss(Options options) {
        this.tailwindCss = new File(options.getFrontendGeneratedFolder(), "tailwind.css");
        this.relativeSourcePath = options.getFrontendGeneratedFolder().toPath().relativize(options.getNpmFolder().toPath().resolve("src")).toString().replace(File.separator, "/");
        this.themeImportReplacement = this.buildCssImports(options);
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream indexStream = this.getClass().getResourceAsStream("tailwind.css");){
            String template = StringUtil.toUTF8String(indexStream);
            template = template.replace(RELATIVE_SOURCE_PATH_MARKER, this.relativeSourcePath);
            String string = template = template.replace(CSS_IMPORT_MARKER, this.themeImportReplacement);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return this.tailwindCss;
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }

    private String buildCssImports(Options options) {
        StringBuilder imports = new StringBuilder();
        TaskGenerateTailwindCss.addThemeImportIfAvailable(options, imports);
        this.addCssImports(options, imports);
        return imports.toString();
    }

    private static void addThemeImportIfAvailable(Options options, StringBuilder imports) {
        FrontendDependenciesScanner frontendDependenciesScanner = options.getFrontendDependenciesScanner();
        String themeName = "";
        if (frontendDependenciesScanner != null && frontendDependenciesScanner.getThemeDefinition() != null) {
            themeName = frontendDependenciesScanner.getThemeDefinition().getName();
        }
        if (themeName != null && !themeName.isEmpty()) {
            String themePath = "themes/" + themeName + "/styles.css";
            Path frontendGeneratedFolder = options.getFrontendGeneratedFolder().toPath();
            File stylesCss = new File(options.getFrontendDirectory(), themePath);
            if (stylesCss.exists()) {
                String relativePath = frontendGeneratedFolder.relativize(stylesCss.toPath()).toString().replace(File.separator, "/");
                imports.append("@import '").append(relativePath).append("';\n");
            } else if (options.getJarFrontendResourcesFolder() != null && (stylesCss = new File(options.getJarFrontendResourcesFolder(), themePath)).exists()) {
                String relativePath = frontendGeneratedFolder.relativize(stylesCss.toPath()).toString().replace(File.separator, "/");
                imports.append("@import './").append(relativePath).append("';\n");
            }
        }
    }

    private void addCssImports(Options options, StringBuilder imports) {
        Collection cssImports = options.getFrontendDependenciesScanner().getCss().values().stream().flatMap(Collection::stream).map(CssData::getValue).collect(Collectors.toList());
        cssImports.addAll(this.collectStyleSheetAnnotations(options));
        for (String cssPath : cssImports) {
            String cssFile;
            if (cssPath == null || cssPath.isEmpty() || (cssFile = this.resolveCssFile(options, cssPath)) == null) continue;
            imports.append("@import '").append(cssFile).append("';\n");
        }
    }

    private String resolveCssFile(Options options, String cssPath) {
        if (cssPath.startsWith("Frontend/")) {
            cssPath = cssPath.substring("Frontend/".length());
        }
        if (cssPath.startsWith("./")) {
            cssPath = cssPath.substring(2);
        }
        Path frontendGeneratedFolder = options.getFrontendGeneratedFolder().toPath();
        File cssFile = new File(options.getFrontendDirectory(), cssPath);
        if (cssFile.exists()) {
            String relativePath = frontendGeneratedFolder.relativize(cssFile.toPath()).toString().replace(File.separator, "/");
            return "./" + relativePath;
        }
        if (options.getJarFrontendResourcesFolder() != null && (cssFile = new File(options.getJarFrontendResourcesFolder(), cssPath)).exists()) {
            String relativePath = frontendGeneratedFolder.relativize(cssFile.toPath()).toString().replace(File.separator, "/");
            return "./" + relativePath;
        }
        File resourcesFolder = options.getNpmFolder().toPath().resolve("src/main/resources/META-INF/resources/").toFile();
        if (resourcesFolder.exists() && (cssFile = new File(resourcesFolder, cssPath)).exists()) {
            return options.getFrontendGeneratedFolder().toPath().relativize(cssFile.toPath()).toString().replace(File.separator, "/");
        }
        return null;
    }

    private Set<String> collectStyleSheetAnnotations(Options options) {
        HashSet<String> cssPaths = new HashSet<String>();
        ClassFinder classFinder = options.getClassFinder();
        if (classFinder == null) {
            log.debug("ClassFinder not available, skipping scan");
            return cssPaths;
        }
        try {
            for (Class<?> clazz : classFinder.getAnnotatedClasses(StyleSheet.class)) {
                for (StyleSheet annotation : (StyleSheet[])clazz.getAnnotationsByType(StyleSheet.class)) {
                    String value = annotation.value();
                    if (!this.isLocalStylesheet(value)) continue;
                    cssPaths.add(value);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error scanning for @StyleSheet annotations", (Throwable)e);
        }
        return cssPaths;
    }

    private boolean isLocalStylesheet(String path) {
        if (path == null || path.isBlank()) {
            return false;
        }
        String lower = path.toLowerCase();
        return !lower.startsWith("http://") && !lower.startsWith("https://");
    }
}

