/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.internal.UrlUtil;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryParameters
implements Serializable {
    private static final String PARAMETER_VALUES_SEPARATOR = "=";
    private static final String PARAMETERS_SEPARATOR = "&";
    private final Map<String, List<String>> parameters;

    public QueryParameters(Map<String, List<String>> parameters) {
        this.parameters = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())))));
    }

    public static QueryParameters empty() {
        return new QueryParameters(Collections.emptyMap());
    }

    public static QueryParameters full(Map<String, String[]> parameters) {
        return new QueryParameters(QueryParameters.convertArraysToLists(parameters));
    }

    private static Map<String, List<String>> convertArraysToLists(Map<String, String[]> fullParameters) {
        return fullParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((String[])entry.getValue())));
    }

    public static QueryParameters simple(Map<String, String> parameters) {
        return new QueryParameters(QueryParameters.toFullParameters(parameters));
    }

    private static Map<String, List<String>> toFullParameters(Map<String, String> simpleParameters) {
        return simpleParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue())));
    }

    public static QueryParameters of(String key, String value) {
        return QueryParameters.simple(Collections.singletonMap(key, value));
    }

    public static QueryParameters fromString(String queryString) {
        if (queryString == null || queryString.isBlank()) {
            return QueryParameters.empty();
        }
        return new QueryParameters(QueryParameters.parseQueryString(queryString));
    }

    private static Map<String, List<String>> parseQueryString(String query) {
        return Arrays.stream(query.split(PARAMETERS_SEPARATOR)).map(QueryParameters::makeQueryParamList).collect(Collectors.toMap(List::getFirst, QueryParameters::getParameterValues, QueryParameters::mergeLists));
    }

    private static List<String> makeQueryParamList(String paramAndValue) {
        int index = paramAndValue.indexOf(61);
        if (index == -1) {
            return Collections.singletonList(QueryParameters.decode(paramAndValue));
        }
        String param = paramAndValue.substring(0, index);
        String value = paramAndValue.substring(index + 1);
        return Arrays.asList(QueryParameters.decode(param), QueryParameters.decode(value));
    }

    private static List<String> getParameterValues(List<String> paramAndValue) {
        if (paramAndValue.size() == 1) {
            return Collections.singletonList("");
        }
        return Collections.singletonList(paramAndValue.get(1));
    }

    private static List<String> mergeLists(List<String> list1, List<String> list2) {
        ArrayList<String> result = new ArrayList<String>(list1);
        if (result.isEmpty()) {
            result.add(null);
        }
        if (list2.isEmpty()) {
            result.add(null);
        } else {
            result.addAll(list2);
        }
        return result;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public List<String> getParameters(String key) {
        return this.parameters.getOrDefault(key, Collections.emptyList());
    }

    public Optional<String> getSingleParameter(String key) {
        return this.parameters.getOrDefault(key, Collections.emptyList()).stream().findFirst();
    }

    public String getQueryString() {
        return this.parameters.entrySet().stream().flatMap(this::getParameterAndValues).collect(Collectors.joining(PARAMETERS_SEPARATOR));
    }

    public QueryParameters excluding(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        HashMap<String, List<String>> newParameters = new HashMap<String, List<String>>(this.parameters);
        Stream.of(keys).forEach(newParameters::remove);
        return new QueryParameters(newParameters);
    }

    public QueryParameters including(String ... keys) {
        if (keys == null || keys.length == 0) {
            return QueryParameters.empty();
        }
        Set<String> includedKeys = Set.of(keys);
        Map<String, List<String>> newParameters = this.parameters.entrySet().stream().filter(entry -> includedKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new QueryParameters(newParameters);
    }

    public QueryParameters merging(String key, String ... values) {
        if (key == null || key.isEmpty() || values == null || values.length == 0) {
            throw new IllegalArgumentException("Parameter missing");
        }
        HashMap<String, List<String>> newParameters = new HashMap<String, List<String>>(this.parameters);
        List<String> newValues = List.of(values);
        newParameters.put(key, newValues);
        return new QueryParameters(newParameters);
    }

    public QueryParameters mergingAll(Map<String, List<String>> parameters) {
        Objects.requireNonNull(parameters);
        HashMap<String, List<String>> newParameters = new HashMap<String, List<String>>(this.parameters);
        newParameters.putAll(parameters);
        return new QueryParameters(newParameters);
    }

    private Stream<String> getParameterAndValues(Map.Entry<String, List<String>> entry) {
        String param = entry.getKey();
        List<String> values = entry.getValue();
        if (values.size() == 1 && "".equals(values.getFirst())) {
            return Stream.of(UrlUtil.encodeURIComponent(entry.getKey()));
        }
        return values.stream().map(value -> "".equals(value) ? UrlUtil.encodeURIComponent(param) : UrlUtil.encodeURIComponent(param) + PARAMETER_VALUES_SEPARATOR + UrlUtil.encodeURIComponent(value));
    }

    private static String decode(String parameter) {
        return URLDecoder.decode(parameter, StandardCharsets.UTF_8);
    }

    public String toString() {
        return "QueryParameters(" + this.getQueryString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParameters) {
            QueryParameters o = (QueryParameters)obj;
            return this.parameters.equals(o.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }
}

