/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.SessionExpiredHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class TranslationFileRequestHandler
extends SynchronizedRequestHandler
implements SessionExpiredHandler {
    static final String LANGUAGE_TAG_PARAMETER_NAME = "langtag";
    static final String CHUNK_PARAMETER_NAME = "chunks";
    static final String KEYS_PARAMETER_NAME = "keys";
    static final String RETRIEVED_LOCALE_HEADER_NAME = "X-Vaadin-Retrieved-Locale";
    static final String CHUNK_RESOURCE = "vaadin-i18n/i18n.json";
    private final I18NProvider i18NProvider;
    private final ClassLoader classLoader;
    private Map<String, String[]> chunkData;

    public TranslationFileRequestHandler(I18NProvider i18NProvider, ClassLoader classLoader) {
        this.i18NProvider = i18NProvider;
        this.classLoader = classLoader;
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        this.handleTranslationRequest(request.getService(), request, response);
        return true;
    }

    @Override
    public boolean handleSessionExpired(VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.canHandleRequest(request)) {
            this.handleTranslationRequest(request.getService(), request, response);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.TRANSLATION_FILE);
    }

    private void handleTranslationRequest(VaadinService service, VaadinRequest request, VaadinResponse response) throws IOException {
        String[] keys;
        assert (service != null) : "VaadinService cannot be null";
        if (this.i18NProvider == null) {
            this.handleMissingI18NProvider(service, response);
            return;
        }
        Locale locale = this.getLocale(request);
        String[] chunks = request.getParameterMap().get(CHUNK_PARAMETER_NAME);
        ObjectNode translations = this.collectTranslations(chunks, keys = request.getParameterMap().get(KEYS_PARAMETER_NAME), locale);
        if (translations.isEmpty()) {
            this.handleNotFound(response);
        } else {
            this.handleFound(locale, response, translations);
        }
    }

    private void handleFound(Locale locale, VaadinResponse response, ObjectNode translations) throws IOException {
        response.setStatus(HttpStatusCode.OK.getCode());
        response.setHeader(RETRIEVED_LOCALE_HEADER_NAME, locale.toLanguageTag());
        response.setHeader("Content-Type", "application/json; charset=UTF-8");
        response.getWriter().write(translations.toString());
    }

    private void handleNotFound(VaadinResponse response) {
        response.setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    private void handleMissingI18NProvider(VaadinService service, VaadinResponse response) throws IOException {
        String errorMessage = "Missing I18nProvider implementation, loading translations is not supported.";
        if (service.getDeploymentConfiguration().isProductionMode()) {
            response.setStatus(HttpStatusCode.NOT_FOUND.getCode());
        } else {
            response.sendError(HttpStatusCode.NOT_IMPLEMENTED.getCode(), errorMessage);
        }
        this.getLogger().debug(errorMessage);
    }

    private ObjectNode collectTranslations(String[] chunks, String[] keys, Locale locale) {
        ObjectNode json = JacksonUtils.createObjectNode();
        Optional<Stream> chunkStream = Optional.ofNullable(chunks).map(chunkNames -> {
            Map<String, String[]> chunkData = this.getChunkData();
            return Arrays.stream(chunks).map(chunkData::get).filter(Objects::nonNull).flatMap(Arrays::stream);
        });
        Optional<Stream> keyStream = Optional.ofNullable(keys).map(Arrays::stream);
        Set<String> requestedKeys = Stream.of(chunkStream, keyStream).filter(Optional::isPresent).flatMap(Optional::orElseThrow).collect(Collectors.toSet());
        Map<String, String> translations = requestedKeys.isEmpty() ? this.i18NProvider.getAllTranslations(locale) : this.i18NProvider.getTranslations(requestedKeys, locale);
        translations.forEach((arg_0, arg_1) -> ((ObjectNode)json).put(arg_0, arg_1));
        return json;
    }

    private Locale getLocale(VaadinRequest request) {
        String languageTag = Objects.requireNonNullElse(request.getParameter(LANGUAGE_TAG_PARAMETER_NAME), "");
        if (languageTag.contains("_")) {
            String[] tokens = languageTag.split("_");
            String language = tokens[0];
            String country = tokens.length > 1 ? tokens[1] : "";
            String variant = tokens.length > 2 ? tokens[2] : "";
            return new Locale(language, country, variant);
        }
        return Locale.forLanguageTag(languageTag);
    }

    private Map<String, String[]> getChunkData() {
        if (this.chunkData == null) {
            this.chunkData = new HashMap<String, String[]>();
            URL chunkResource = this.classLoader.getResource(CHUNK_RESOURCE);
            if (chunkResource != null) {
                try (InputStream chunkStream = chunkResource.openStream();){
                    JsonNode json = JacksonUtils.getMapper().readTree(chunkStream);
                    JsonNode chunksNode = json.get(CHUNK_PARAMETER_NAME);
                    if (chunksNode != null && chunksNode.isObject()) {
                        Collection fieldNames = chunksNode.propertyNames();
                        for (String chunkName : fieldNames) {
                            JsonNode keysNode = chunksNode.get(chunkName).get(KEYS_PARAMETER_NAME);
                            if (keysNode == null || !keysNode.isArray()) continue;
                            String[] keys = new String[keysNode.size()];
                            for (int i = 0; i < keysNode.size(); ++i) {
                                keys[i] = keysNode.get(i).asString();
                            }
                            this.chunkData.put(chunkName, keys);
                        }
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Error while reading the resource vaadin-i18n/i18n.json", (Throwable)e);
                }
            }
        }
        return this.chunkData;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(TranslationFileRequestHandler.class);
    }
}

