/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.EntryPointType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ChunkInfo {
    public static final ChunkInfo APP_SHELL = new ChunkInfo(EntryPointType.INTERNAL, null, null, true);
    public static final ChunkInfo GLOBAL = new ChunkInfo(EntryPointType.INTERNAL, null, null, false);
    public static final ChunkInfo WEB_COMPONENT = new ChunkInfo(EntryPointType.WEB_COMPONENT, "webComponent", null, false);
    private final EntryPointType type;
    private final String name;
    private List<String> dependencyTriggers = null;
    private final boolean eager;

    public ChunkInfo(EntryPointType type, String name, List<String> dependencyTriggers, boolean eager) {
        this.type = type;
        this.eager = eager;
        if (type == EntryPointType.INTERNAL) {
            this.name = null;
        } else {
            this.name = name;
            this.dependencyTriggers = dependencyTriggers;
        }
    }

    public EntryPointType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.dependencyTriggers != null ? this.dependencyTriggers.hashCode() : 0);
        result = 31 * result + (this.eager ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkInfo chunkInfo = (ChunkInfo)o;
        if (this.eager != chunkInfo.eager) {
            return false;
        }
        if (this.type != chunkInfo.type) {
            return false;
        }
        if (!Objects.equals(this.name, chunkInfo.name)) {
            return false;
        }
        return Objects.equals(this.dependencyTriggers, chunkInfo.dependencyTriggers);
    }

    public List<String> getDependencyTriggers() {
        if (this.dependencyTriggers != null) {
            return this.dependencyTriggers;
        }
        return Collections.singletonList(this.getName());
    }

    public boolean isEager() {
        return this.eager;
    }
}

