/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.auth.AccessCheckResult;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Predicate;

public final class NavigationContext {
    private final Router router;
    private final Class<?> navigationTarget;
    private final Location location;
    private final RouteParameters parameters;
    private final Principal principal;
    private final Predicate<String> roleChecker;
    private final boolean errorHandling;
    private final boolean navigating;

    public NavigationContext(Router router, Class<?> navigationTarget, Location location, RouteParameters parameters, Principal principal, Predicate<String> roleChecker, boolean errorHandling, boolean navigating) {
        this.router = Objects.requireNonNull(router, "router must no be null");
        this.navigationTarget = Objects.requireNonNull(navigationTarget, "navigationTarget must no be null");
        this.location = Objects.requireNonNull(location, "location must no be null");
        this.parameters = Objects.requireNonNull(parameters, "parameters must no be null");
        this.roleChecker = Objects.requireNonNull(roleChecker, "roleChecker must no be null");
        this.principal = principal;
        this.errorHandling = errorHandling;
        this.navigating = navigating;
    }

    public NavigationContext(Router router, Class<?> navigationTarget, Location location, RouteParameters parameters, Principal principal, Predicate<String> roleChecker, boolean errorHandling) {
        this(router, navigationTarget, location, parameters, principal, roleChecker, errorHandling, true);
    }

    public NavigationContext(BeforeEnterEvent event, Principal principal, Predicate<String> roleChecker) {
        this(event.getSource(), event.getNavigationTarget(), event.getLocation(), event.getRouteParameters(), principal, roleChecker, event.isErrorEvent());
    }

    public Router getRouter() {
        return this.router;
    }

    public Class<?> getNavigationTarget() {
        return this.navigationTarget;
    }

    public Location getLocation() {
        return this.location;
    }

    public RouteParameters getParameters() {
        return this.parameters;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isErrorHandling() {
        return this.errorHandling;
    }

    public boolean isNavigating() {
        return this.navigating;
    }

    public boolean hasRole(String role) {
        return this.roleChecker.test(role);
    }

    public AccessCheckResult allow() {
        return AccessCheckResult.allow();
    }

    public AccessCheckResult neutral() {
        return AccessCheckResult.neutral();
    }

    public AccessCheckResult deny(String reason) {
        return AccessCheckResult.deny(reason);
    }

    public AccessCheckResult reject(String reason) {
        return AccessCheckResult.reject(reason);
    }
}

