/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.AbstractAnnotationValidator;
import com.vaadin.flow.server.startup.AppShellPredicate;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinServletContextStartupInitializer;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.servlet.annotation.WebListener;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={AppShellConfigurator.class, Meta.class, Meta.Container.class, PWA.class, Inline.class, Inline.Container.class, Viewport.class, BodySize.class, PageTitle.class, Push.class, ColorScheme.class, Theme.class, NoTheme.class, StyleSheet.class, StyleSheet.Container.class})
@WebListener
public class VaadinAppShellInitializer
implements VaadinServletContextStartupInitializer,
ServletContextListener,
Serializable {
    @Override
    public void initialize(Set<Class<?>> classes, VaadinContext context) {
        VaadinAppShellInitializer.init(AbstractAnnotationValidator.removeHandleTypesSelfReferences(classes, this), context);
    }

    public static void init(Set<Class<?>> classes, VaadinContext context) {
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        boolean disregardOffendingAnnotations = config.getBooleanProperty("allow.appshell.annotations", false);
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        registry.reset();
        if (classes == null || classes.isEmpty()) {
            return;
        }
        ArrayList offendingAnnotations = new ArrayList();
        AppShellPredicate predicate = context.getAttribute(Lookup.class).lookup(AppShellPredicate.class);
        classes.stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).sorted((a, b) -> predicate.isShell((Class<?>)a) ? -1 : (predicate.isShell((Class<?>)b) ? 1 : 0)).forEach(clz -> {
            if (predicate.isShell((Class<?>)clz)) {
                registry.setShell((Class<? extends AppShellConfigurator>)clz);
                VaadinAppShellInitializer.getLogger().debug("Using {} class for configuring `index.html` response", (Object)clz.getName());
            } else {
                String error = registry.validateClass((Class<?>)clz);
                if (error != null) {
                    offendingAnnotations.add(error);
                }
            }
        });
        if (!offendingAnnotations.isEmpty()) {
            if (disregardOffendingAnnotations) {
                boolean hasPwa = offendingAnnotations.stream().anyMatch(err -> err.matches(".*@PWA.*"));
                String message = String.format(hasPwa ? "%n%nWe changed the way you configure PWAs, please see this link for more info:%nhttps://vaadin.com/docs/latest/flow/advanced/modifying-the-bootstrap-page%n" : "%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n", String.join((CharSequence)"\n  ", offendingAnnotations));
                VaadinAppShellInitializer.getLogger().error(message);
            } else {
                String message = String.format("%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n", String.join((CharSequence)"\n  ", offendingAnnotations));
                throw new InvalidApplicationConfigurationException(message);
            }
        }
    }

    public static List<Class<? extends Annotation>> getValidAnnotations() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(Class::isAnnotation).map(clz -> clz).collect(Collectors.toList());
    }

    public static List<Class<?>> getValidSupers() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(clz -> !clz.isAnnotation()).collect(Collectors.toList());
    }

    private static Class<?>[] getHandledTypes() {
        HandlesTypes annotation = VaadinAppShellInitializer.class.getAnnotation(HandlesTypes.class);
        assert (annotation != null);
        return annotation.value();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinAppShellInitializer.class);
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

