/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.internal.streams.UploadCompleteEvent;
import com.vaadin.flow.internal.streams.UploadStartEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.MultipartConfigurationException;
import com.vaadin.flow.server.communication.UploadFileCountLimitExceededException;
import com.vaadin.flow.server.communication.UploadFileSizeLimitExceededException;
import com.vaadin.flow.server.communication.UploadSizeLimitExceededException;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public final class TransferUtil {
    public static int DEFAULT_BUFFER_SIZE = 16384;

    public static long transfer(InputStream inputStream, OutputStream outputStream, TransferContext transferContext, Collection<TransferProgressListener> listeners) throws IOException {
        int read;
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        Objects.requireNonNull(outputStream, "OutputStream cannot be null");
        Objects.requireNonNull(transferContext, "TransferRequest cannot be null");
        Objects.requireNonNull(listeners, "TransferProgressListener cannot be null");
        listeners.forEach(listener -> listener.onStart(transferContext));
        long transferred = 0L;
        HashMap<TransferProgressListener, Long> lastNotified = new HashMap<TransferProgressListener, Long>(listeners.size());
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = inputStream.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            outputStream.write(buffer, 0, read);
            if (transferred >= Long.MAX_VALUE) continue;
            try {
                transferred = Math.addExact(transferred, (long)read);
            }
            catch (ArithmeticException ignore) {
                transferred = Long.MAX_VALUE;
            }
            for (TransferProgressListener listener2 : listeners) {
                Long lastNotifiedLong = lastNotified.getOrDefault(listener2, 0L);
                long progressReportInterval = listener2.progressReportInterval();
                if (progressReportInterval <= -1L || transferred - lastNotifiedLong < progressReportInterval) continue;
                long finalTransferred = transferred;
                listener2.onProgress(transferContext, finalTransferred, transferContext.contentLength());
                lastNotified.put(listener2, transferred);
            }
        }
        outputStream.flush();
        long finalTransferred = transferred;
        listeners.forEach(listener -> listener.onComplete(transferContext, finalTransferred));
        return transferred;
    }

    public static void handleUpload(UploadHandler handler, VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) {
        block15: {
            boolean isMultipartUpload = TransferUtil.isMultipartContent(request);
            try {
                if (isMultipartUpload) {
                    Collection<Part> parts = Collections.EMPTY_LIST;
                    try {
                        parts = ((HttpServletRequest)request).getParts();
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                    catch (ServletException | IllegalStateException e) {
                        throw new MultipartConfigurationException(e);
                    }
                    if (!parts.isEmpty()) {
                        TransferUtil.validateUploadLimits(handler, request, parts);
                        for (Part part : parts) {
                            UploadEvent event = new UploadEvent(request, response, session, part.getSubmittedFileName(), part.getSize(), part.getContentType(), owner, part);
                            TransferUtil.handleUploadRequest(handler, event);
                        }
                        handler.responseHandled(true, response);
                    } else {
                        LoggerFactory.getLogger(UploadHandler.class).warn("Multipart request has no parts");
                        handler.responseHandled(false, response);
                    }
                    break block15;
                }
                String fileName = TransferUtil.extractFilenameFromXhrRequest(request);
                String contentType = TransferUtil.extractContentTypeFromXhrRequest(request);
                UploadEvent event = new UploadEvent(request, response, session, fileName, request.getContentLengthLong(), contentType, owner, null);
                TransferUtil.handleUploadRequest(handler, event);
                handler.responseHandled(true, response);
            }
            catch (UploadFileCountLimitExceededException | UploadFileSizeLimitExceededException | UploadSizeLimitExceededException e) {
                String limitInfoStr = "{} limit exceeded. To increase the limit extend StreamRequestHandler, override {} method for UploadHandler and provide a higher limit.";
                if (e instanceof UploadSizeLimitExceededException) {
                    LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr, (Object)"Request size", (Object)"getRequestSizeMax");
                } else if (e instanceof UploadFileSizeLimitExceededException) {
                    UploadFileSizeLimitExceededException fileSizeException = (UploadFileSizeLimitExceededException)e;
                    LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr + " File: {}", new Object[]{"File size", "getFileSizeMax", fileSizeException.getFileName()});
                } else if (e instanceof UploadFileCountLimitExceededException) {
                    LoggerFactory.getLogger(UploadHandler.class).warn(limitInfoStr, (Object)"File count", (Object)"getFileCountMax");
                }
                LoggerFactory.getLogger(UploadHandler.class).warn("File upload failed.", (Throwable)e);
                handler.responseHandled(false, response);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(UploadHandler.class).error("Exception during upload", (Throwable)e);
                handler.responseHandled(false, response);
            }
        }
    }

    private static boolean isMultipartContent(VaadinRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!"POST".equalsIgnoreCase(httpRequest.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public static String extractFilenameFromXhrRequest(VaadinRequest request) {
        String fileName = request.getHeader("X-Filename");
        if (fileName == null || fileName.isEmpty()) {
            return "unknown";
        }
        return UrlUtil.decodeURIComponent(fileName);
    }

    public static String extractContentTypeFromXhrRequest(VaadinRequest request) {
        String contentType = request.getHeader("Content-Type");
        if (contentType == null || contentType.isEmpty()) {
            return "unknown";
        }
        return contentType;
    }

    private static void validateUploadLimits(UploadHandler handler, VaadinRequest request, Collection<Part> parts) throws UploadSizeLimitExceededException, UploadFileSizeLimitExceededException, UploadFileCountLimitExceededException {
        long requestSizeMax = handler.getRequestSizeMax();
        long fileSizeMax = handler.getFileSizeMax();
        long fileCountMax = handler.getFileCountMax();
        if (fileCountMax > -1L && (long)parts.size() > fileCountMax) {
            throw new UploadFileCountLimitExceededException(parts.size(), fileCountMax);
        }
        long contentLength = request.getContentLengthLong();
        if (requestSizeMax > -1L && contentLength > requestSizeMax) {
            throw new UploadSizeLimitExceededException(contentLength, requestSizeMax);
        }
        if (fileSizeMax > -1L) {
            for (Part part : parts) {
                long size = part.getSize();
                if (size <= fileSizeMax) continue;
                throw new UploadFileSizeLimitExceededException(part.getSubmittedFileName(), size, fileSizeMax);
            }
        }
    }

    private static void handleUploadRequest(UploadHandler handler, UploadEvent event) throws IOException {
        Component owner = event.getOwningComponent();
        try {
            ComponentUtil.fireEvent(owner, new UploadStartEvent(owner));
            handler.handleUploadRequest(event);
        }
        finally {
            ComponentUtil.fireEvent(owner, new UploadCompleteEvent(owner));
        }
    }
}

