/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.DependencyList;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.MetadataWriter;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class UidlWriter
implements Serializable {
    private static final String COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE = "Could not read url %s contents";

    public ObjectNode createUidl(UI ui, boolean async, boolean resync) {
        List<PendingJavaScriptInvocation> executeJavaScriptList;
        ObjectNode response = JacksonUtils.createObjectNode();
        UIInternals uiInternals = ui.getInternals();
        VaadinSession session = ui.getSession();
        VaadinService service = session.getService();
        service.runPendingAccessTasks(session);
        UidlWriter.getLogger().debug("* Creating response to client");
        if (resync) {
            response.put("resynchronize", true);
        }
        int nextClientToServerMessageId = uiInternals.getLastProcessedClientToServerId() + 1;
        response.put("clientId", nextClientToServerMessageId);
        SystemMessages messages = service.getSystemMessages(ui.getLocale(), null);
        ObjectNode meta = new MetadataWriter().createMetadata(ui, false, async, messages);
        if (!JacksonUtils.getKeys((JsonNode)meta).isEmpty()) {
            response.set("meta", (JsonNode)meta);
        }
        ArrayNode stateChanges = JacksonUtils.createArrayNode();
        this.encodeChanges(ui, stateChanges);
        UidlWriter.populateDependencies(response, uiInternals.getDependencyList(), new ResolveContext(service));
        Set<String> stylesheetRemovals = uiInternals.getPendingStyleSheetRemovals();
        if (!stylesheetRemovals.isEmpty()) {
            ArrayNode removals = JacksonUtils.createArrayNode();
            stylesheetRemovals.forEach(arg_0 -> ((ArrayNode)removals).add(arg_0));
            response.set("stylesheetRemovals", (JsonNode)removals);
            uiInternals.clearPendingStyleSheetRemovals();
        }
        if (uiInternals.getConstantPool().hasNewConstants()) {
            response.set("constants", (JsonNode)uiInternals.getConstantPool().dumpConstants());
        }
        if (!stateChanges.isEmpty()) {
            response.set("changes", (JsonNode)stateChanges);
        }
        if (!(executeJavaScriptList = uiInternals.dumpPendingJavaScriptInvocations()).isEmpty()) {
            response.set("execute", (JsonNode)UidlWriter.encodeExecuteJavaScriptList(executeJavaScriptList));
        }
        if (service.getDeploymentConfiguration().isRequestTiming()) {
            response.set("timings", (JsonNode)this.createPerformanceData(ui));
        }
        int syncId = service.getDeploymentConfiguration().isSyncIdCheckEnabled() ? uiInternals.getServerSyncId() : -1;
        response.put("syncId", syncId);
        uiInternals.incrementServerId();
        return response;
    }

    public ObjectNode createUidl(UI ui, boolean async) {
        return this.createUidl(ui, async, false);
    }

    private static void populateDependencies(ObjectNode response, DependencyList dependencyList, ResolveContext context) {
        Collection<Dependency> pendingSendToClient = dependencyList.getPendingSendToClient();
        for (DependencyFilter filter : context.getService().getDependencyFilters()) {
            pendingSendToClient = filter.filter(new ArrayList<Dependency>(pendingSendToClient), context.getService());
        }
        if (!pendingSendToClient.isEmpty()) {
            UidlWriter.groupDependenciesByLoadMode(pendingSendToClient, context).forEach((loadMode, dependencies) -> {
                try {
                    response.set(loadMode.name(), JacksonUtils.getMapper().readTree(dependencies.toString()));
                }
                catch (JacksonException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        dependencyList.clearPendingSendToClient();
    }

    private static Map<LoadMode, ArrayNode> groupDependenciesByLoadMode(Collection<Dependency> dependencies, ResolveContext context) {
        EnumMap<LoadMode, ArrayNode> result = new EnumMap<LoadMode, ArrayNode>(LoadMode.class);
        dependencies.forEach(dependency -> result.merge(dependency.getLoadMode(), JacksonUtils.createArray(new JsonNode[]{UidlWriter.dependencyToJson(dependency, context)}), JacksonUtils.asArray().combiner()));
        return result;
    }

    private static ObjectNode dependencyToJson(Dependency dependency, ResolveContext context) {
        ObjectNode dependencyJson = JacksonUtils.mapElemental(dependency.toJson());
        if (dependency.getLoadMode() == LoadMode.INLINE) {
            dependencyJson.put("contents", UidlWriter.getDependencyContents(dependency.getUrl(), context));
            dependencyJson.remove("url");
        }
        return dependencyJson;
    }

    private static String getDependencyContents(String url, ResolveContext context) {
        String string;
        block8: {
            InputStream inlineResourceStream = UidlWriter.getInlineResourceStream(url, context);
            try {
                string = IOUtils.toString((InputStream)inlineResourceStream, (Charset)StandardCharsets.UTF_8);
                if (inlineResourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inlineResourceStream != null) {
                        try {
                            inlineResourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format(COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE, url), e);
                }
            }
            inlineResourceStream.close();
        }
        return string;
    }

    private static InputStream getInlineResourceStream(String url, ResolveContext context) {
        VaadinService service = context.getService();
        InputStream stream = service.getResourceAsStream(url);
        if (stream == null) {
            String resolvedPath = service.resolveResource(url);
            UidlWriter.getLogger().warn("The path '{}' for inline resource has been resolved to '{}'. But resource is not available via the servlet context. Trying to load '{}' as a URL", new Object[]{url, resolvedPath, url});
            try {
                stream = new URL(url).openConnection().getInputStream();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException(String.format("The path '%s' is not a valid URL. Unable to fetch a resource addressed by it.", url), exception);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format(COULD_NOT_READ_URL_CONTENTS_ERROR_MESSAGE, url), e);
            }
        } else if (UidlWriter.getLogger().isDebugEnabled()) {
            String resolvedPath = service.resolveResource(url);
            UidlWriter.getLogger().debug("The path '{}' for inline resource has been successfully resolved to resource URL '{}'", (Object)url, (Object)resolvedPath);
        }
        return stream;
    }

    static ArrayNode encodeExecuteJavaScriptList(List<PendingJavaScriptInvocation> executeJavaScriptList) {
        return executeJavaScriptList.stream().map(UidlWriter::encodeExecuteJavaScript).collect(JacksonUtils.asArray());
    }

    private static ReturnChannelRegistration createReturnValueChannel(StateNode owner, List<ReturnChannelRegistration> registrations, SerializableConsumer<JsonNode> action) {
        ReturnChannelRegistration channel = owner.getFeature(ReturnChannelMap.class).registerChannel(arguments -> {
            registrations.forEach(Registration::remove);
            action.accept(arguments.get(0));
        });
        registrations.add(channel);
        return channel;
    }

    private static ArrayNode encodeExecuteJavaScript(PendingJavaScriptInvocation invocation) {
        List<Object> parametersList = invocation.getInvocation().getParameters();
        Stream<Object> parameters = parametersList.stream();
        Object expression = invocation.getInvocation().getExpression();
        if (invocation.isSubscribed()) {
            StateNode owner = invocation.getOwner();
            ArrayList<ReturnChannelRegistration> channels = new ArrayList<ReturnChannelRegistration>();
            ReturnChannelRegistration successChannel = UidlWriter.createReturnValueChannel(owner, channels, invocation::complete);
            ReturnChannelRegistration errorChannel = UidlWriter.createReturnValueChannel(owner, channels, invocation::completeExceptionally);
            parameters = Stream.concat(parameters, Stream.of(successChannel, errorChannel));
            int successIndex = parametersList.size();
            int errorIndex = successIndex + 1;
            expression = "try{Promise.resolve((async function(){" + (String)expression + "})()).then($" + successIndex + ",function(error){$" + errorIndex + "(''+error)})}catch(error){$" + errorIndex + "(''+error)}";
        }
        return Stream.concat(parameters.map(JacksonCodec::encodeWithTypeInfo), Stream.of(JacksonUtils.createNode(expression))).collect(JacksonUtils.asArray());
    }

    private void encodeChanges(UI ui, ArrayNode stateChanges) {
        UIInternals uiInternals = ui.getInternals();
        StateTree stateTree = uiInternals.getStateTree();
        stateTree.runExecutionsBeforeClientResponse();
        LinkedHashSet componentsWithDependencies = new LinkedHashSet();
        Consumer<NodeChange> changesCollector = change -> {
            if (UidlWriter.attachesComponent(change)) {
                ComponentMapping.getComponent(change.getNode()).ifPresent(component -> this.addComponentHierarchy(ui, componentsWithDependencies, (Component)component));
            }
            stateChanges.add((JsonNode)change.toJson(uiInternals.getConstantPool()));
        };
        int attempts = 5;
        while (stateTree.hasDirtyNodes() && attempts-- > 0) {
            stateTree.collectChanges(changesCollector);
        }
        if (stateTree.hasDirtyNodes()) {
            UidlWriter.getLogger().warn("UI still dirty after collecting changes, this should not happen and may cause unexpected PUSH invocation.");
        }
        componentsWithDependencies.forEach(uiInternals::addComponentDependencies);
    }

    private static boolean attachesComponent(NodeChange change) {
        return change instanceof NodeAttachChange && change.getNode().hasFeature(ComponentMapping.class);
    }

    private void addComponentHierarchy(UI ui, Set<Class<? extends Component>> hierarchyStorage, Component component) {
        hierarchyStorage.add(component.getClass());
        if (component instanceof Composite) {
            this.addComponentHierarchy(ui, hierarchyStorage, (Component)((Composite)component).getContent());
        }
    }

    private ArrayNode createPerformanceData(UI ui) {
        ArrayNode timings = JacksonUtils.createArrayNode();
        timings.add(ui.getSession().getCumulativeRequestDuration());
        timings.add(ui.getSession().getLastRequestDuration());
        return timings;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UidlWriter.class.getName());
    }

    public static class ResolveContext
    implements Serializable {
        private VaadinService service;

        public ResolveContext(VaadinService service) {
            this.service = Objects.requireNonNull(service);
        }

        public VaadinService getService() {
            return this.service;
        }
    }
}

