/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.webcomponent.WebComponentUI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.BootstrapException;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlRequestHandler;
import com.vaadin.flow.server.communication.UidlWriter;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class WebComponentBootstrapHandler
extends BootstrapHandler {
    private static final String REQ_PARAM_URL = "url";
    private static final String PATH_PREFIX = "/web-component/web-component";
    static final Pattern PATH_PATTERN = Pattern.compile(".*/web-component/web-component-(ui|bootstrap)\\.(js|html)$");

    protected static void addGeneratedIndexContent(Document targetDocument, ObjectNode statsJson) {
        ArrayList<String> toAdd = new ArrayList<String>();
        Optional<String> webComponentScript = JacksonUtils.stream((ArrayNode)statsJson.get("entryScripts")).map(JsonNode::asText).filter(script -> script.contains("webcomponenthtml")).findFirst();
        if (webComponentScript.isPresent()) {
            org.jsoup.nodes.Element elm = new org.jsoup.nodes.Element("script");
            elm.attr("type", "module");
            elm.attr("src", webComponentScript.get());
            toAdd.add(elm.outerHtml());
        }
        for (String row : toAdd) {
            targetDocument.head().append(row);
        }
    }

    public WebComponentBootstrapHandler() {
        super(new WebComponentBootstrapPageBuilder());
    }

    protected WebComponentBootstrapHandler(BootstrapHandler.PageBuilder pageBuilder) {
        super(pageBuilder);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        if (!this.hasWebComponentConfigurations(request)) {
            return false;
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return false;
        }
        return PATH_PATTERN.matcher(pathInfo).find();
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        if (!this.canHandleRequest(request)) {
            throw new IllegalStateException("Unexpected request URL '" + this.getRequestUrl(request) + "' in the bootstrap handler for web component UI which should handle path " + PATH_PATTERN.toString());
        }
        String serviceUrl = this.getServiceUrl(request, response);
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(WebComponentUI.class, request, response, session);
        ObjectNode config = context.getApplicationParameters();
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        pushConfiguration.setPushServletMapping(BootstrapHandlerHelper.determinePushServletMapping(session));
        assert (serviceUrl.endsWith("/"));
        config.put("serviceUrl", serviceUrl);
        config.put("webComponentMode", true);
        WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(request.getService().getContext());
        ArrayNode tags = registry.getConfigurations().stream().map(conf -> JacksonUtils.createNode(conf.getTag())).collect(JacksonUtils.asArray());
        config.set("webcomponents", (JsonNode)tags);
        config.put("devToolsEnabled", false);
        return context;
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new WebComponentBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if ("HEAD".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
            return true;
        }
        Class<? extends UI> uiClass = WebComponentBootstrapHandler.getUIClass(request);
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        if (this.handleWebComponentResyncRequest(context, request, response)) {
            return true;
        }
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        String serviceUrl = this.getServiceUrl(request, response);
        Document document = this.getPageBuilder().getBootstrapPage(context);
        this.writeBootstrapPage(response, document.head(), serviceUrl);
        UsageStatistics.markAsUsed("exported-wc", null);
        return true;
    }

    private void writeBootstrapPage(VaadinResponse response, org.jsoup.nodes.Element head, String serviceUrl) throws IOException {
        this.writeBootstrapPage("text/javascript; charset=utf-8", response, head, serviceUrl);
    }

    protected void writeBootstrapPage(String contentType, VaadinResponse response, org.jsoup.nodes.Element head, String serviceUrl) throws IOException {
        response.setContentType(contentType);
        ArrayList<Element> elementsForShadows = new ArrayList<Element>();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            writer.write("(function () {\nvar hasScript = function(src) {\n  var scriptTags = Array.from(document.head.querySelectorAll('script'));\n  return scriptTags.some(script => script.src.endsWith(src))\n};\n");
            String varName = "headElem";
            writer.append("var ").append(varName).append("=null;");
            for (org.jsoup.nodes.Element element2 : head.children()) {
                if (WebComponentBootstrapHandler.elementShouldNotBeTransferred(element2)) {
                    WebComponentBootstrapHandler.getElementForShadowDom(element2).ifPresent(elementsForShadows::add);
                    continue;
                }
                String conditionalFilename = WebComponentBootstrapHandler.getVaadinFilenameIfVaadinScript(element2);
                if (conditionalFilename != null) {
                    writer.append("if (!hasScript(\"" + conditionalFilename + "\")) {\n");
                }
                writer.append(varName).append("=");
                writer.append("document.createElement('").append(element2.tagName()).append("');");
                this.transferAttribute(writer, varName, element2, serviceUrl);
                String elementHtml = element2.html();
                if (elementHtml != null && elementHtml.length() > 0) {
                    writer.append(varName).append(".innerHTML=\"").append(WebComponentBootstrapHandler.inlineHTML(elementHtml)).append("\";");
                }
                writer.append("document.head.appendChild(").append(varName).append(");");
                if (conditionalFilename == null) continue;
                writer.append("}\n");
            }
            writer.append("})();");
        }
        DeploymentConfiguration config = response.getService().getDeploymentConfiguration();
        VaadinContext context = response.getService().getContext();
        if (config.getMode() == Mode.DEVELOPMENT_BUNDLE) {
            BootstrapHandler.getStylesheetTags(context, "styles.css").forEach(element -> ElementUtil.fromJsoup((Node)element).ifPresent(elementsForShadows::add));
            File frontendDirectory = FrontendUtils.getProjectFrontendDir(config);
            BootstrapHandler.getStylesheetLinks(context, "document.css", frontendDirectory).forEach(link -> UI.getCurrent().getPage().executeJs("const link = document.createElement('link');link.rel = 'stylesheet';link.type = 'text/css';link.href = $0;document.head.appendChild(link);", this.modifyPath(serviceUrl, (String)link)));
        }
        WebComponentConfigurationRegistry.getInstance(response.getService().getContext()).setShadowDomElements(elementsForShadows);
    }

    private static String getVaadinFilenameIfVaadinScript(org.jsoup.nodes.Element element) {
        if (!"script".equalsIgnoreCase(element.tagName())) {
            return null;
        }
        String src = element.attr("src");
        int index = src.indexOf("/VAADIN/");
        if (index != -1) {
            return src.substring(index);
        }
        return null;
    }

    private static boolean elementShouldNotBeTransferred(org.jsoup.nodes.Element element) {
        if ("base".equals(element.tagName()) || "meta".equals(element.tagName()) || "style".equals(element.tagName())) {
            return true;
        }
        return "script".equals(element.tagName()) && element.attr("src").contains("webcomponents-loader.js");
    }

    private static Optional<Element> getElementForShadowDom(org.jsoup.nodes.Element element) {
        if ("style".equals(element.tagName())) {
            return ElementUtil.fromJsoup((Node)element);
        }
        return Optional.empty();
    }

    private void transferAttribute(Writer writer, String elementRef, org.jsoup.nodes.Element element, String basePath) throws IOException {
        for (Attribute attribute : element.attributes()) {
            writer.append(elementRef).append(".setAttribute('").append(attribute.getKey()).append("',");
            if (attribute.getValue() == null) {
                writer.append("''");
            } else {
                String name = attribute.getKey();
                String path = attribute.getValue();
                if (name.matches("^(src|href)$")) {
                    path = this.modifyPath(basePath, path);
                }
                writer.append("\"").append(path).append("\"");
            }
            writer.append(");");
        }
    }

    protected String modifyPath(String basePath, String path) {
        int vaadinIndex = path.indexOf("VAADIN/");
        String suffix = path;
        if (vaadinIndex > 0) {
            suffix = suffix.substring(vaadinIndex);
        }
        return URI.create(this.checkURL(basePath + suffix)).toString();
    }

    private String checkURL(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("\"")) {
            throw new IllegalStateException("URL '" + url + "' may not contain double quotes");
        }
        return url;
    }

    private boolean hasWebComponentConfigurations(VaadinRequest request) {
        WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(request.getService().getContext());
        return registry.hasConfigurations();
    }

    private static String inlineHTML(String html) {
        return html.replace("\\", "\\\\").replace("\"", "\\\"").replace("//<![CDATA[", "/*<![CDATA[*/").replace("//]]>", "/*]]>*/").replace("\r", "").replaceAll("\\s{2,}", "").replace("\t", "").replace("\n", "\\n");
    }

    protected String getServiceUrl(VaadinRequest request, VaadinResponse response) {
        String url = request.getParameter(REQ_PARAM_URL);
        if (url == null) {
            url = this.getRequestUrl(request);
        }
        return url.substring(0, url.indexOf(PATH_PREFIX) + 1).replaceFirst("^.*://", "//");
    }

    protected boolean handleWebComponentResyncRequest(BootstrapHandler.BootstrapContext context, VaadinRequest request, VaadinResponse response) {
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.WEBCOMPONENT_RESYNC)) {
            return false;
        }
        ObjectNode json = new UidlWriter().createUidl(context.getUI(), true, true);
        json.put("uiId", context.getUI().getUIId());
        json.put("Vaadin-Security-Key", context.getUI().getCsrfToken());
        json.put("Vaadin-Push-ID", context.getUI().getSession().getPushId());
        String responseString = "for(;;);[" + String.valueOf(json) + "]";
        try {
            VaadinService service = request.getService();
            service.writeUncachedStringResponse(response, "application/json; charset=UTF-8", responseString);
        }
        catch (IOException e) {
            WebComponentBootstrapHandler.getLogger().error("Error writing JSON to response", (Throwable)e);
        }
        return true;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)WebComponentBootstrapHandler.class.getName());
    }

    private static class WebComponentBootstrapPageBuilder
    extends BootstrapHandler.BootstrapPageBuilder {
        private WebComponentBootstrapPageBuilder() {
        }

        @Override
        public Document getBootstrapPage(BootstrapHandler.BootstrapContext context) {
            VaadinService service = context.getSession().getService();
            try {
                Document document = Jsoup.parse((String)FrontendUtils.getWebComponentHtmlContent(service));
                org.jsoup.nodes.Element head = document.head();
                DeploymentConfiguration deploymentConfiguration = service.getDeploymentConfiguration();
                if (!deploymentConfiguration.isProductionMode() && deploymentConfiguration.getMode() != Mode.DEVELOPMENT_FRONTEND_LIVERELOAD) {
                    WebComponentBootstrapHandler.addGeneratedIndexContent(document, WebComponentBootstrapHandler.getStatsJson(deploymentConfiguration));
                }
                head.select("script[src]").attr("data-app-id", context.getUI().getInternals().getAppId());
                head.select("script[src], link[href]").attr("crossorigin", "true");
                ObjectNode initialUIDL = WebComponentBootstrapHandler.getInitialUidl(context.getUI());
                head.prependChild((Node)this.createInlineJavaScriptElement("window.JSCompiler_renameProperty = function(a) { return a; }"));
                head.prependChild((Node)this.getBootstrapScript(initialUIDL, context));
                if (context.getPushMode().isEnabled()) {
                    head.prependChild((Node)WebComponentBootstrapPageBuilder.createJavaScriptModuleElement(WebComponentBootstrapHandler.getPushScript(context), true));
                }
                this.setupCss(head, context);
                IndexHtmlRequestHandler.addCommercialBanner(deploymentConfiguration, document);
                return document;
            }
            catch (IOException e) {
                throw new BootstrapException("Unable to read the web-component.html file.", e);
            }
        }

        @Override
        protected List<String> getChunkKeys(ObjectNode chunks) {
            if (chunks.has("export")) {
                return Collections.singletonList("export");
            }
            return super.getChunkKeys(chunks);
        }
    }

    private static class WebComponentBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        private WebComponentBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback);
            this.setInitTheme(false);
        }

        @Override
        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(this.getService().getContext());
            return registry.getEmbeddedApplicationAnnotation(annotationType);
        }

        @Override
        protected Optional<PwaRegistry> getPwaRegistry() {
            return Optional.empty();
        }

        @Override
        public String getAppId() {
            return "wc-" + super.getAppId();
        }
    }
}

