/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;

public final class Shortcuts {
    static final String NULL = "Parameter '%s' must not be null!";
    static final String ELEMENT_LOCATOR_JS_KEY = "_element_locator_js_key";

    private Shortcuts() {
    }

    public static ShortcutRegistration addShortcutListener(Component lifecycleOwner, Command command, Key key, KeyModifier ... keyModifiers) {
        if (lifecycleOwner == null) {
            throw new IllegalArgumentException(String.format(NULL, "lifecycleOwner"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format(NULL, "command"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format(NULL, "key"));
        }
        return new ShortcutRegistration(lifecycleOwner, () -> new Component[]{lifecycleOwner.getUI().get()}, event -> command.execute(), key).withModifiers(keyModifiers);
    }

    public static ShortcutRegistration addShortcutListener(Component lifecycleOwner, ShortcutEventListener listener, Key key, KeyModifier ... keyModifiers) {
        if (lifecycleOwner == null) {
            throw new IllegalArgumentException(String.format(NULL, "lifecycleOwner"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format(NULL, "listener"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format(NULL, "key"));
        }
        return new ShortcutRegistration(lifecycleOwner, () -> new Component[]{lifecycleOwner.getUI().get()}, listener, key).withModifiers(keyModifiers);
    }

    public static Registration setShortcutListenOnElement(String elementLocatorJs, Component listenOnComponent) {
        ComponentUtil.setData(listenOnComponent, ELEMENT_LOCATOR_JS_KEY, elementLocatorJs);
        return () -> {
            if (elementLocatorJs != null && elementLocatorJs.equals(ComponentUtil.getData(listenOnComponent, ELEMENT_LOCATOR_JS_KEY))) {
                ComponentUtil.setData(listenOnComponent, ELEMENT_LOCATOR_JS_KEY, null);
            }
        };
    }
}

