/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.file.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRemoveOldFrontendGeneratedFiles
implements FallibleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRemoveOldFrontendGeneratedFiles.class);
    private final Path frontendGeneratedFolder;
    private final File frontendFolder;
    private final Set<Path> existingFiles = new HashSet<Path>();
    private GeneratedFilesSupport generatedFilesSupport;

    public TaskRemoveOldFrontendGeneratedFiles(Options options) {
        this.frontendFolder = options.getFrontendDirectory();
        this.frontendGeneratedFolder = options.getFrontendGeneratedFolder().toPath();
        if (this.frontendGeneratedFolder.toFile().exists()) {
            try (Stream<Path> files = Files.walk(this.frontendGeneratedFolder, new FileVisitOption[0]);){
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.normalize().toAbsolutePath()).collect(Collectors.toCollection(() -> this.existingFiles));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.generatedFilesSupport != null) {
            Set<Path> generatedFiles = this.generatedFilesSupport.getFiles(this.frontendGeneratedFolder);
            HashSet<Path> toDelete = new HashSet<Path>(this.existingFiles);
            toDelete.removeAll(generatedFiles);
            toDelete.removeIf(this.isKnownUnhandledFile());
            LOGGER.debug("Cleaning generated frontend files from {}: {}", (Object)this.frontendGeneratedFolder, toDelete);
            for (Path path : toDelete) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException ex) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot delete old generated file {}", (Object)path, (Object)ex);
                        continue;
                    }
                    LOGGER.warn("Cannot delete old generated file {}", (Object)path);
                }
            }
            try {
                Files.walkFileTree(this.frontendGeneratedFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (PathUtils.isEmptyDirectory((Path)dir)) {
                            Files.deleteIfExists(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cannot delete empty folder generated under {}", (Object)this.frontendGeneratedFolder, (Object)ex);
                }
                LOGGER.warn("Cannot delete empty folder generated under {}", (Object)this.frontendGeneratedFolder);
            }
        }
    }

    private Predicate<Path> isKnownUnhandledFile() {
        Path flowGeneratedImports = TaskRemoveOldFrontendGeneratedFiles.normalizePath(FrontendUtils.getFlowGeneratedImports(this.frontendFolder).toPath().toAbsolutePath());
        Path flowGeneratedWebComponentImports = TaskRemoveOldFrontendGeneratedFiles.normalizePath(FrontendUtils.getFlowGeneratedWebComponentsImports(this.frontendFolder).toPath().toAbsolutePath());
        HashSet<Path> knownFiles = new HashSet<Path>();
        knownFiles.add(flowGeneratedImports);
        knownFiles.add(flowGeneratedWebComponentImports);
        knownFiles.add(flowGeneratedImports.resolveSibling("generated-flow-imports.d.ts"));
        knownFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve(new File("flow/Flow.tsx").toPath())));
        knownFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve("routes.tsx")));
        knownFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve("routes.ts")));
        knownFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve("file-routes.ts")));
        knownFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve("file-routes.json")));
        knownFiles.addAll(this.hillaGeneratedFiles());
        return path -> knownFiles.contains(path) || path.getFileName().toString().matches("theme(\\.(js|d\\.ts)|-.*\\.generated.js)");
    }

    private Set<Path> hillaGeneratedFiles() {
        HashSet<Path> generatedFiles = new HashSet<Path>();
        Path hillaGeneratedFilesList = this.frontendGeneratedFolder.resolve("generated-file-list.txt");
        generatedFiles.add(TaskRemoveOldFrontendGeneratedFiles.normalizePath(hillaGeneratedFilesList));
        if (Files.exists(hillaGeneratedFilesList, new LinkOption[0])) {
            try {
                Files.readAllLines(hillaGeneratedFilesList).stream().map(file -> new File((String)file).toPath()).map(file -> TaskRemoveOldFrontendGeneratedFiles.normalizePath(this.frontendGeneratedFolder.resolve((Path)file))).forEach(generatedFiles::add);
            }
            catch (IOException e) {
                LOGGER.debug("Cannot read generated-file-list.txt files");
            }
        }
        return generatedFiles;
    }

    private static Path normalizePath(Path path) {
        return path.toAbsolutePath().normalize();
    }

    @Override
    public void setGeneratedFileSupport(GeneratedFilesSupport support) {
        this.generatedFilesSupport = support;
    }
}

