/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.router.internal.Postpone;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public abstract class AbstractNavigationStateRenderer
implements NavigationHandler {
    private final NavigationState navigationState;
    private List<Class<? extends RouterLayout>> routeLayoutTypes;
    private Postpone postponed = null;
    private LocationChangeEvent locationChangeEvent = null;

    public AbstractNavigationStateRenderer(NavigationState navigationState) {
        this.navigationState = navigationState;
    }

    public NavigationState getNavigationState() {
        return this.navigationState;
    }

    static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, NavigationEvent event, boolean lastElement) {
        UI ui = event.getUI();
        Instantiator instantiator = Instantiator.get(ui);
        boolean forceInstantiation = lastElement ? event.isForceInstantiation() : event.isForceInstantiation() && event.isRecreateLayoutChain();
        Optional<HasElement> currentInstance = forceInstantiation ? Optional.empty() : ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> instantiator.getApplicationClass(component).equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> instantiator.createRouteTarget(routeTargetType, event));
    }

    @Override
    public int handle(NavigationEvent event) {
        ArrayList<HasElement> chain;
        String route;
        UI ui = event.getUI();
        ui.getInternals().setLocationForRefresh(event.getLocation());
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        RouteParameters parameters = this.navigationState.getRouteParameters();
        RouteTarget routeTarget = this.navigationState.getRouteTarget();
        List<Class<? extends RouterLayout>> list = this.routeLayoutTypes = routeTarget != null ? this.getTargetParentLayouts(routeTarget, event.getSource().getRegistry(), event.getLocation().getPath()) : this.getRouterLayoutTypes(routeTargetType, ui.getInternals().getRouter());
        assert (routeTargetType != null);
        assert (this.routeLayoutTypes != null);
        this.clearContinueNavigationAction(ui);
        AbstractNavigationStateRenderer.checkForDuplicates(routeTargetType, this.routeLayoutTypes);
        BeforeLeaveEvent beforeNavigationDeactivating = new BeforeLeaveEvent(event, routeTargetType, parameters, this.routeLayoutTypes);
        Optional<Integer> result = this.executeBeforeLeaveNavigation(event, beforeNavigationDeactivating);
        if (result.isPresent()) {
            return result.get();
        }
        String string = event.getLocation().getPath().isEmpty() ? event.getLocation().getPath() : (route = event.getLocation().getPath().startsWith("/") ? event.getLocation().getPath() : "/" + event.getLocation().getPath());
        if (MenuRegistry.hasClientRoute(route, true) && !MenuRegistry.getClientRoutes(true).get(route).flowLayout()) {
            return HttpStatusCode.OK.getCode();
        }
        boolean preserveOnRefreshTarget = AbstractNavigationStateRenderer.isPreserveOnRefreshTarget(routeTargetType, this.routeLayoutTypes);
        if (preserveOnRefreshTarget && !event.isForceInstantiation()) {
            Optional<ArrayList<HasElement>> maybeChain = this.getPreservedChain(event);
            if (maybeChain.isEmpty()) {
                return HttpStatusCode.OK.getCode();
            }
            chain = maybeChain.get();
        } else {
            chain = new ArrayList();
            AbstractNavigationStateRenderer.clearAllPreservedChains(ui);
        }
        if (preserveOnRefreshTarget && !chain.isEmpty()) {
            event = new NavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.REFRESH);
        }
        this.pushHistoryStateIfNeeded(event, ui);
        BeforeEnterEvent beforeNavigationActivating = new BeforeEnterEvent(event, routeTargetType, parameters, this.routeLayoutTypes);
        result = this.createChainIfEmptyAndExecuteBeforeEnterNavigation(beforeNavigationActivating, event, chain);
        if (result.isPresent()) {
            return result.get();
        }
        Component componentInstance = (Component)chain.get(0);
        if (preserveOnRefreshTarget) {
            this.setPreservedChain(chain, event);
        }
        List<HasElement> routerLayouts = chain.subList(1, chain.size());
        if (ui.hasModalComponent() && event.getTrigger() == NavigationTrigger.REFRESH_ROUTE) {
            Component modalComponent;
            while ((modalComponent = ui.getInternals().getActiveModalComponent()) != null) {
                modalComponent.removeFromParent();
            }
        }
        ui.getInternals().showRouteTarget(event.getLocation(), componentInstance, routerLayouts);
        int statusCode = this.locationChangeEvent.getStatusCode();
        AbstractNavigationStateRenderer.validateStatusCode(statusCode, routeTargetType);
        ArrayList<AfterNavigationHandler> afterNavigationHandlers = new ArrayList<AfterNavigationHandler>(ui.getNavigationListeners(AfterNavigationHandler.class));
        afterNavigationHandlers.addAll(EventUtil.collectAfterNavigationObservers(ui));
        this.fireAfterNavigationListeners(new AfterNavigationEvent(this.locationChangeEvent, parameters), afterNavigationHandlers);
        AbstractNavigationStateRenderer.updatePageTitle(event, componentInstance, route);
        return statusCode;
    }

    protected List<Class<? extends RouterLayout>> getTargetParentLayouts(RouteTarget routeTarget, RouteRegistry registry, String path) {
        if (routeTarget.getParentLayouts().isEmpty() && RouteUtil.isAutolayoutEnabled(routeTarget.getTarget(), path) && registry.hasLayout(path)) {
            return RouteUtil.collectRouteParentLayouts(registry.getLayout(path));
        }
        return routeTarget.getParentLayouts();
    }

    private void pushHistoryStateIfNeeded(NavigationEvent event, UI ui) {
        if (event instanceof ErrorNavigationEvent) {
            ErrorNavigationEvent errorEvent = (ErrorNavigationEvent)event;
            if (this.isRouterLinkNotFoundNavigationError(errorEvent)) {
                event.getState().ifPresent(s -> ui.getPage().executeJs("this.scrollPositionHandlerAfterServerNavigation($0);", new Serializable[]{s}));
            }
        } else if (!(NavigationTrigger.REFRESH == event.getTrigger() || event.isForwardTo() || event.getUI().getInternals().getActiveViewLocation() != null && event.getLocation().getPathWithQueryParameters().equals(event.getUI().getInternals().getActiveViewLocation().getPathWithQueryParameters()))) {
            if (this.shouldPushHistoryState(event)) {
                this.pushHistoryState(event);
            }
        } else if (ui.getInternals().getSession().getService().getDeploymentConfiguration().isReactEnabled() && this.shouldPushHistoryState(event)) {
            this.pushHistoryState(event);
        }
    }

    protected void pushHistoryState(NavigationEvent event) {
        event.getUI().getPage().getHistory().pushState(null, event.getLocation());
    }

    protected boolean shouldPushHistoryState(NavigationEvent event) {
        return NavigationTrigger.UI_NAVIGATE.equals((Object)event.getTrigger()) || NavigationTrigger.REFRESH.equals((Object)event.getTrigger());
    }

    private boolean isRouterLinkNotFoundNavigationError(ErrorNavigationEvent event) {
        return NavigationTrigger.ROUTER_LINK.equals((Object)event.getTrigger()) && event.getErrorParameter() != null && event.getErrorParameter().getCaughtException() instanceof NotFoundException;
    }

    protected abstract void notifyNavigationTarget(Component var1, NavigationEvent var2, BeforeEnterEvent var3, LocationChangeEvent var4);

    protected abstract List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> var1, Router var2);

    private List<Class<? extends HasElement>> getTypesChain() {
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        ArrayList<Class<? extends RouterLayout>> layoutTypes = new ArrayList<Class<? extends RouterLayout>>(this.routeLayoutTypes);
        Collections.reverse(layoutTypes);
        ArrayList<Class<? extends HasElement>> chain = new ArrayList<Class<? extends HasElement>>();
        for (Class clazz : layoutTypes) {
            chain.add(clazz);
        }
        chain.add(routeTargetType);
        return chain;
    }

    private void clearContinueNavigationAction(UI ui) {
        this.storeContinueNavigationAction(ui, null);
    }

    private void storeContinueNavigationAction(UI ui, BeforeLeaveEvent.ContinueNavigationAction currentAction) {
        BeforeLeaveEvent.ContinueNavigationAction previousAction = ui.getInternals().getContinueNavigationAction();
        if (previousAction != null && previousAction != currentAction) {
            previousAction.setReferences(null, null);
        }
        ui.getInternals().setContinueNavigationAction(currentAction);
    }

    private void fireAfterNavigationListeners(AfterNavigationEvent event, List<AfterNavigationHandler> afterNavigationHandlers) {
        afterNavigationHandlers.forEach(listener -> listener.afterNavigation(event));
    }

    private Optional<Integer> executeBeforeLeaveNavigation(NavigationEvent event, BeforeLeaveEvent beforeNavigation) {
        Deque<BeforeLeaveHandler> leaveHandlers = this.getBeforeLeaveHandlers(beforeNavigation.getUI());
        while (!leaveHandlers.isEmpty()) {
            BeforeLeaveHandler listener = leaveHandlers.remove();
            listener.beforeLeave(beforeNavigation);
            AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
            Optional<Integer> result = this.handleTriggeredBeforeEvent(event, beforeNavigation);
            if (result.isPresent()) {
                return result;
            }
            if (!beforeNavigation.isPostponed()) continue;
            this.postponed = Postpone.withLeaveObservers(leaveHandlers);
            BeforeLeaveEvent.ContinueNavigationAction currentAction = beforeNavigation.getContinueNavigationAction();
            currentAction.setReferences(this, event);
            this.storeContinueNavigationAction(event.getUI(), currentAction);
            return Optional.of(HttpStatusCode.OK.getCode());
        }
        return Optional.empty();
    }

    private Deque<BeforeLeaveHandler> getBeforeLeaveHandlers(UI ui) {
        Deque<BeforeLeaveHandler> leaveHandlers;
        if (this.postponed != null) {
            leaveHandlers = this.postponed.getLeaveObservers();
            if (!leaveHandlers.isEmpty()) {
                this.postponed = null;
            }
        } else {
            ArrayList<BeforeLeaveHandler> beforeLeaveHandlers = new ArrayList<BeforeLeaveHandler>(ui.getNavigationListeners(BeforeLeaveHandler.class));
            beforeLeaveHandlers.addAll(EventUtil.collectBeforeLeaveObservers(ui));
            leaveHandlers = new ArrayDeque<BeforeLeaveHandler>(beforeLeaveHandlers);
        }
        return leaveHandlers;
    }

    private Optional<Integer> createChainIfEmptyAndExecuteBeforeEnterNavigation(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        ArrayList<BeforeEnterHandler> registeredEnterHandlers = new ArrayList<BeforeEnterHandler>(beforeNavigation.getUI().getNavigationListeners(BeforeEnterHandler.class));
        Optional<Integer> result = this.sendBeforeEnterEvent(registeredEnterHandlers, event, beforeNavigation, null);
        if (result.isPresent()) {
            return result;
        }
        if (chain.isEmpty()) {
            return this.sendBeforeEnterEventAndPopulateChain(beforeNavigation, event, chain);
        }
        return this.sendBeforeEnterEventToExistingChain(beforeNavigation, event, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Integer> sendBeforeEnterEventAndPopulateChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        List<HasElement> oldChain = event.getUI().getInternals().getActiveRouterTargetsChain();
        List<Class<? extends HasElement>> typesChain = this.getTypesChain();
        try {
            for (int i = 0; i < typesChain.size(); ++i) {
                HasElement element = AbstractNavigationStateRenderer.getRouteTarget(typesChain.get(i), event, i == typesChain.size() - 1);
                if (!beforeNavigation.isErrorEvent()) {
                    UsageStatistics.markAsUsed("flow-router", null);
                }
                chain.add(element);
                ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChainElement(element, oldChain));
                boolean lastElement = chain.size() == typesChain.size();
                Optional<Integer> result = this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, lastElement ? chain : null);
                if (!result.isPresent()) continue;
                Optional<Integer> optional = result;
                return optional;
            }
            Optional<Integer> optional = Optional.empty();
            return optional;
        }
        finally {
            Collections.reverse(chain);
        }
    }

    private Optional<Integer> sendBeforeEnterEventToExistingChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        chain = new ArrayList<HasElement>(chain);
        Collections.reverse(chain);
        ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChain(chain, event.getUI().getInternals().getActiveRouterTargetsChain()));
        return this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, chain);
    }

    private Optional<Integer> sendBeforeEnterEvent(List<BeforeEnterHandler> eventHandlers, NavigationEvent event, BeforeEnterEvent beforeNavigation, List<HasElement> chain) {
        Optional<Integer> result;
        Component componentInstance = null;
        boolean notifyNavigationTarget = false;
        if (chain != null) {
            chain = new ArrayList<HasElement>(chain);
            Collections.reverse(chain);
            componentInstance = (Component)chain.get(0);
            this.locationChangeEvent = new LocationChangeEvent(event.getSource(), event.getUI(), event.getTrigger(), event.getLocation(), chain);
            notifyNavigationTarget = true;
        }
        for (BeforeEnterHandler eventHandler : eventHandlers) {
            Optional<Integer> result2;
            if (notifyNavigationTarget && AbstractNavigationStateRenderer.isComponentElementEqualsOrChild(eventHandler, componentInstance)) {
                result2 = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance);
                if (result2.isPresent()) {
                    return result2;
                }
                notifyNavigationTarget = false;
            }
            if (!(result2 = this.sendBeforeEnterEvent(event, beforeNavigation, eventHandler)).isPresent()) continue;
            return result2;
        }
        if (notifyNavigationTarget && (result = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance)).isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private Optional<Integer> sendBeforeEnterEvent(NavigationEvent event, BeforeEnterEvent beforeNavigation, BeforeEnterHandler eventHandler) {
        eventHandler.beforeEnter(beforeNavigation);
        AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
        return this.handleTriggeredBeforeEvent(event, beforeNavigation);
    }

    private Optional<Integer> notifyNavigationTarget(NavigationEvent event, BeforeEnterEvent beforeNavigation, LocationChangeEvent locationChangeEvent, Component componentInstance) {
        this.notifyNavigationTarget(componentInstance, event, beforeNavigation, locationChangeEvent);
        return this.handleTriggeredBeforeEvent(event, beforeNavigation);
    }

    private static boolean isComponentElementEqualsOrChild(BeforeEnterHandler eventHandler, Component component) {
        if (eventHandler instanceof HasElement) {
            HasElement hasElement = (HasElement)((Object)eventHandler);
            Element componentElement = component.getElement();
            for (Element element = hasElement.getElement(); element != null; element = element.getParent()) {
                if (!element.equals(componentElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected Optional<Integer> handleTriggeredBeforeEvent(NavigationEvent event, BeforeEvent beforeEvent) {
        boolean queryParameterChanged;
        if (beforeEvent.hasExternalForwardUrl()) {
            return Optional.of(this.forwardToExternalUrl(event, beforeEvent));
        }
        boolean bl = queryParameterChanged = beforeEvent.hasRedirectQueryParameters() && !beforeEvent.getRedirectQueryParameters().equals(event.getLocation().getQueryParameters());
        if (beforeEvent.hasForwardTarget() && (!this.isSameNavigationState(beforeEvent.getForwardTargetType(), beforeEvent.getForwardTargetRouteParameters()) || queryParameterChanged || this.navigationState.getResolvedPath() == null || !this.navigationState.getResolvedPath().equals(beforeEvent.getForwardUrl()))) {
            return Optional.of(this.forward(event, beforeEvent));
        }
        if (beforeEvent.hasRerouteTarget() && (!this.isSameNavigationState(beforeEvent.getRerouteTargetType(), beforeEvent.getRerouteTargetRouteParameters()) || queryParameterChanged)) {
            return Optional.of(this.reroute(event, beforeEvent));
        }
        return Optional.empty();
    }

    private boolean isSameNavigationState(Class<? extends Component> targetType, RouteParameters targetParameters) {
        boolean sameTarget = this.navigationState.getNavigationTarget().equals(targetType);
        boolean sameParameters = targetParameters.equals(this.navigationState.getRouteParameters());
        return sameTarget && sameParameters;
    }

    private int forwardToExternalUrl(NavigationEvent event, BeforeEvent beforeNavigation) {
        event.getUI().getPage().setLocation(beforeNavigation.getExternalForwardUrl());
        return HttpStatusCode.OK.getCode();
    }

    private int forward(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getForwardTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        newNavigationEvent.getUI().getPage().getHistory().replaceState(null, newNavigationEvent.getLocation(), beforeNavigation.isUseForwardCallback());
        return handler.handle(newNavigationEvent);
    }

    private int reroute(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getRerouteTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        return handler.handle(newNavigationEvent);
    }

    private NavigationEvent getNavigationEvent(NavigationEvent event, BeforeEvent beforeNavigation) {
        if (beforeNavigation.hasErrorParameter()) {
            ErrorParameter<?> errorParameter = beforeNavigation.getErrorParameter();
            return new ErrorNavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.PROGRAMMATIC, errorParameter);
        }
        boolean isForward = beforeNavigation.hasForwardTarget();
        String url = isForward ? beforeNavigation.getForwardUrl() : beforeNavigation.getRerouteUrl();
        if (url == null) {
            RouteParameters redirectParameters;
            Class<? extends Component> redirectTarget;
            String redirectType;
            if (isForward) {
                redirectType = "forward";
                redirectTarget = beforeNavigation.getForwardTargetType();
                redirectParameters = beforeNavigation.getForwardTargetRouteParameters();
            } else {
                redirectType = "reroute";
                redirectTarget = beforeNavigation.getRerouteTargetType();
                redirectParameters = beforeNavigation.getRerouteTargetRouteParameters();
            }
            throw new IllegalStateException(String.format("Attempting to %s to unresolved location target %s with route parameters %s", redirectType, redirectTarget, redirectParameters));
        }
        QueryParameters queryParameters = beforeNavigation.hasRedirectQueryParameters() ? beforeNavigation.getRedirectQueryParameters() : event.getLocation().getQueryParameters();
        Location location = new Location(url, queryParameters);
        return new NavigationEvent(event.getSource(), location, event.getUI(), NavigationTrigger.PROGRAMMATIC, null, true);
    }

    private Optional<ArrayList<HasElement>> getPreservedChain(NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        if (ui.getInternals().getExtendedClientDetails() == null) {
            if (AbstractNavigationStateRenderer.hasPreservedChainOfLocation(session, location)) {
                ui.getPage().retrieveExtendedClientDetails(details -> this.handle(event));
                return Optional.empty();
            }
        } else {
            String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
            Optional<ArrayList<HasElement>> maybePreserved = AbstractNavigationStateRenderer.getPreservedChain(session, windowName, event.getLocation());
            if (maybePreserved.isPresent()) {
                ArrayList<HasElement> chain = maybePreserved.get();
                HasElement root = chain.get(chain.size() - 1);
                Component component = (Component)chain.get(0);
                Optional<UI> maybePrevUI = component.getUI();
                if (maybePrevUI.isPresent() && maybePrevUI.get().equals(ui)) {
                    return Optional.of(chain);
                }
                root.getElement().removeFromTree(false);
                maybePrevUI.ifPresent(prevUi -> {
                    ui.getInternals().moveElementsFrom((UI)prevUi);
                    prevUi.close();
                });
                return Optional.of(chain);
            }
        }
        return Optional.of(new ArrayList(0));
    }

    private void setPreservedChain(ArrayList<HasElement> chain, NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        ExtendedClientDetails extendedClientDetails = ui.getInternals().getExtendedClientDetails();
        if (extendedClientDetails == null) {
            ui.getPage().retrieveExtendedClientDetails(details -> AbstractNavigationStateRenderer.setPreservedChain(session, details.getWindowName(), location, chain));
        } else {
            String windowName = extendedClientDetails.getWindowName();
            AbstractNavigationStateRenderer.setPreservedChain(session, windowName, location, chain);
        }
    }

    private static void validateStatusCode(int statusCode, Class<? extends Component> targetClass) {
        if (!HttpStatusCode.isValidStatusCode(statusCode)) {
            String msg = String.format("Error state code must be a valid HttpStatusCode value. Received invalid value of '%s' for '%s'", statusCode, targetClass.getName());
            throw new IllegalStateException(msg);
        }
    }

    private static void validateBeforeEvent(BeforeEvent event) {
        if (event.hasForwardTarget() && event.hasRerouteTarget()) {
            throw new IllegalStateException("Error forward & reroute can not be set at the same time");
        }
    }

    private static void checkForDuplicates(Class<? extends Component> routeTargetType, Collection<Class<? extends RouterLayout>> routeLayoutTypes) {
        HashSet<Class<HasElement>> duplicateCheck = new HashSet<Class<HasElement>>();
        duplicateCheck.add(routeTargetType);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            if (duplicateCheck.add(parentType)) continue;
            throw new IllegalArgumentException(parentType + " is used in multiple locations");
        }
    }

    private static void updatePageTitle(NavigationEvent navigationEvent, Component routeTarget, String route) {
        Supplier<String> lookForTitleInTarget = () -> AbstractNavigationStateRenderer.lookForTitleInTarget(routeTarget).map(PageTitle::value).orElse("");
        String title = RouteUtil.getDynamicTitle(navigationEvent.getUI()).orElseGet(() -> Optional.ofNullable(MenuRegistry.getClientRoutes(true).get(route)).map(AvailableViewInfo::title).orElseGet(lookForTitleInTarget));
        navigationEvent.getUI().getPage().setTitle(title);
    }

    private static Optional<PageTitle> lookForTitleInTarget(Component routeTarget) {
        return Optional.ofNullable(routeTarget.getClass().getAnnotation(PageTitle.class));
    }

    private static boolean isPreserveOnRefreshTarget(Class<? extends Component> routeTargetType, List<Class<? extends RouterLayout>> routeLayoutTypes) {
        return routeTargetType.isAnnotationPresent(PreserveOnRefresh.class) || routeLayoutTypes.stream().anyMatch(layoutType -> layoutType.isAnnotationPresent(PreserveOnRefresh.class));
    }

    static boolean hasPreservedChain(VaadinSession session) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && !cache.isEmpty();
    }

    static boolean hasPreservedChainOfLocation(VaadinSession session, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && cache.values().stream().anyMatch(entry -> ((String)entry.getFirst()).equals(location.getPath()));
    }

    static Optional<ArrayList<HasElement>> getPreservedChain(VaadinSession session, String windowName, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache != null && cache.containsKey(windowName) && ((String)((Pair)cache.get(windowName)).getFirst()).equals(location.getPath())) {
            return Optional.of((ArrayList)((Pair)cache.get(windowName)).getSecond());
        }
        return Optional.empty();
    }

    static void setPreservedChain(VaadinSession session, String windowName, Location location, ArrayList<HasElement> chain) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache == null) {
            cache = new PreservedComponentCache();
        }
        cache.put(windowName, new Pair<String, ArrayList<HasElement>>(location.getPath(), chain));
        session.setAttribute(PreservedComponentCache.class, cache);
    }

    private static void clearAllPreservedChains(UI ui) {
        VaadinSession session = ui.getSession();
        if (AbstractNavigationStateRenderer.hasPreservedChain(session)) {
            ui.getPage().retrieveExtendedClientDetails(details -> {
                String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
                PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
                if (cache != null) {
                    cache.remove(windowName);
                }
            });
        }
    }

    public static void purgeInactiveUIPreservedChainCache(UI inactiveUI) {
        if (!inactiveUI.isClosing()) {
            throw new IllegalStateException("Cannot purge preserved chain cache for an active UI");
        }
        VaadinSession session = inactiveUI.getSession();
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache != null && !cache.isEmpty()) {
            StateNode uiNode = inactiveUI.getElement().getNode();
            Set<String> inactiveWindows = cache.entrySet().stream().filter(e -> {
                ArrayList chain = (ArrayList)((Pair)e.getValue()).getSecond();
                StateNode chainNode = ((HasElement)chain.get(0)).getElement().getNode();
                while (chainNode.getParent() != null) {
                    chainNode = chainNode.getParent();
                }
                return uiNode == chainNode;
            }).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (!inactiveWindows.isEmpty()) {
                LoggerFactory.getLogger(AbstractNavigationStateRenderer.class).debug("Removing preserved chain cache for inactive UI {} on VaadinSession {} (windows: {})", new Object[]{inactiveUI.getUIId(), session.getSession().getId(), inactiveWindows});
            }
            inactiveWindows.forEach(cache::remove);
        }
    }

    private static class PreservedComponentCache
    extends HashMap<String, Pair<String, ArrayList<HasElement>>> {
        private PreservedComponentCache() {
        }
    }
}

