/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;

public class UrlUtil {
    private UrlUtil() {
    }

    public static boolean isExternal(String url) {
        if (url.startsWith("//")) {
            return true;
        }
        return url.contains("://");
    }

    public static String encodeURI(String uri) {
        try {
            return URLEncoder.encode(uri, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%2F", "/").replace("%40", "@").replace("%3B", ";").replace("%2C", ",").replace("%3F", "?").replace("%3A", ":").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%23", "#");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }

    public static String encodeURIComponent(String path) {
        try {
            return URLEncoder.encode(path, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding the URI failed", e);
        }
    }

    public static String getServletPathRelative(String absolutePath, HttpServletRequest request) {
        int i;
        Object pathToServlet = request.getContextPath() + request.getServletPath();
        if (((String)pathToServlet).startsWith("/")) {
            pathToServlet = ((String)pathToServlet).substring(1);
        }
        if (absolutePath.startsWith("/")) {
            absolutePath = absolutePath.substring(1);
        }
        String[] servletPathSegments = ((String)pathToServlet).isEmpty() ? new String[]{} : ((String)pathToServlet).split("/");
        String[] absolutePathSegments = absolutePath.isEmpty() ? new String[]{} : absolutePath.split("/");
        for (int startFrom = 0; absolutePathSegments.length > startFrom && servletPathSegments.length > startFrom && absolutePathSegments[startFrom].equals(servletPathSegments[startFrom]); ++startFrom) {
        }
        Object ret = "";
        for (i = startFrom; i < servletPathSegments.length; ++i) {
            ret = (String)ret + "../";
        }
        for (i = startFrom; i < absolutePathSegments.length; ++i) {
            ret = (String)ret + absolutePathSegments[i] + "/";
        }
        if (((String)ret).isEmpty()) {
            return ".";
        }
        return ((String)ret).substring(0, ((String)ret).length() - 1);
    }
}

