/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.InternalRedirectHandler;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorRouteRegistry;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Router
implements Serializable {
    private RouteResolver routeResolver;
    private final RouteRegistry registry;

    public Router(RouteRegistry registry) {
        assert (registry != null);
        this.registry = registry;
        this.routeResolver = new DefaultRouteResolver();
    }

    public void initializeUI(UI ui, VaadinRequest initRequest) {
        Location location = this.getLocationForRequest(ui.getSession(), initRequest.getPathInfo(), initRequest.getParameterMap());
        ui.getPage().getHistory().setHistoryStateChangeHandler(e -> this.navigate(ui, e.getLocation(), e.getTrigger(), e.getState().orElse(null)));
        int statusCode = this.navigate(ui, location, NavigationTrigger.PAGE_LOAD);
        VaadinResponse response = VaadinService.getCurrentResponse();
        if (response != null) {
            response.setStatus(statusCode);
        }
    }

    private Location getLocationForRequest(VaadinSession session, String pathInfo, Map<String, String[]> parameterMap) {
        String path;
        if (pathInfo == null) {
            path = "";
        } else {
            assert (pathInfo.startsWith("/"));
            path = pathInfo.substring(1);
        }
        QueryParameters queryParameters = QueryParameters.full(parameterMap);
        try {
            return new Location(path, queryParameters);
        }
        catch (InvalidLocationException invalidLocationException) {
            session.getErrorHandler().error(new ErrorEvent(invalidLocationException));
            int index = path.indexOf(63);
            String encodedPath = path;
            if (index >= 0) {
                encodedPath = path.substring(0, index);
            }
            try {
                encodedPath = path.startsWith("/") ? URLEncoder.encode(path.substring(1), StandardCharsets.UTF_8.name()) : URLEncoder.encode(path, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LoggerFactory.getLogger((String)Router.class.getName()).warn("Exception when encoding path {}", (Object)path, (Object)e);
            }
            return new Location(encodedPath);
        }
    }

    public Optional<NavigationState> resolveNavigationTarget(String pathInfo, Map<String, String[]> parameterMap) {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            throw new IllegalStateException("There is no VaadinSession instance available in the context via VaadinSession.getCurrent(). It means that the method is called outsie a session lock. Make sure that the method is called either inside request dispatcher thread (with an implicit session lock) oryour are using VaadinSession::access() to run the command with a proper lock from a custom thread.");
        }
        Location location = this.getLocationForRequest(session, pathInfo, parameterMap);
        NavigationState resolve = null;
        try {
            resolve = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        }
        catch (NotFoundException nfe) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Failed to resolve navigation target for path: {}", (Object)pathInfo, (Object)nfe);
        }
        return Optional.ofNullable(resolve);
    }

    public int navigate(UI ui, Location location, NavigationTrigger trigger) {
        return this.navigate(ui, location, trigger, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int navigate(UI ui, Location location, NavigationTrigger trigger, JsonValue state) {
        assert (ui != null);
        assert (location != null);
        assert (trigger != null);
        ui.getSession().checkHasLock();
        if (this.handleNavigationForLocation(ui, location)) {
            try {
                int n = this.handleNavigation(ui, location, trigger, state);
                return n;
            }
            catch (Exception exception) {
                int n = this.handleExceptionNavigation(ui, location, exception, trigger, state);
                return n;
            }
            finally {
                ui.getInternals().clearLastHandledNavigation();
            }
        }
        return 304;
    }

    private boolean handleNavigationForLocation(UI ui, Location location) {
        if (ui.getInternals().hasLastHandledLocation()) {
            return !location.getPathWithQueryParameters().equals(ui.getInternals().getLastHandledLocation().getPathWithQueryParameters());
        }
        return true;
    }

    private int handleNavigation(UI ui, Location location, NavigationTrigger trigger, JsonValue state) {
        NavigationState newState = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        if (newState != null) {
            NavigationEvent navigationEvent = new NavigationEvent(this, location, ui, trigger, state, false);
            NavigationStateRenderer handler = new NavigationStateRenderer(newState);
            return handler.handle(navigationEvent);
        }
        if (!location.getPath().isEmpty()) {
            Location slashToggledLocation = location.toggleTrailingSlash();
            NavigationState slashToggledState = this.getRouteResolver().resolve(new ResolveRequest(this, slashToggledLocation));
            if (slashToggledState != null) {
                NavigationEvent navigationEvent = new NavigationEvent(this, slashToggledLocation, ui, trigger, state, false);
                InternalRedirectHandler handler = new InternalRedirectHandler(slashToggledLocation);
                return handler.handle(navigationEvent);
            }
        }
        throw new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
    }

    private int handleExceptionNavigation(UI ui, Location location, Exception exception, NavigationTrigger trigger, JsonValue state) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getErrorNavigationTarget(exception);
        if (maybeLookupResult.isPresent()) {
            ErrorTargetEntry lookupResult = maybeLookupResult.get();
            ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
            ErrorStateRenderer handler = new ErrorStateRenderer(new NavigationStateBuilder(this).withTarget(lookupResult.getNavigationTarget()).build());
            ErrorNavigationEvent navigationEvent = new ErrorNavigationEvent(this, location, ui, trigger, errorParameter, state);
            return handler.handle(navigationEvent);
        }
        throw new RuntimeException(exception);
    }

    private RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    @Deprecated
    public String getUrl(Class<? extends Component> navigationTarget) {
        return RouteConfiguration.forRegistry(this.getRegistry()).getUrl(navigationTarget);
    }

    @Deprecated
    public String getUrlBase(Class<? extends Component> navigationTarget) {
        return RouteConfiguration.forRegistry(this.getRegistry()).getUrlBase(navigationTarget).orElse(null);
    }

    @Deprecated
    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, T parameter) {
        return RouteConfiguration.forRegistry(this.getRegistry()).getUrl(navigationTarget, parameter);
    }

    @Deprecated
    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, List<T> parameters) {
        return RouteConfiguration.forRegistry(this.getRegistry()).getUrl(navigationTarget, parameters);
    }

    public RouteRegistry getRegistry() {
        if (VaadinSession.getCurrent() != null) {
            return SessionRouteRegistry.getSessionRegistry(VaadinSession.getCurrent());
        }
        return this.registry;
    }

    @Deprecated
    public List<RouteData> getRoutes() {
        return RouteConfiguration.forRegistry(this.getRegistry()).getAvailableRoutes();
    }

    @Deprecated
    public Map<Class<? extends RouterLayout>, List<RouteData>> getRoutesByParent() {
        HashMap<Class<? extends RouterLayout>, List<RouteData>> grouped = new HashMap<Class<? extends RouterLayout>, List<RouteData>>();
        for (RouteData route : this.getRoutes()) {
            List routeDataList = grouped.computeIfAbsent(route.getParentLayout(), key -> new ArrayList());
            routeDataList.add(route);
        }
        return grouped;
    }

    @Deprecated
    public static String resolve(Class<?> component, Route route) {
        return RouteUtil.resolve(component, route);
    }

    protected Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        if (this.registry instanceof ErrorRouteRegistry) {
            return ((ErrorRouteRegistry)((Object)this.registry)).getErrorNavigationTarget(exception);
        }
        return Optional.empty();
    }
}

