/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.templatemodel.BeanModelType;
import com.vaadin.flow.templatemodel.Exclude;
import com.vaadin.flow.templatemodel.Include;
import com.vaadin.flow.templatemodel.ListModelType;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.TemplateModel;
import com.vaadin.flow.templatemodel.TemplateModelProxyHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class TemplateModelUtil {
    private TemplateModelUtil() {
    }

    public static <R> R resolveBeanAndRun(TemplateModel model, String modelPath, BiFunction<BeanModelType<?>, ElementPropertyMap, R> callback) {
        assert (model != null);
        assert (modelPath != null);
        assert (callback != null);
        BeanModelType<?> modelType = TemplateModelProxyHandler.getModelTypeForProxy(model);
        ModelType beanType = modelType.resolveType(modelPath);
        if (beanType instanceof BeanModelType) {
            StateNode stateNode = TemplateModelProxyHandler.getStateNodeForProxy(model);
            ElementPropertyMap modelMap = ElementPropertyMap.getModel(stateNode);
            ElementPropertyMap beanMap = modelMap.resolveModelMap(modelPath);
            return callback.apply((BeanModelType)beanType, beanMap);
        }
        throw new IllegalArgumentException(modelPath + " does not resolve to a bean");
    }

    public static <R> R resolveListAndRun(TemplateModel model, String modelPath, BiFunction<ListModelType<?>, ModelList, R> callback) {
        assert (model != null);
        assert (modelPath != null);
        assert (callback != null);
        BeanModelType<?> modelType = TemplateModelProxyHandler.getModelTypeForProxy(model);
        ModelType listType = modelType.resolveType(modelPath);
        if (listType instanceof ListModelType) {
            StateNode stateNode = TemplateModelProxyHandler.getStateNodeForProxy(model);
            ElementPropertyMap modelMap = ElementPropertyMap.getModel(stateNode);
            ModelList modelList = modelMap.resolveModelList(modelPath);
            return callback.apply((ListModelType)listType, modelList);
        }
        throw new IllegalArgumentException(modelPath + " does not resolve to a list");
    }

    public static Predicate<String> getFilterFromIncludeExclude(Method method) {
        Exclude exclude = method.getAnnotation(Exclude.class);
        Include include = method.getAnnotation(Include.class);
        HashSet toExclude = new HashSet();
        HashSet<String> toInclude = new HashSet<String>();
        if (exclude != null) {
            Collections.addAll(toExclude, exclude.value());
        }
        if (include != null) {
            for (String includeProperty : include.value()) {
                toInclude.add(includeProperty);
                String property = includeProperty;
                int dotLocation = property.lastIndexOf(46);
                while (dotLocation != -1) {
                    property = property.substring(0, dotLocation);
                    toInclude.add(property);
                    dotLocation = property.lastIndexOf(46);
                }
            }
        }
        return propertyName -> {
            if (toExclude.contains(propertyName)) {
                return false;
            }
            if (!toInclude.isEmpty()) {
                return toInclude.contains(propertyName);
            }
            return true;
        };
    }
}

