/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.polymertemplate.JsoupUtils;
import com.vaadin.flow.internal.StringUtil;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class BundleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleParser.class);
    private static final Pattern POLYMER_TEMPLATE_PATTERN = Pattern.compile("get[\\s]*template\\(\\)[\\s]*\\{[\\s]*return[\\s]*html[\\s]*([\\`\\'\\\"])([\\s\\S]*)\\1;[\\s]*\\}");
    private static final Pattern NO_TEMPLATE_PATTERN = Pattern.compile("innerHTML[\\s]*=[\\s]*([\\`\\'\\\"])([\\s]*<dom-module\\s+[\\s\\S]*)\\1;");
    private static final String TEMPLATE_TAG_NAME = "template";

    private BundleParser() {
    }

    public static Element parseTemplateElement(String fileName, String source) {
        Element template;
        Document templateDocument = null;
        String content = StringUtil.removeComments((String)source);
        Matcher templateMatcher = POLYMER_TEMPLATE_PATTERN.matcher(content);
        Matcher noTemplateMatcher = NO_TEMPLATE_PATTERN.matcher(content);
        if (templateMatcher.find() && templateMatcher.groupCount() == 2) {
            String group = templateMatcher.group(2);
            LOGGER.trace("Found regular Polymer 3 template content was {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
        } else {
            template = BundleParser.tryParsePolymer2(templateDocument, noTemplateMatcher);
            if (template != null) {
                return template;
            }
        }
        if (templateDocument == null) {
            LOGGER.warn("No polymer template data found in {} sources.", (Object)fileName);
            templateDocument = new Document("");
            templateDocument.appendChild((Node)templateDocument.createElement("body"));
        }
        template = templateDocument.createElement(TEMPLATE_TAG_NAME);
        Element body = templateDocument.body();
        templateDocument.body().children().stream().filter(node -> !node.equals((Object)body)).forEach(arg_0 -> ((Element)template).appendChild(arg_0));
        return template;
    }

    private static Element tryParsePolymer2(Document templateDocument, Matcher noTemplateMatcher) {
        while (noTemplateMatcher.find() && noTemplateMatcher.groupCount() == 2) {
            String group = noTemplateMatcher.group(2);
            LOGGER.trace("Found Polymer 2 style insertion as a Polymer 3 template content {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
            Optional<Element> domModule = JsoupUtils.getDomModule((Element)templateDocument, null);
            if (!domModule.isPresent()) continue;
            JsoupUtils.removeCommentsRecursively((Node)domModule.get());
            Elements templates = domModule.get().getElementsByTag(TEMPLATE_TAG_NAME);
            if (templates.isEmpty()) continue;
            return (Element)templates.get(0);
        }
        return null;
    }
}

