/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.polymertemplate.IdCollector;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateInitializer;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.component.template.internal.InjectableFieldConsumer;
import com.vaadin.flow.component.template.internal.ParserData;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.server.VaadinService;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

@Deprecated
public class TemplateDataAnalyzer {
    private static final Pattern TWO_WAY_BINDING_PATTERN = Pattern.compile("\\s*\\{\\{([^}:]*)(::[^}]*)?\\}\\}\\s*");
    private final Class<? extends PolymerTemplate<?>> templateClass;
    private final TemplateParser parser;
    private final String tag;
    private final VaadinService service;
    private final Collection<SubTemplateData> subTemplates = new ArrayList<SubTemplateData>();
    private final Set<String> twoWayBindingPaths = new HashSet<String>();
    private final Set<String> notInjectableElementIds = new HashSet<String>();
    private String modulePath;

    TemplateDataAnalyzer(Class<? extends PolymerTemplate<?>> templateClass, TemplateParser parser, VaadinService service) {
        this.templateClass = templateClass;
        this.parser = parser;
        this.service = service;
        this.tag = this.getTag(templateClass);
    }

    PolymerParserData parseTemplate() {
        TemplateParser.TemplateData templateData = this.parser.getTemplateContent(this.templateClass, this.tag, this.service);
        Element templateRoot = templateData.getTemplateElement();
        this.modulePath = templateData.getModulePath();
        Elements templates = templateRoot.getElementsByTag("template");
        for (Element element : templates) {
            Element parent = element.parent();
            if (parent == null || !this.tag.equals(parent.id())) continue;
            this.inspectCustomElements(element, element);
            this.inspectTwoWayBindings(element);
        }
        IdCollector idExtractor = new IdCollector(this.templateClass, this.modulePath, templateRoot);
        idExtractor.collectInjectedIds(this.notInjectableElementIds);
        return this.readData(idExtractor);
    }

    private void inspectTwoWayBindings(Element element) {
        final Matcher matcher = TWO_WAY_BINDING_PATTERN.matcher("");
        element.traverse(new NodeVisitor(){

            public void head(Node node, int depth) {
                for (Attribute attribute : node.attributes()) {
                    String value = attribute.getValue();
                    if (value == null) continue;
                    matcher.reset(value);
                    if (!matcher.matches()) continue;
                    String path = matcher.group(1);
                    TemplateDataAnalyzer.this.addTwoWayBindingPath(path);
                }
            }

            public void tail(Node node, int depth) {
            }
        });
    }

    private PolymerParserData readData(IdCollector idExtractor) {
        return new PolymerParserData(idExtractor.getIdByField(), idExtractor.getTagById(), idExtractor.getAttributes(), this.twoWayBindingPaths, this.subTemplates);
    }

    private String getTag(Class<? extends PolymerTemplate<?>> clazz) {
        Optional<String> tagNameAnnotation = AnnotationReader.getAnnotationFor(clazz, Tag.class).map(Tag::value);
        assert (tagNameAnnotation.isPresent());
        return tagNameAnnotation.get();
    }

    private void inspectCustomElements(Element childElement, Element templateRoot) {
        if (this.isInsideTemplate(childElement, templateRoot)) {
            this.storeNotInjectableElementId(childElement);
        }
        this.collectCustomElement(childElement, templateRoot);
        childElement.children().forEach(child -> this.inspectCustomElements((Element)child, templateRoot));
    }

    private void collectCustomElement(Element element, Element templateRoot) {
        String tag = element.tagName();
        if (TemplateInitializer.getUsesClass(this.templateClass, tag).isPresent()) {
            if (this.isInsideTemplate(element, templateRoot)) {
                throw new IllegalStateException(String.format("Couldn't parse the template '%s': sub-templates are not supported. Sub-template found: %n'%s'", this.modulePath, element.toString()));
            }
            String id = element.hasAttr("id") ? element.attr("id") : null;
            JsonArray path = this.getPath(element, templateRoot);
            this.addSubTemplate(id, tag, path);
        }
    }

    private JsonArray getPath(Element element, Element templateRoot) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        Element current = element;
        while (!current.equals((Object)templateRoot)) {
            Element parent = current.parent();
            path.add(TemplateDataAnalyzer.indexOf(parent, current));
            current = parent;
        }
        JsonArray array = Json.createArray();
        for (int i = 0; i < path.size(); ++i) {
            array.set(i, (double)((Integer)path.get(path.size() - i - 1)).intValue());
        }
        return array;
    }

    private static int indexOf(Element parent, Element child) {
        Elements children = parent.children();
        int index = -1;
        for (Element nextChild : children) {
            if (!"style".equals(nextChild.tagName())) {
                ++index;
            }
            if (!nextChild.equals((Object)child)) continue;
            break;
        }
        return index;
    }

    private void storeNotInjectableElementId(Element element) {
        String id = element.id();
        if (id != null && !id.isEmpty()) {
            this.addNotInjectableId(id);
        }
    }

    private boolean isInsideTemplate(Element element, Element templateRoot) {
        if (element == templateRoot) {
            return false;
        }
        if ("template".equalsIgnoreCase(element.tagName())) {
            return true;
        }
        return this.isInsideTemplate(element.parent(), templateRoot);
    }

    private void addSubTemplate(String id, String tag, JsonArray path) {
        this.subTemplates.add(new SubTemplateData(id, tag, path));
    }

    private void addNotInjectableId(String id) {
        this.notInjectableElementIds.add(id);
    }

    private void addTwoWayBindingPath(String path) {
        this.twoWayBindingPaths.add(path);
    }

    @Deprecated
    public static class PolymerParserData
    extends ParserData {
        private final Set<String> twoWayBindingPaths;
        private final Collection<SubTemplateData> subTemplates;

        public PolymerParserData(Map<Field, String> fields, Map<String, String> tags, Map<String, Map<String, String>> attributes, Set<String> twoWayBindings, Collection<SubTemplateData> subTemplates) {
            super(fields, tags, attributes);
            this.twoWayBindingPaths = Collections.unmodifiableSet(twoWayBindings);
            this.subTemplates = Collections.unmodifiableCollection(subTemplates);
        }

        public void forEachInjectedField(InjectableFieldCunsumer consumer) {
            InjectableFieldConsumer delegate = (field, id, tag) -> consumer.apply(field, id, tag);
            this.forEachInjectedField(delegate);
        }

        Set<String> getTwoWayBindingPaths() {
            return this.twoWayBindingPaths;
        }

        void forEachSubTemplate(Consumer<SubTemplateData> dataConsumer) {
            this.subTemplates.forEach(dataConsumer);
        }
    }

    static class SubTemplateData {
        private final String id;
        private final String tag;
        private final JsonArray path;

        SubTemplateData(String id, String tag, JsonArray path) {
            this.id = id;
            this.tag = tag;
            this.path = path;
        }

        String getId() {
            return this.id;
        }

        String getTag() {
            return this.tag;
        }

        JsonArray getPath() {
            return this.path;
        }
    }

    @FunctionalInterface
    public static interface InjectableFieldCunsumer
    extends InjectableFieldConsumer {
        public void apply(Field var1, String var2, String var3);
    }
}

