/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support.servlet;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.osgi.support.OSGiVaadinInitialization;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiVaadinServlet
extends VaadinServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        BundleContext bundleContext = FrameworkUtil.getBundle(OSGiVaadinServlet.class).getBundleContext();
        OSGiInitializationTracker tracker = new OSGiInitializationTracker(bundleContext, this.getServletContext());
        tracker.open();
    }

    public void destroy() {
        HashSet<Servlet> servlets;
        BundleContext bundleContext;
        ServletContext servletContext;
        block6: {
            servletContext = this.getServletContext();
            Lookup lookup = (Lookup)new VaadinServletContext(servletContext).getAttribute(Lookup.class);
            super.destroy();
            if (lookup == null) {
                return;
            }
            bundleContext = FrameworkUtil.getBundle(OSGiVaadinServlet.class).getBundleContext();
            servlets = new HashSet<Servlet>();
            try {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundleContext.getAllServiceReferences(Servlet.class.getName(), null)) {
                    servlets.addAll(this.handleDestroy(lookup, reference));
                }
            }
            catch (InvalidSyntaxException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        servlets.remove((Object)this);
        if (servlets.size() > 0) {
            return;
        }
        ServiceReference reference = bundleContext.getServiceReference(OSGiVaadinInitialization.class);
        if (reference == null) {
            return;
        }
        OSGiVaadinInitialization initialization = (OSGiVaadinInitialization)bundleContext.getService(reference);
        initialization.contextDestroyed(new ServletContextEvent(servletContext));
    }

    private Set<Servlet> handleDestroy(Lookup lookup, ServiceReference<?> reference) {
        Bundle[] usingBundles;
        HashSet<Servlet> servlets = new HashSet<Servlet>();
        for (Bundle bundle : usingBundles = reference.getUsingBundles()) {
            ServletContext servletContext;
            Lookup servletLookup;
            Servlet servlet = (Servlet)bundle.getBundleContext().getService(reference);
            if (!(servlet instanceof OSGiVaadinServlet) || (servletLookup = (Lookup)new VaadinServletContext(servletContext = ((VaadinServlet)servlet).getServletContext()).getAttribute(Lookup.class)) != lookup) continue;
            servlets.add(servlet);
        }
        return servlets;
    }

    private static class OSGiInitializationTracker
    extends ServiceTracker<OSGiVaadinInitialization, OSGiVaadinInitialization> {
        private final ServletContext servletContext;

        private OSGiInitializationTracker(BundleContext context, ServletContext servletContext) {
            super(context, OSGiVaadinInitialization.class, null);
            this.servletContext = servletContext;
        }

        public OSGiVaadinInitialization addingService(ServiceReference<OSGiVaadinInitialization> reference) {
            OSGiVaadinInitialization result = (OSGiVaadinInitialization)super.addingService(reference);
            result.contextInitialized(new ServletContextEvent(this.servletContext));
            this.close();
            return result;
        }
    }
}

