/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.osgi.support;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.DevModeInitializer;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.LoggerFactory;

@Component(scope=ServiceScope.SINGLETON, service={ServletContainerInitializerClasses.class})
public final class ServletContainerInitializerClasses {
    private final AtomicReference<Collection<Class<? extends ServletContainerInitializer>>> initializerClasses = new AtomicReference();
    private final Map<Long, Collection<Class<?>>> cachedClasses = new ConcurrentHashMap();
    private final Set<ServletContextReference> contexts = Collections.newSetFromMap(new ConcurrentHashMap());

    public ServletContainerInitializerClasses() {
        UsageStatistics.markAsUsed((String)"flow/osgi", (String)ServletContainerInitializerClasses.getOSGiVersion());
    }

    public void setServletContainerInitializers(Collection<Class<? extends ServletContainerInitializer>> contextInitializers) {
        assert (contextInitializers != null);
        this.initializerClasses.set(new ArrayList<Class<? extends ServletContainerInitializer>>(contextInitializers));
    }

    public boolean hasInitializers() {
        return this.initializerClasses.get() != null;
    }

    public void addScannedClasses(Map<Long, Collection<Class<?>>> extenderClasses) {
        this.cachedClasses.putAll(extenderClasses);
        ArrayList<InvalidApplicationConfigurationException> thrown = new ArrayList<InvalidApplicationConfigurationException>();
        Iterator<ServletContextReference> iterator = this.contexts.iterator();
        while (iterator.hasNext()) {
            WeakReference ref = iterator.next();
            ServletContext context = (ServletContext)ref.get();
            if (context == null) {
                iterator.remove();
            }
            try {
                this.resetContextInitializers(context);
            }
            catch (InvalidApplicationConfigurationException exception) {
                thrown.add(exception);
            }
        }
        if (!thrown.isEmpty()) {
            throw (InvalidApplicationConfigurationException)((Object)thrown.get(0));
        }
    }

    public void removeScannedClasses(Long bundleId) {
        this.cachedClasses.remove(bundleId);
        this.contexts.forEach(this::resetContextInitializers);
    }

    public void addContext(ServletContext servletContext) {
        this.contexts.add(new ServletContextReference(servletContext));
        if (this.hasInitializers()) {
            this.resetContextInitializers(servletContext);
        }
    }

    public void removeContext(ServletContext servletContext) {
        this.contexts.remove(new ServletContextReference(servletContext));
    }

    private void resetContextInitializers(ServletContextReference reference) {
        ServletContext context = (ServletContext)reference.get();
        if (context != null) {
            this.resetContextInitializers(context);
        }
    }

    private void resetContextInitializers(ServletContext context) {
        this.initializerClasses.get().stream().filter(clazz -> !clazz.equals(DevModeInitializer.class) && !clazz.equals(LookupServletContainerInitializer.class)).map(ReflectTools::createInstance).forEach(initializer -> this.handleTypes((ServletContainerInitializer)initializer, context));
    }

    private void handleTypes(ServletContainerInitializer initializer, ServletContext context) {
        Optional handleTypes = AnnotationReader.getAnnotationFor(initializer.getClass(), HandlesTypes.class);
        assert (initializer instanceof ClassLoaderAwareServletContainerInitializer);
        try {
            ((ClassLoaderAwareServletContainerInitializer)initializer).process(this.filterClasses(handleTypes.orElse(null)), context);
        }
        catch (ServletException e) {
            throw new RuntimeException("Couldn't run servlet context initializer " + initializer.getClass(), e);
        }
    }

    private Set<Class<?>> filterClasses(HandlesTypes typesAnnotation) {
        HashSet result = new HashSet();
        if (typesAnnotation == null) {
            this.cachedClasses.forEach((bundle, classes) -> result.addAll((Collection<Class<?>>)classes));
        } else {
            Class[] requestedTypes = typesAnnotation.value();
            Predicate<Class> isAnnotation = Class::isAnnotation;
            List annotations = Stream.of(requestedTypes).filter(isAnnotation).map(clazz -> clazz).collect(Collectors.toList());
            List superTypes = Stream.of(requestedTypes).filter(isAnnotation.negate()).collect(Collectors.toList());
            Predicate<Class> hasType = clazz -> annotations.stream().anyMatch(annotation -> AnnotationReader.getAnnotationFor((Class)clazz, (Class)annotation).isPresent()) || superTypes.stream().anyMatch(superType -> GenericTypeReflector.isSuperType(HasErrorParameter.class, (Type)clazz));
            this.cachedClasses.forEach((bundle, classes) -> result.addAll(classes.stream().filter(hasType).collect(Collectors.toList())));
        }
        return result;
    }

    private static String getOSGiVersion() {
        try {
            Bundle osgiBundle = FrameworkUtil.getBundle(Bundle.class);
            return osgiBundle.getVersion().toString();
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(ServletContainerInitializerClasses.class).info("Unable to detect used OSGi framework version due to " + throwable.getMessage());
            return null;
        }
    }

    private static class ServletContextReference
    extends WeakReference<ServletContext> {
        private ServletContextReference(ServletContext context) {
            super(context);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(ServletContextReference.class)) {
                return false;
            }
            return Objects.equals(((ServletContextReference)obj).get(), this.get());
        }

        public int hashCode() {
            ServletContext servletContext = (ServletContext)this.get();
            if (servletContext == null) {
                return super.hashCode();
            }
            return servletContext.hashCode();
        }
    }
}

