/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.internal.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleLitParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleLitParser.class);
    private static final Pattern LIT_TEMPLATE_PATTERN = Pattern.compile("render\\(\\)[\\s]*\\{[\\s\\S]*\\}");
    private static final Pattern LIT_TEMPLATE_PATTERN_HTML = Pattern.compile("return[\\s]*html[\\s]*(\\`)([\\s\\S]*?)\\1;[\\s]*\\}");
    private static final String TEMPLATE_TAG_NAME = "template";

    private BundleLitParser() {
    }

    public static Element parseLitTemplateElement(String fileName, String source) {
        String renderGroup;
        Matcher templateMatcher;
        Document templateDocument = null;
        String content = StringUtil.removeComments((String)source);
        Matcher renderMatcher = LIT_TEMPLATE_PATTERN.matcher(content);
        if (renderMatcher.find() && (templateMatcher = LIT_TEMPLATE_PATTERN_HTML.matcher(renderGroup = renderMatcher.group(0))).find() && templateMatcher.groupCount() >= 2) {
            String group = templateMatcher.group(2);
            LOGGER.trace("Found regular Lit template content was {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
            Element template = templateDocument.createElement(TEMPLATE_TAG_NAME);
            Element body = templateDocument.body();
            templateDocument.body().children().stream().filter(node -> !node.equals((Object)body)).forEach(arg_0 -> ((Element)template).appendChild(arg_0));
            return template;
        }
        LOGGER.warn("No lit template data found in {} sources.", (Object)fileName);
        return null;
    }
}

