/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.NativeTableCell;
import com.vaadin.flow.component.html.NativeTableHeaderCell;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Tag(value="tr")
public class NativeTableRow
extends HtmlContainer
implements HasOrderedComponents,
ClickNotifier<NativeTableRow> {
    public NativeTableRow() {
    }

    public NativeTableRow(Component ... components) {
        super(components);
    }

    public NativeTableHeaderCell addHeaderCell() {
        NativeTableHeaderCell cell = new NativeTableHeaderCell();
        this.add(new Component[]{cell});
        return cell;
    }

    public NativeTableHeaderCell insertHeaderCell(int position) {
        if (position == 0) {
            return this.addHeaderCell();
        }
        NativeTableHeaderCell headerCell = new NativeTableHeaderCell();
        this.addComponentAtIndex(position, (Component)headerCell);
        return headerCell;
    }

    public NativeTableCell addDataCell() {
        NativeTableCell cell = new NativeTableCell();
        this.add(new Component[]{cell});
        return cell;
    }

    public NativeTableCell insertDataCell(int position) {
        if (position == 0) {
            return this.addDataCell();
        }
        NativeTableCell nativeTableCell = new NativeTableCell();
        this.addComponentAtIndex(position, (Component)nativeTableCell);
        return nativeTableCell;
    }

    public List<NativeTableHeaderCell> getHeaderCells() {
        return this.getChildren().filter(c -> c instanceof NativeTableHeaderCell).map(c -> (NativeTableHeaderCell)((Object)c)).collect(Collectors.toList());
    }

    public List<NativeTableCell> getDataCells() {
        return this.getChildren().filter(c -> c instanceof NativeTableCell).map(c -> (NativeTableCell)((Object)c)).collect(Collectors.toList());
    }

    public List<Component> getAllCells() {
        return this.getChildren().filter(c -> c instanceof NativeTableCell || c instanceof NativeTableHeaderCell).collect(Collectors.toList());
    }

    public Optional<NativeTableHeaderCell> getHeaderCell(int index) {
        return this.getChildren().filter(c -> c instanceof NativeTableHeaderCell).map(c -> (NativeTableHeaderCell)((Object)c)).skip(index).findFirst();
    }

    public Optional<NativeTableCell> getDataCell(int index) {
        return this.getChildren().filter(c -> c instanceof NativeTableCell).map(c -> (NativeTableCell)((Object)c)).skip(index).findFirst();
    }

    public Optional<Component> getCell(int index) {
        return this.getChildren().filter(c -> c instanceof NativeTableCell || c instanceof NativeTableHeaderCell).skip(index).findFirst();
    }

    public void removeCell(int index) {
        this.getCell(index).ifPresent(xva$0 -> this.remove(new Component[]{xva$0}));
    }

    public void removeHeaderCell(int index) {
        this.getHeaderCell(index).ifPresent(xva$0 -> this.remove(new Component[]{xva$0}));
    }

    public void removeHeaderCell(NativeTableHeaderCell headerCell) {
        this.remove(new Component[]{headerCell});
    }

    public void removeDataCell(int index) {
        this.getDataCell(index).ifPresent(xva$0 -> this.remove(new Component[]{xva$0}));
    }

    public void removeDataCell(NativeTableCell dataCell) {
        this.remove(new Component[]{dataCell});
    }
}

