/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.NativeTableBody;
import com.vaadin.flow.component.html.NativeTableCaption;
import com.vaadin.flow.component.html.NativeTableFooter;
import com.vaadin.flow.component.html.NativeTableHeader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Tag(value="table")
public class NativeTable
extends HtmlContainer
implements ClickNotifier<NativeTable> {
    private NativeTableCaption caption;
    private NativeTableHeader head;
    private final List<NativeTableBody> bodies = new LinkedList<NativeTableBody>();
    private NativeTableFooter foot;

    public NativeTable() {
    }

    public NativeTable(Component ... components) {
        super(components);
    }

    public NativeTableCaption getCaption() {
        if (this.caption == null) {
            this.caption = new NativeTableCaption();
            this.addComponentAsFirst((Component)this.caption);
        }
        return this.caption;
    }

    public String getCaptionText() {
        return this.getCaption().getText();
    }

    public void setCaptionText(String text) {
        this.getCaption().setText(text);
    }

    public void removeCaption() {
        if (this.caption != null) {
            this.remove(new Component[]{this.caption});
            this.caption = null;
        }
    }

    public NativeTableHeader getHead() {
        if (this.head == null) {
            this.head = new NativeTableHeader();
            int index = this.caption == null ? 0 : 1;
            this.addComponentAtIndex(index, (Component)this.head);
        }
        return this.head;
    }

    public void removeHead() {
        if (this.head != null) {
            this.remove(new Component[]{this.head});
            this.head = null;
        }
    }

    public NativeTableFooter getFoot() {
        if (this.foot == null) {
            this.foot = new NativeTableFooter();
            this.add(new Component[]{this.foot});
        }
        return this.foot;
    }

    public void removeFoot() {
        if (this.foot != null) {
            this.remove(new Component[]{this.foot});
            this.foot = null;
        }
    }

    public List<NativeTableBody> getBodies() {
        return new ArrayList<NativeTableBody>(this.bodies);
    }

    public NativeTableBody getBody() {
        if (this.bodies.isEmpty()) {
            return this.addBody();
        }
        return this.bodies.get(0);
    }

    public NativeTableBody getBody(int index) {
        if (index == 0) {
            return this.getBody();
        }
        return this.bodies.get(index);
    }

    public NativeTableBody addBody() {
        NativeTableBody body = new NativeTableBody();
        int index = this.bodies.size();
        if (this.caption != null) {
            ++index;
        }
        if (this.head != null) {
            ++index;
        }
        this.addComponentAtIndex(index, (Component)body);
        this.bodies.add(body);
        return body;
    }

    public void removeBody(NativeTableBody body) {
        this.remove(new Component[]{body});
        this.bodies.remove(body);
    }

    public void removeBody(int index) {
        NativeTableBody body = this.getBody(index);
        this.removeBody(body);
    }

    public void removeBody() {
        this.removeBody(0);
    }
}

