/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dnd.DragEndEvent;
import com.vaadin.flow.component.dnd.DragStartEvent;
import com.vaadin.flow.component.dnd.EffectAllowed;
import com.vaadin.flow.component.dnd.internal.DndUtil;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;

@JsModule(value="./dndConnector-es6.js")
public interface DragSource<T extends Component>
extends HasElement {
    public static <T extends Component> DragSource<T> create(T component) {
        return DragSource.configure(component, true);
    }

    public static <T extends Component> DragSource<T> configure(final T component) {
        return new DragSource<T>(){

            @Override
            public T getDragSourceComponent() {
                return component;
            }
        };
    }

    public static <T extends Component> DragSource<T> configure(T component, boolean draggable) {
        DragSource<T> dragSource = DragSource.configure(component);
        dragSource.setDraggable(draggable);
        return dragSource;
    }

    default public T getDragSourceComponent() {
        return (T)((Component)this);
    }

    default public Element getElement() {
        return this.getDragSourceComponent().getElement();
    }

    default public Element getDraggableElement() {
        return this.getDragSourceComponent().getElement();
    }

    default public void setDraggable(boolean draggable) {
        if (draggable == this.isDraggable()) {
            return;
        }
        if (draggable) {
            this.getDraggableElement().setProperty("draggable", Boolean.TRUE.toString());
            DndUtil.updateDragSourceActivation(this);
            DndUtil.addMobileDndPolyfillIfNeeded(this.getDragSourceComponent());
            Registration startListenerRegistration = this.addDragStartListener((ComponentEventListener & Serializable)event -> ((UI)this.getDragSourceComponent().getUI().orElseThrow(() -> new IllegalStateException("DragSource not attached to an UI but received a drag start event."))).getInternals().setActiveDragSourceComponent(this.getDragSourceComponent()));
            Registration endListenerRegistration = this.addDragEndListener((ComponentEventListener & Serializable)event -> this.getDragSourceComponent().getUI().orElse(UI.getCurrent()).getInternals().setActiveDragSourceComponent(null));
            ComponentUtil.setData(this.getDragSourceComponent(), (String)"_startListenerRegistration", (Object)startListenerRegistration);
            ComponentUtil.setData(this.getDragSourceComponent(), (String)"_endListenerRegistration", (Object)endListenerRegistration);
        } else {
            Object endListenerRegistration;
            this.getDraggableElement().removeProperty("draggable");
            DndUtil.updateDragSourceActivation(this);
            Object startListenerRegistration = ComponentUtil.getData(this.getDragSourceComponent(), (String)"_startListenerRegistration");
            if (startListenerRegistration instanceof Registration) {
                ((Registration)startListenerRegistration).remove();
            }
            if ((endListenerRegistration = ComponentUtil.getData(this.getDragSourceComponent(), (String)"_endListenerRegistration")) instanceof Registration) {
                ((Registration)endListenerRegistration).remove();
            }
        }
        DndUtil.reportUsage();
    }

    default public boolean isDraggable() {
        return this.getDraggableElement().hasProperty("draggable");
    }

    default public void setDragData(Object data) {
        ComponentUtil.setData(this.getDragSourceComponent(), (String)"drag-source-data", (Object)data);
    }

    default public Object getDragData() {
        return ComponentUtil.getData(this.getDragSourceComponent(), (String)"drag-source-data");
    }

    default public void setEffectAllowed(EffectAllowed effect) {
        if (effect == null) {
            throw new IllegalArgumentException("Allowed effect cannot be null");
        }
        this.getDraggableElement().setProperty("__effectAllowed", effect.getClientPropertyValue());
    }

    default public EffectAllowed getEffectAllowed() {
        return EffectAllowed.valueOf(this.getDraggableElement().getProperty("__effectAllowed", EffectAllowed.UNINITIALIZED.getClientPropertyValue().toUpperCase(Locale.ENGLISH)));
    }

    default public Registration addDragStartListener(ComponentEventListener<DragStartEvent<T>> listener) {
        return ComponentUtil.addListener(this.getDragSourceComponent(), DragStartEvent.class, listener);
    }

    default public Registration addDragEndListener(ComponentEventListener<DragEndEvent<T>> listener) {
        return ComponentUtil.addListener(this.getDragSourceComponent(), DragEndEvent.class, listener);
    }
}

