/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.ErrorLevel;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public interface ValidationResult
extends Serializable {
    public String getErrorMessage();

    public Optional<ErrorLevel> getErrorLevel();

    default public boolean isError() {
        ErrorLevel errorLevel = this.getErrorLevel().orElse(null);
        return errorLevel != null && errorLevel != ErrorLevel.INFO && errorLevel != ErrorLevel.WARNING;
    }

    public static ValidationResult ok() {
        return new SimpleValidationResult(null, null);
    }

    public static ValidationResult error(String errorMessage) {
        Objects.requireNonNull(errorMessage);
        return ValidationResult.create(errorMessage, ErrorLevel.ERROR);
    }

    public static ValidationResult create(String errorMessage, ErrorLevel errorLevel) {
        Objects.requireNonNull(errorMessage);
        Objects.requireNonNull(errorLevel);
        return new SimpleValidationResult(errorMessage, errorLevel);
    }

    public static class SimpleValidationResult
    implements ValidationResult {
        private final String error;
        private final ErrorLevel errorLevel;

        SimpleValidationResult(String error, ErrorLevel errorLevel) {
            if (error != null && errorLevel == null) {
                throw new IllegalStateException("ValidationResult has an error message, but no ErrorLevel is provided.");
            }
            this.error = error;
            this.errorLevel = errorLevel;
        }

        @Override
        public String getErrorMessage() {
            if (!this.getErrorLevel().isPresent()) {
                throw new IllegalStateException("The result is not an error. It cannot contain error message");
            }
            return this.error != null ? this.error : "";
        }

        @Override
        public Optional<ErrorLevel> getErrorLevel() {
            return Optional.ofNullable(this.errorLevel);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            SimpleValidationResult that = (SimpleValidationResult)obj;
            return Objects.equals(that.error, this.error) && Objects.equals((Object)that.errorLevel, (Object)this.errorLevel);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.error, this.errorLevel});
        }

        public String toString() {
            if (this.error == null && this.errorLevel == null) {
                return "ValidationResult{ok}";
            }
            return "ValidationResult{error='" + this.error + "', errorLevel=" + String.valueOf((Object)this.errorLevel) + "}";
        }
    }
}

