/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface Validator<T>
extends BiFunction<T, ValueContext, ValidationResult>,
Serializable {
    @Override
    public ValidationResult apply(T var1, ValueContext var2);

    public static <T> Validator<T> alwaysPass() {
        return (value, context) -> ValidationResult.ok();
    }

    public static <T> Validator<T> alwaysFail(String errorMessage) {
        Objects.requireNonNull(errorMessage);
        return (value, context) -> ValidationResult.error(errorMessage);
    }

    public static <T> Validator<T> from(SerializablePredicate<T> guard, String errorMessage) {
        Objects.requireNonNull(errorMessage, "errorMessage cannot be null");
        return Validator.from(guard, (ErrorMessageProvider & Serializable)(ValueContext ctx) -> errorMessage);
    }

    public static <T> Validator<T> from(SerializablePredicate<T> guard, String errorMessage, ErrorLevel errorLevel) {
        Objects.requireNonNull(errorMessage, "errorMessage cannot be null");
        return Validator.from(guard, (ErrorMessageProvider & Serializable)(ValueContext ctx) -> errorMessage, errorLevel);
    }

    public static <T> Validator<T> from(SerializablePredicate<T> guard, ErrorMessageProvider errorMessageProvider) {
        return Validator.from(guard, errorMessageProvider, ErrorLevel.ERROR);
    }

    public static <T> Validator<T> from(SerializablePredicate<T> guard, ErrorMessageProvider errorMessageProvider, ErrorLevel errorLevel) {
        Objects.requireNonNull(guard, "guard cannot be null");
        Objects.requireNonNull(errorMessageProvider, "errorMessageProvider cannot be null");
        Objects.requireNonNull(errorLevel, "errorLevel cannot be null");
        return (value, context) -> {
            try {
                if (guard.test(value)) {
                    return ValidationResult.ok();
                }
                return ValidationResult.create(errorMessageProvider.apply(context), errorLevel);
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)Validator.class.getName()).info("An exception is thrown during validation", (Throwable)e);
                return ValidationResult.create(errorMessageProvider.apply(context), errorLevel);
            }
        };
    }
}

