/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.HasDataGenerators;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import tools.jackson.databind.node.ObjectNode;

public class CompositeDataGenerator<T>
implements DataGenerator<T>,
HasDataGenerators<T> {
    final Set<DataGenerator<T>> dataGenerators = new LinkedHashSet<DataGenerator<T>>();

    @Override
    public void generateData(T item, ObjectNode jsonObject) {
        this.dataGenerators.forEach(generator -> generator.generateData(item, jsonObject));
    }

    @Override
    public void destroyData(T item) {
        this.dataGenerators.forEach(generator -> generator.destroyData(item));
    }

    @Override
    public void destroyAllData() {
        this.dataGenerators.forEach(DataGenerator::destroyAllData);
    }

    @Override
    public void refreshData(T item) {
        this.dataGenerators.forEach(generator -> generator.refreshData(item));
    }

    @Override
    public Registration addDataGenerator(DataGenerator<T> generator) {
        assert (generator != null) : "generator should not be null";
        this.dataGenerators.add(generator);
        return (Registration & Serializable)() -> this.removeDataGenerator(generator);
    }

    private void removeDataGenerator(DataGenerator<T> generator) {
        generator.destroyAllData();
        this.dataGenerators.remove(generator);
    }
}

