/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.ProtocolUtil;

public class SimpleHttpProtocol
implements WebSocketProtocol,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpProtocol.class);
    protected static final String TEXT = "text/plain";
    protected String contentType = "text/plain";
    protected String methodType = "POST";
    protected String delimiter = "@@";
    protected boolean destroyable;
    protected boolean rewriteUri;

    @Override
    public void configure(AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = TEXT;
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
        String s = config.getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        this.rewriteUri = Boolean.valueOf(config.getInitParameter(ApplicationConfig.REWRITE_WEBSOCKET_REQUESTURI, "true"));
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String message) {
        int delimiterLength;
        int bodyBeginIndex;
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest(false);
        if (!resource.isInScope()) {
            return Collections.emptyList();
        }
        String pathInfo = request.getPathInfo();
        String requestURI = request.getRequestURI();
        if (this.rewriteUri && (requestURI.startsWith("http://") || requestURI.startsWith("https://"))) {
            logger.debug("Rewriting requestURI {}. To disable, add {} set to true as init-param", (Object)requestURI, (Object)ApplicationConfig.REWRITE_WEBSOCKET_REQUESTURI);
            requestURI = URI.create(requestURI).getPath();
            request.requestURI(requestURI);
        }
        if (message.startsWith(this.delimiter) && (bodyBeginIndex = message.indexOf(this.delimiter, delimiterLength = this.delimiter.length())) != -1) {
            pathInfo = message.substring(delimiterLength, bodyBeginIndex);
            requestURI = requestURI + pathInfo;
            message = message.substring(bodyBeginIndex + delimiterLength);
        }
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(ProtocolUtil.constructRequest(resource, pathInfo, requestURI, this.methodType, this.contentType.equalsIgnoreCase(TEXT) ? null : this.contentType, this.destroyable).body(message).build());
        return list;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] d, int offset, int length) {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest(false);
        if (!resource.isInScope()) {
            return Collections.emptyList();
        }
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(ProtocolUtil.constructRequest(resource, request.getPathInfo(), request.getRequestURI(), this.methodType, this.contentType.equalsIgnoreCase(TEXT) ? null : this.contentType, this.destroyable).body(d, offset, length).build());
        return list;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.warn(t.getMessage() + ". Unable to deliver the websocket messages to installed component." + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

