/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import org.atmosphere.config.service.DeliverTo;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.MeteorServlet;
import org.atmosphere.util.ReaderInputStream;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static final List<String> knownClasses;
    private static final Pattern SERVLET_PATH_PATTERN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deliver(Object o, DeliverTo deliverConfig, DeliverTo.DELIVER_TO defaultDeliver, AtmosphereResource r) {
        DeliverTo.DELIVER_TO deliverTo = deliverConfig == null ? defaultDeliver : deliverConfig.value();
        switch (deliverTo) {
            case RESOURCE: {
                if (o == null) return;
                try {
                    AtmosphereResource atmosphereResource = r;
                    synchronized (atmosphereResource) {
                        if (String.class.isAssignableFrom(o.getClass())) {
                            r.write(o.toString()).getResponse().flushBuffer();
                        } else {
                            if (!byte[].class.isAssignableFrom(o.getClass())) return;
                            r.write((byte[])o).getResponse().flushBuffer();
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    logger.warn("", (Throwable)ex);
                }
                return;
            }
            case BROADCASTER: {
                r.getBroadcaster().broadcast(o);
                return;
            }
            case ALL: {
                for (Broadcaster b : r.getAtmosphereConfig().getBroadcasterFactory().lookupAll()) {
                    b.broadcast(o);
                }
                return;
            }
        }
    }

    public static Object readEntirely(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        return IOUtils.isBodyBinary(request) ? IOUtils.readEntirelyAsByte(r) : (byte[])IOUtils.readEntirelyAsString(r).toString();
    }

    public static final boolean isBodyBinary(AtmosphereRequest request) {
        return request.getContentType() != null && request.getContentType().equalsIgnoreCase("application/octet-stream") || request.getHeader("X-Atmosphere-Binary") != null;
    }

    public static final boolean isBodyEmpty(Object o) {
        return o != null && String.class.isAssignableFrom(o.getClass()) && ((String)String.class.cast(o)).isEmpty() || Byte[].class.isAssignableFrom(o.getClass()) && ((Byte[])Byte[].class.cast(o)).length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readEntirelyAsString(AtmosphereResource r) {
        StringBuilder stringBuilder = new StringBuilder();
        AtmosphereRequest request = r.getRequest();
        if (request.body().isEmpty()) {
            BufferedReader bufferedReader = null;
            try {
                block23: {
                    try {
                        ServletInputStream inputStream = request.getInputStream();
                        if (inputStream != null) {
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("", (Throwable)ex);
                        BufferedReader reader = request.getReader();
                        if (reader == null) break block23;
                        bufferedReader = new BufferedReader(reader);
                    }
                }
                if (bufferedReader != null) {
                    char[] charBuffer = new char[8192];
                    int bytesRead = -1;
                    try {
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    }
                    catch (NullPointerException ex) {
                    }
                }
                stringBuilder.append("");
            }
            catch (IOException ex) {
                logger.warn("", (Throwable)ex);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            }
        } else {
            AtmosphereRequest.Body body = request.body();
            try {
                stringBuilder.append(body.hasString() ? body.asString() : new String(body.asBytes(), body.byteOffset(), body.byteLength(), request.getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readEntirelyAsByte(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        AtmosphereRequest.Body body = request.body();
        if (request.body().isEmpty()) {
            BufferedInputStream bufferedStream = null;
            ByteArrayOutputStream bbIS = new ByteArrayOutputStream();
            try {
                block24: {
                    try {
                        ServletInputStream inputStream = request.getInputStream();
                        if (inputStream != null) {
                            bufferedStream = new BufferedInputStream((InputStream)inputStream);
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("", (Throwable)ex);
                        BufferedReader reader = request.getReader();
                        if (reader == null) break block24;
                        bufferedStream = new BufferedInputStream(new ReaderInputStream(reader));
                    }
                }
                if (bufferedStream != null) {
                    byte[] bytes = new byte[8192];
                    int bytesRead = 0;
                    while (bytesRead != -1) {
                        bytesRead = bufferedStream.read(bytes);
                        if (bytesRead <= 0) continue;
                        bbIS.write(bytes, 0, bytesRead);
                    }
                } else {
                    bbIS.write("".getBytes());
                }
            }
            catch (IOException ex) {
                logger.warn("", (Throwable)ex);
            }
            finally {
                if (bufferedStream != null) {
                    try {
                        bufferedStream.close();
                    }
                    catch (IOException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            }
            return bbIS.toByteArray();
        }
        if (body.hasString()) {
            try {
                return IOUtils.readEntirelyAsString(r).toString().getBytes(request.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        } else if (body.hasBytes()) {
            return Arrays.copyOfRange(body.asBytes(), body.byteOffset(), body.byteLength());
        }
        throw new IllegalStateException("No body " + r);
    }

    public static String guestServletPath(AtmosphereConfig config) {
        String servletPath = "";
        try {
            servletPath = (String)config.getServletContext().getServletRegistration(config.getServletConfig().getServletName()).getMappings().iterator().next();
            servletPath = IOUtils.getCleanedServletPath(servletPath);
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
        return servletPath;
    }

    public static String getCleanedServletPath(String fullServletPath) {
        Matcher matcher = SERVLET_PATH_PATTERN.matcher(fullServletPath);
        if (!matcher.find()) {
            return fullServletPath;
        }
        String servletPath = matcher.group(0);
        if (!servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        return servletPath;
    }

    private static boolean scanForAtmosphereFramework(Class<?> classToScan) {
        if (classToScan == null) {
            return false;
        }
        logger.trace("Scanning {}", (Object)classToScan.getName());
        if (knownClasses.contains(classToScan.getName())) {
            return true;
        }
        try {
            Field[] fields;
            for (Field f : fields = classToScan.getDeclaredFields()) {
                f.setAccessible(true);
                if (!AtmosphereFramework.class.isAssignableFrom(f.getType())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
        return IOUtils.scanForAtmosphereFramework(classToScan.getSuperclass());
    }

    public static Class<?> loadClass(Class thisClass, String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return thisClass.getClassLoader().loadClass(className);
        }
    }

    public static boolean isAtmosphere(String className) {
        Class<?> clazz;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            try {
                clazz = IOUtils.class.getClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return AtmosphereServlet.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AtmosphereFramework.MetaServiceAction> readServiceFile(String path) {
        AtmosphereFramework.MetaServiceAction action;
        BufferedReader reader;
        InputStream is;
        LinkedHashMap<String, AtmosphereFramework.MetaServiceAction> b;
        block7: {
            b = new LinkedHashMap<String, AtmosphereFramework.MetaServiceAction>();
            is = null;
            reader = null;
            action = AtmosphereFramework.MetaServiceAction.INSTALL;
            is = AtmosphereFramework.class.getClassLoader().getResourceAsStream("META-INF/services/" + path);
            if (is != null) break block7;
            logger.warn("META-INF/services/{} not found in class loader", (Object)path);
            LinkedHashMap<String, AtmosphereFramework.MetaServiceAction> linkedHashMap = b;
            IOUtils.close(is, reader);
            return linkedHashMap;
        }
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                if (line.indexOf(46) == -1) {
                    action = AtmosphereFramework.MetaServiceAction.valueOf(line);
                    continue;
                }
                b.put(line, action);
            }
        }
        catch (IOException e) {
            try {
                logger.debug("Unable to read META-INF/services/{} from class loader", (Object)path, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(is, reader);
                throw throwable;
            }
            IOUtils.close(is, reader);
        }
        IOUtils.close(is, reader);
        return b;
    }

    public static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException ioe) {
                logger.info("Can't close the object", (Throwable)ioe);
            }
        }
    }

    public static String realPath(ServletContext servletContext, String targetPath) throws MalformedURLException {
        String realPath = servletContext.getRealPath(targetPath);
        if (realPath == null) {
            URL u = servletContext.getResource(targetPath);
            if (u != null) {
                realPath = u.getPath();
            } else {
                return "";
            }
        }
        return realPath;
    }

    static {
        SERVLET_PATH_PATTERN = Pattern.compile("([\\/]?[\\w-[.]]+|[\\/]\\*\\*)+");
        knownClasses = new ArrayList<String>(){
            {
                this.add(AtmosphereServlet.class.getName());
                this.add(MeteorServlet.class.getName());
                this.add("com.vaadin.server.VaadinServlet");
                this.add("org.primefaces.push.PushServlet");
            }
        };
    }
}

