package com.vaadin.copilot.plugins.info;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.CopilotJacksonUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHandler extends CopilotCommand {

    private final ApplicationConfiguration applicationConfiguration;

    public InfoHandler(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public void handleConnect(DevToolsInterface devToolsInterface) {
        ObjectNode obj = JacksonUtils.createObjectNode();
        obj.put("info", CopilotJacksonUtils.writeValueAsString(new CopilotInfo(applicationConfiguration)));
        devToolsInterface.send("copilot-info", obj);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

    @Override
    public boolean handleMessage(String command, JsonNode data, DevToolsInterface devToolsInterface) {
        return false;
    }
}
