/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.Resolvable;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserVariableDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import com.vaadin.copilot.IdentityHashSet;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.ConstructorAnalyzer;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.shared.util.SharedUtil;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.Normalizer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRewriterUtil {
    private static final Set<String> javaKeywords = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private static final int MAX_VARIABLE_NAME_LENGTH = 20;
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_MAP;
    private static final Pattern NORMALIZED_PATTERN;
    private static final Pattern SANITIZE_PATTERN;
    private static final Pattern SPACE_PATTERN;

    private JavaRewriterUtil() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaRewriterUtil.class);
    }

    static MethodCallExpr addAfterLastFunctionCall(List<MethodCallExpr> functionCalls, String function, Expression ... parameterExpressions) {
        ArrayList<MethodCallExpr> reversedFunctionCalls = new ArrayList<MethodCallExpr>(functionCalls);
        Collections.reverse(reversedFunctionCalls);
        Optional<MethodCallExpr> maybeLastCall = reversedFunctionCalls.stream().filter(call -> JavaRewriterUtil.hasAncestor((Node)call, Statement.class) && JavaRewriterUtil.hasAncestor((Node)call, BlockStmt.class)).findFirst();
        if (maybeLastCall.isEmpty()) {
            return null;
        }
        MethodCallExpr lastCall = maybeLastCall.get();
        Optional<Expression> maybeScope = JavaRewriterUtil.getOutermostScope(lastCall);
        Expression scope = maybeScope.orElse(null);
        Statement statement = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, Statement.class);
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, BlockStmt.class);
        MethodCallExpr newCall = JavaRewriterUtil.createMethodCall(scope, function, parameterExpressions);
        block.addStatement(block.getStatements().indexOf((Object)statement) + 1, (Statement)new ExpressionStmt((Expression)newCall));
        return newCall;
    }

    public static MethodCallExpr createMethodCall(Expression scope, String function, Expression ... parameterExpressions) {
        MethodCallExpr newCall = new MethodCallExpr(scope, function);
        for (Expression parameterExpression : parameterExpressions) {
            newCall.addArgument(parameterExpression);
        }
        return newCall;
    }

    static List<MethodCallExpr> findMethodCallsInClass(Expression expressionInsideClass, Node.TreeTraversal traversalOrder) {
        return JavaRewriterUtil.findUsageInClass(expressionInsideClass, body -> JavaRewriterUtil.findMethodCalls(body, traversalOrder));
    }

    static List<Expression> findUsageInClass(Expression expressionInsideClass, Function<BlockStmt, Stream<? extends Expression>> filter) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestor((Node)expressionInsideClass, ClassOrInterfaceDeclaration.class);
        if (classDeclaration == null) {
            return Collections.emptyList();
        }
        List blocks = classDeclaration.findAll(BlockStmt.class);
        return blocks.stream().flatMap(filter).toList();
    }

    static VariableDeclarator findLocalVariableDeclarator(String variableName, BlockStmt block) {
        return block.findFirst(VariableDeclarator.class, v -> v.getNameAsString().equals(variableName)).orElse(null);
    }

    static NodeList<Expression> toExpressionList(Object parameter) {
        if (parameter instanceof List) {
            List list = (List)parameter;
            return new NodeList(list.stream().map(JavaRewriterUtil::toExpression).toList());
        }
        return new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression(parameter)});
    }

    static Expression toExpression(Object parameter) {
        if (parameter == null) {
            return new NullLiteralExpr();
        }
        if (parameter instanceof Expression) {
            Expression e = (Expression)parameter;
            return e;
        }
        if (parameter instanceof String) {
            String s = (String)parameter;
            StringLiteralExpr expr = new StringLiteralExpr();
            expr.setString(s);
            return expr;
        }
        if (parameter instanceof Long) {
            Long l = (Long)parameter;
            return new LongLiteralExpr(String.valueOf(l));
        }
        if (parameter instanceof Double) {
            Double d = (Double)parameter;
            return new DoubleLiteralExpr(d.doubleValue());
        }
        if (parameter instanceof Boolean) {
            Boolean b = (Boolean)parameter;
            return new BooleanLiteralExpr(b.booleanValue());
        }
        if (parameter instanceof Integer) {
            Integer d = (Integer)parameter;
            return new IntegerLiteralExpr("" + d);
        }
        if (parameter instanceof Enum) {
            Enum e = (Enum)parameter;
            return new FieldAccessExpr((Expression)new NameExpr(e.getClass().getSimpleName()), e.name());
        }
        if (parameter instanceof JavaRewriter.Code) {
            JavaRewriter.Code code = (JavaRewriter.Code)parameter;
            return StaticJavaParser.parseExpression((String)code.code());
        }
        if (parameter instanceof LocalTime) {
            LocalTime lt = (LocalTime)parameter;
            return (Expression)new MethodCallExpr((Expression)new NameExpr(LocalTime.class.getSimpleName()), "parse").addArgument((Expression)new StringLiteralExpr(lt.toString()));
        }
        throw new IllegalArgumentException("Unknown type: " + parameter.getClass().getName());
    }

    static boolean equalsByNameAsString(Expression e1, Expression e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        if (e1.isNullLiteralExpr() && e2.isNullLiteralExpr()) {
            return true;
        }
        if (e1.isStringLiteralExpr() && e2.isStringLiteralExpr()) {
            return e1.asStringLiteralExpr().toString().equals(e2.asStringLiteralExpr().toString());
        }
        if (e1.isFieldAccessExpr() && e2.isFieldAccessExpr()) {
            return e1.toString().equals(e2.toString());
        }
        if (e1 instanceof NodeWithSimpleName && e2 instanceof NodeWithSimpleName) {
            return ((NodeWithSimpleName)e1).getNameAsString().equals(((NodeWithSimpleName)e2).getNameAsString());
        }
        return false;
    }

    public static Object fromExpression(Expression arg, ResolvedType expectedType) {
        if (arg instanceof StringLiteralExpr) {
            StringLiteralExpr literalExpression = (StringLiteralExpr)arg;
            return literalExpression.asString();
        }
        if (arg instanceof IntegerLiteralExpr) {
            IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)arg;
            return integerLiteralExpr.asNumber();
        }
        if (arg instanceof DoubleLiteralExpr) {
            DoubleLiteralExpr doubleLiteralExpr = (DoubleLiteralExpr)arg;
            if (expectedType != null && expectedType.isPrimitive() && expectedType.asPrimitive().getBoxTypeClass() == Float.class) {
                return Float.valueOf((float)doubleLiteralExpr.asDouble());
            }
            return doubleLiteralExpr.asDouble();
        }
        if (arg instanceof BooleanLiteralExpr) {
            BooleanLiteralExpr booleanLiteralExpr = (BooleanLiteralExpr)arg;
            return booleanLiteralExpr.getValue();
        }
        if (arg instanceof NullLiteralExpr) {
            return arg;
        }
        if (arg instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)arg;
            return methodCallExpr;
        }
        throw new IllegalArgumentException("Unknown expression type: " + arg.getClass().getName());
    }

    private static Stream<MethodCallExpr> findMethodCalls(BlockStmt scope, Node.TreeTraversal traversalOrder) {
        if (scope == null) {
            return Stream.empty();
        }
        return scope.findAll(MethodCallExpr.class, traversalOrder).stream();
    }

    public static Stream<Expression> findNameReferences(String variableName, BlockStmt scope) {
        if (scope == null) {
            return Stream.empty();
        }
        return scope.findAll(Expression.class, n -> (n.isNameExpr() || n.isFieldAccessExpr()) && JavaRewriterUtil.nameMatches(n, variableName)).stream();
    }

    public static List<MethodCallExpr> findMethodCallStatements(ComponentInfo componentDefinition) {
        List<MethodCallExpr> methodCalls = JavaRewriterUtil.findMethodCalls(componentDefinition);
        return methodCalls.stream().filter(m -> JavaRewriterUtil.isParentNode((Node)m, ExpressionStmt.class)).toList();
    }

    public static List<MethodCallExpr> findMethodCallNonStatements(ComponentInfo componentDefinition) {
        List<MethodCallExpr> methodCalls = JavaRewriterUtil.findMethodCalls(componentDefinition);
        return methodCalls.stream().filter(m -> !JavaRewriterUtil.isParentNode((Node)m, ExpressionStmt.class)).toList();
    }

    public static List<MethodCallExpr> findMethodCalls(ComponentInfo componentInfo) {
        return JavaRewriterUtil.findMethodCalls(componentInfo, Node.TreeTraversal.PREORDER);
    }

    public static List<MethodCallExpr> findMethodCalls(ComponentInfo componentInfo, Node.TreeTraversal traversalOrder) {
        if (componentInfo.fieldName() != null) {
            List<MethodCallExpr> classMethodCalls = JavaRewriterUtil.findMethodCallsInClass((Expression)componentInfo.objectCreationExpr(), traversalOrder);
            return JavaRewriterUtil.distinctByIdentity(classMethodCalls.stream().filter(m -> JavaRewriterUtil.scopeIs(m, componentInfo.fieldName())).toList());
        }
        if (componentInfo.routeConstructor() != null) {
            return JavaRewriterUtil.distinctByIdentity(JavaRewriterUtil.findMethodCalls(componentInfo.routeConstructor().getBody(), traversalOrder).filter(m -> JavaRewriterUtil.scopeIs(m, null)).toList());
        }
        if (componentInfo.localVariableName() != null) {
            ArrayList<MethodCallExpr> functionCalls = new ArrayList<MethodCallExpr>();
            functionCalls.addAll(JavaRewriterUtil.findMethodCalls(componentInfo.componentCreateScope(), traversalOrder).filter(m -> JavaRewriterUtil.scopeIs(m, componentInfo.localVariableName())).toList());
            Optional<BlockStmt> attachScope = componentInfo.componentAttachScope();
            if (attachScope.isPresent() && componentInfo.componentCreateScope() != attachScope.get()) {
                functionCalls.addAll(JavaRewriterUtil.findMethodCalls(attachScope.get(), traversalOrder).filter(m -> JavaRewriterUtil.scopeIs(m, componentInfo.localVariableName())).toList());
            }
            return functionCalls.stream().distinct().toList();
        }
        return Collections.emptyList();
    }

    private static <T> List<T> distinctByIdentity(List<T> list) {
        IdentityHashSet found = new IdentityHashSet();
        return list.stream().filter(found::add).toList();
    }

    public static List<Expression> findParameterUsage(ComponentInfo componentDefinition) {
        List<Object> refs = componentDefinition.fieldName() != null ? JavaRewriterUtil.findUsageInClass((Expression)componentDefinition.objectCreationExpr(), body -> JavaRewriterUtil.findNameReferences(componentDefinition.fieldName(), body)) : (componentDefinition.localVariableName() != null ? JavaRewriterUtil.findNameReferences(componentDefinition.localVariableName(), componentDefinition.componentCreateScope()).toList() : Collections.emptyList());
        return refs.stream().filter(JavaRewriterUtil::isMethodCallArgument).toList();
    }

    public static JavaRewriter.ExtractInlineVariableResult extractInlineVariableToLocalVariable(ComponentInfo componentInfo) {
        ClassOrInterfaceType type = componentInfo.objectCreationExpr().getType();
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow((Node)componentInfo.objectCreationExpr(), BlockStmt.class);
        String newLocalVariable = JavaRewriterUtil.findFreeVariableName(componentInfo, block);
        int index = JavaRewriterUtil.findBlockStatementIndex(componentInfo.attachCall().getNode());
        if (index >= -1) {
            Optional parentNode = componentInfo.objectCreationExpr().getParentNode();
            if (parentNode.isEmpty()) {
                throw new IllegalStateException("Parent for object creation does not exist");
            }
            ((Node)parentNode.get()).replace((Node)componentInfo.objectCreationExpr(), (Node)new NameExpr(newLocalVariable));
            VariableDeclarator declarator = new VariableDeclarator((com.github.javaparser.ast.type.Type)type, newLocalVariable, (Expression)componentInfo.objectCreationExpr());
            block.addStatement(index, (Expression)new VariableDeclarationExpr(declarator));
            return new JavaRewriter.ExtractInlineVariableResult(block, newLocalVariable, index);
        }
        return null;
    }

    public static boolean isRouteClass(ComponentTypeAndSourceLocation typeAndSourceLocation, CompilationUnit compilationUnit) {
        Optional<ComponentTracker.Location> attachLocation = typeAndSourceLocation.attachLocationInProject();
        Optional<ComponentTracker.Location> createLocation = typeAndSourceLocation.createLocationInProject();
        if (attachLocation.isPresent()) {
            return false;
        }
        if (createLocation.isEmpty()) {
            return false;
        }
        ComponentTracker.Location createLocationInProject = createLocation.get();
        boolean initCall = createLocationInProject.methodName().equals("<init>");
        if (!initCall) {
            return false;
        }
        Predicate[] predicateArray = new Predicate[3];
        predicateArray[0] = CompilationUnit.class::isInstance;
        predicateArray[1] = ClassOrInterfaceDeclaration.class::isInstance;
        predicateArray[2] = ConstructorDeclaration.class::isInstance;
        Node node = JavaRewriterUtil.findNode((Node)compilationUnit, createLocationInProject.lineNumber(), predicateArray);
        if (node == null) {
            return true;
        }
        if (node instanceof CompilationUnit) {
            return true;
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            return true;
        }
        return node instanceof ConstructorDeclaration;
    }

    private static boolean isMethodCallArgument(Expression ref) {
        Expression e;
        Optional parent = ref.getParentNode();
        if (parent.isEmpty()) {
            return false;
        }
        Object t = parent.get();
        return t instanceof Expression && (e = (Expression)t).isMethodCallExpr() && e.asMethodCallExpr().getArguments().contains((Node)ref);
    }

    static boolean isParentNode(Node node, Class<?> parentType) {
        return node.getParentNode().filter(value -> parentType == value.getClass()).isPresent();
    }

    static boolean hasAncestor(Node node, Class<?> parentType) {
        return JavaRewriterUtil.findAncestor(node, parentType) != null;
    }

    static boolean scopeIs(MethodCallExpr m, String variableName) {
        Optional maybeScope = m.getScope();
        if (maybeScope.isEmpty() || ((Expression)maybeScope.get()).isThisExpr()) {
            return variableName == null;
        }
        Expression scope = (Expression)maybeScope.get();
        if (scope instanceof MethodCallExpr) {
            return JavaRewriterUtil.scopeIs((MethodCallExpr)scope, variableName);
        }
        if (scope instanceof NameExpr) {
            if (JavaRewriterUtil.nameMatches(scope, variableName)) {
                return true;
            }
            try {
                ResolvedValueDeclaration resolved = scope.asNameExpr().resolve();
                VariableDeclarator variableDeclarator = null;
                if (resolved.isVariable() && resolved instanceof JavaParserVariableDeclaration) {
                    JavaParserVariableDeclaration javaParserVariableDeclaration = (JavaParserVariableDeclaration)resolved;
                    variableDeclarator = javaParserVariableDeclaration.getVariableDeclarator();
                } else if (resolved.isField() && resolved instanceof JavaParserFieldDeclaration) {
                    JavaParserFieldDeclaration javaParserFieldDeclaration = (JavaParserFieldDeclaration)resolved;
                    variableDeclarator = javaParserFieldDeclaration.getVariableDeclarator();
                } else {
                    JavaRewriterUtil.getLogger().debug("Unknown type {}", (Object)resolved);
                }
                Optional<MethodCallExpr> initializerCall = Optional.ofNullable(variableDeclarator).flatMap(VariableDeclarator::getInitializer).filter(Expression::isMethodCallExpr).map(Expression::asMethodCallExpr);
                if (initializerCall.isPresent()) {
                    return JavaRewriterUtil.scopeIs(initializerCall.get(), variableName);
                }
                JavaRewriterUtil.getLogger().debug("Unhandled resolved scope {}", (Object)resolved);
            }
            catch (UnsolvedSymbolException e) {
                JavaRewriterUtil.getLogger().debug("Unable to resolve symbol for " + String.valueOf(scope.asNameExpr()), (Throwable)e);
            }
            catch (IllegalStateException e) {
                JavaRewriterUtil.getLogger().debug("Illegal state for " + String.valueOf(scope.asNameExpr()), (Throwable)e);
            }
        } else {
            if (scope instanceof FieldAccessExpr) {
                return JavaRewriterUtil.nameMatches(scope, variableName);
            }
            JavaRewriterUtil.getLogger().debug("Unknown scope type {}", (Object)scope);
        }
        return false;
    }

    private static boolean nameMatches(Expression expression, String variableName) {
        if (expression.isNameExpr()) {
            return expression.asNameExpr().getNameAsString().equals(variableName);
        }
        if (expression.isFieldAccessExpr()) {
            return expression.asFieldAccessExpr().getNameAsString().equals(variableName);
        }
        JavaRewriterUtil.getLogger().debug("Unknown type of scope expression {}: {}", (Object)expression.getClass().getName(), (Object)expression);
        return false;
    }

    static BlockStmt findBlock(Node node) {
        return JavaRewriterUtil.findAncestor(node, BlockStmt.class);
    }

    static BlockStmt findBlockOrThrow(Node node) {
        return JavaRewriterUtil.findAncestorOrThrow(node, BlockStmt.class);
    }

    static ClassOrInterfaceDeclaration findNameExprOrThrow(Node node) {
        return JavaRewriterUtil.findAncestorOrThrow(node, ClassOrInterfaceDeclaration.class);
    }

    static <T> T findAncestor(Node node, Class<T> type) {
        return (T)JavaRewriterUtil.findAncestor(node, (Node n) -> type.isAssignableFrom(n.getClass()));
    }

    @Nonnull
    static <T> T findAncestorOrThrow(@Nonnull Node node, Class<T> type) throws IllegalArgumentException {
        T ancestor = JavaRewriterUtil.findAncestor(node, type);
        if (ancestor == null) {
            throw new IllegalArgumentException("Ancestor of type " + type.getName() + " not found for node of type " + node.getClass().getName());
        }
        return ancestor;
    }

    static Node findAncestor(Node node, Predicate<Node> filter) {
        if (filter.test(node)) {
            return node;
        }
        return node.getParentNode().map(value -> JavaRewriterUtil.findAncestor(value, filter)).orElse(null);
    }

    static <T extends Node> Optional<T> findNodeOfType(Node node, int lineNumber, Class<T> type) {
        return JavaRewriterUtil.findNodeOfType(node, lineNumber, type, n -> true);
    }

    static <T extends Node> Optional<T> findNodeOfType(Node node, int lineNumber, Class<T> type, Predicate<T> filter) {
        return Optional.ofNullable(JavaRewriterUtil.findNode(node, lineNumber, n -> type.isAssignableFrom(n.getClass()) && filter.test(n)));
    }

    static <T extends Node> List<T> findNodesOfType(Node node, int lineNumber, Class<T> type, Predicate<T> filter) {
        return JavaRewriterUtil.findNodes(node, lineNumber, n -> type.isAssignableFrom(n.getClass()) && filter.test(n));
    }

    static Node findNode(Node startFrom, int lineNumber, Predicate<Node> ... filters) {
        for (Node node : startFrom.getChildNodes()) {
            Node found;
            if (!JavaRewriterUtil.coversLine(node, lineNumber) || (found = JavaRewriterUtil.findNode(node, lineNumber, filters)) == null) continue;
            return found;
        }
        for (Predicate<Node> filter : filters) {
            if (!filter.test(startFrom)) continue;
            return startFrom;
        }
        return null;
    }

    static List<Node> findNodes(Node startFrom, int lineNumber, Predicate<Node> filter) {
        ArrayList<Node> allFound = new ArrayList<Node>();
        for (Node node : startFrom.getChildNodes()) {
            if (!JavaRewriterUtil.coversLine(node, lineNumber)) continue;
            List<Node> found = JavaRewriterUtil.findNodes(node, lineNumber, filter);
            allFound.addAll(found);
        }
        if (filter.test(startFrom)) {
            allFound.add(startFrom);
        }
        return allFound;
    }

    static boolean coversLine(Node node, int lineNumber) {
        return node.getRange().filter(value -> value.begin.line <= lineNumber && value.end.line >= lineNumber).isPresent();
    }

    public static boolean hasSingleParameterMethod(Class<? extends Component> type, String func) {
        return Arrays.stream(type.getMethods()).anyMatch(method -> method.getName().equals(func) && method.getParameterCount() == 1);
    }

    public static int findBlockStatementIndex(Node node) {
        BlockStmt block = JavaRewriterUtil.findAncestorOrThrow(node, BlockStmt.class);
        Optional maybeParentNode;
        while (!(maybeParentNode = node.getParentNode()).isEmpty()) {
            Node parentNode = (Node)maybeParentNode.get();
            if (parentNode == block) {
                for (int i = 0; i < block.getStatements().size(); ++i) {
                    if (block.getStatement(i) != node) continue;
                    return i;
                }
            }
            node = parentNode;
        }
        return -1;
    }

    public static int findDeclarationIndex(Node node) {
        ClassOrInterfaceDeclaration block = JavaRewriterUtil.findAncestorOrThrow(node, ClassOrInterfaceDeclaration.class);
        Optional maybeParentNode;
        while (!(maybeParentNode = node.getParentNode()).isEmpty()) {
            Node parentNode = (Node)maybeParentNode.get();
            if (parentNode == block) {
                for (int i = 0; i < block.getChildNodes().size(); ++i) {
                    if (block.getChildNodes().get(i) != node) continue;
                    return i;
                }
            }
            node = parentNode;
        }
        return -1;
    }

    public static String findFreeVariableName(ComponentInfo componentInfo, BlockStmt block) {
        String base = componentInfo.type().getSimpleName().toLowerCase(Locale.ENGLISH);
        return JavaRewriterUtil.findFreeVariableName(base, block);
    }

    public static String findFreeVariableName(String base, BlockStmt block) {
        return JavaRewriterUtil.findFreeVariableName(base, JavaRewriterUtil.findUsedVariableNames(block), JavaRewriterUtil.findUsedVariableNames(JavaRewriterUtil.findAncestorOrThrow((Node)block, ClassOrInterfaceDeclaration.class)));
    }

    public static String findFreeVariableName(String base, ClassOrInterfaceDeclaration block) {
        return JavaRewriterUtil.findFreeVariableName(base, JavaRewriterUtil.findUsedVariableNames(block));
    }

    public static String findFreeRecordName(String base, ClassOrInterfaceDeclaration block) {
        return JavaRewriterUtil.findFreeVariableName(base, JavaRewriterUtil.findUsedRecordNames(block));
    }

    private static String findFreeVariableName(String base, Set<String> ... setsUsedNames) {
        HashSet<String> allUsedNames = new HashSet<String>();
        for (Set<String> usedNames : setsUsedNames) {
            allUsedNames.addAll(usedNames);
        }
        String string = base = base.length() > 20 ? base.substring(0, 20) : base;
        if (base.isEmpty()) {
            base = "unknown";
        }
        Object name = base;
        int i = 2;
        while (allUsedNames.contains(name)) {
            name = base.matches("[0-9]$") ? base + "_" + i : base + i;
            ++i;
        }
        return name;
    }

    private static Set<String> findUsedVariableNames(BlockStmt block) {
        return block.findAll(VariableDeclarator.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
    }

    private static Set<String> findUsedVariableNames(ClassOrInterfaceDeclaration block) {
        return block.findAll(FieldDeclaration.class).stream().flatMap(fieldDeclaration -> fieldDeclaration.getVariables().stream()).map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
    }

    private static Set<String> findUsedRecordNames(ClassOrInterfaceDeclaration block) {
        return block.findAll(RecordDeclaration.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
    }

    public static void removeStatement(Node node) {
        JavaRewriterUtil.findAncestorOrThrow(node, Statement.class).remove();
    }

    public static boolean removeFromStringConcatenation(Node node) {
        Optional parent = node.getParentNode();
        if (parent.isEmpty()) {
            return false;
        }
        Object t = parent.get();
        if (t instanceof BinaryExpr) {
            Expression otherExpr;
            BinaryExpr binaryExpr = (BinaryExpr)t;
            Expression expression = otherExpr = binaryExpr.getLeft() == node ? binaryExpr.getRight() : binaryExpr.getLeft();
            if (otherExpr instanceof StringLiteralExpr) {
                binaryExpr.replace((Node)otherExpr);
                return true;
            }
        }
        return false;
    }

    public static Optional<Expression> findReference(NodeList<Expression> nodes, ComponentInfo componentDefinition) {
        return nodes.stream().filter(node -> {
            if (componentDefinition.localVariableName() != null) {
                return JavaRewriterUtil.isName(node, componentDefinition.localVariableName());
            }
            if (componentDefinition.fieldName() != null) {
                return JavaRewriterUtil.isName(node, componentDefinition.fieldName()) || JavaRewriterUtil.isFieldReference(node, componentDefinition.fieldName());
            }
            return node == componentDefinition.objectCreationExpr();
        }).findFirst();
    }

    private static boolean isFieldReference(Expression node, String s) {
        return node.isFieldAccessExpr() && node.asFieldAccessExpr().getNameAsString().equals(s);
    }

    private static boolean isName(Expression node, String s) {
        return node.isNameExpr() && node.asNameExpr().getNameAsString().equals(s);
    }

    public static FieldDeclaration findFieldDeclaration(Node nodeInClass, String fieldName) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestorOrThrow(nodeInClass, ClassOrInterfaceDeclaration.class);
        return (FieldDeclaration)classDeclaration.getFieldByName(fieldName).orElseThrow(() -> new IllegalArgumentException("No field found with name " + fieldName));
    }

    public static JavaRewriter.SetterAndValue getSetterAndValue(Class<?> componentType, String property, Object value) {
        String setterName = JavaRewriterUtil.getSetterName(property, componentType, true);
        if (FlowComponentQuirks.isInvertedBoolean(property, componentType)) {
            return new JavaRewriter.SetterAndValue(setterName, !Boolean.TRUE.equals(value));
        }
        Object propertyValue = JavaRewriterUtil.getPropertyValue(componentType, setterName, property, value);
        return new JavaRewriter.SetterAndValue(setterName, propertyValue);
    }

    public static String getSetterName(String property, Class<?> type, boolean includeReactConversions) {
        String setterName;
        if (includeReactConversions && (setterName = FlowComponentQuirks.convertReactPropertyToJavaSetter(property, type)) != null) {
            return setterName;
        }
        return "set" + SharedUtil.capitalize((String)SharedUtil.dashSeparatedToCamelCase((String)property));
    }

    public static String getPropertyName(String setter) {
        if (!setter.startsWith("set")) {
            throw new IllegalArgumentException("A setter name must start with 'set': " + setter);
        }
        return SharedUtil.firstToLower((String)setter.substring("set".length()));
    }

    public static String getFieldOrVariableName(ComponentInfo componentInfo) {
        if (componentInfo.localVariableName() != null) {
            return componentInfo.localVariableName();
        }
        if (componentInfo.fieldName() != null) {
            return componentInfo.fieldName();
        }
        if (componentInfo.routeConstructor() != null) {
            return "this";
        }
        return null;
    }

    public static void addImport(CompilationUnit compilationUnit, String qualifiedName) {
        JavaRewriterUtil.addImport(compilationUnit, qualifiedName, false, false);
    }

    public static void addImport(CompilationUnit compilationUnit, String qualifiedName, boolean isStatic, boolean isAsterisk) {
        if (compilationUnit.getImports().stream().anyMatch(i -> i.getNameAsString().equals(qualifiedName))) {
            return;
        }
        ImportDeclaration importDeclaration = new ImportDeclaration(qualifiedName, isStatic, isAsterisk);
        compilationUnit.addImport(importDeclaration);
    }

    public static String getJavaIdentifier(String str, int maxLength) {
        int i;
        if (str == null || str.isEmpty()) {
            return "empty";
        }
        String normalized = Normalizer.normalize(str, Normalizer.Form.NFD).replaceAll(NORMALIZED_PATTERN.pattern(), "");
        String sanitized = normalized.replaceAll(SANITIZE_PATTERN.pattern(), "").replaceAll(SPACE_PATTERN.pattern(), "-");
        Object camelCase = SharedUtil.dashSeparatedToCamelCase((String)sanitized.toLowerCase(Locale.ENGLISH));
        if (maxLength > 0 && ((String)camelCase).length() > maxLength) {
            camelCase = ((String)camelCase).substring(0, maxLength);
        }
        if (!((String)camelCase).isEmpty() && !Character.isLowerCase(((String)camelCase).charAt(0))) {
            camelCase = ((String)camelCase).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)camelCase).substring(1);
        }
        if (JavaRewriterUtil.isReservedJavaKeyword((String)camelCase)) {
            camelCase = (String)camelCase + "_";
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < ((String)camelCase).length(); ++i) {
            if (!Character.isJavaIdentifierStart(((String)camelCase).charAt(i)) && (sb.length() <= 0 || !Character.isJavaIdentifierPart(((String)camelCase).charAt(i)))) continue;
            sb.append(((String)camelCase).charAt(i));
        }
        if (sb.isEmpty()) {
            sb.append("a");
            for (i = 0; i < ((String)camelCase).length(); ++i) {
                if (!Character.isJavaIdentifierPart(((String)camelCase).charAt(i))) continue;
                sb.append(((String)camelCase).charAt(i));
            }
        }
        return sb.toString();
    }

    private static boolean isReservedJavaKeyword(String identifier) {
        return javaKeywords.contains(identifier);
    }

    public static boolean hasMethod(Class<?> type, String methodName) {
        return Arrays.stream(type.getMethods()).anyMatch(method -> method.getName().equals(methodName));
    }

    private static Object getPropertyValue(Class<?> componentType, String setterName, String prop, Object value) {
        if ((value = FlowComponentQuirks.componentSpecificValueMapping(componentType, prop, value)) == null) {
            return null;
        }
        if (setterName.startsWith("getElement().getThemeList()")) {
            return value;
        }
        if (setterName.equals("setStyle")) {
            return value;
        }
        if (setterName.equals("setAdditionalOptions")) {
            return value;
        }
        if (componentType.getName().equalsIgnoreCase("com.vaadin.flow.component.charts.model.ListSeries") && setterName.equals("setPlotOptions")) {
            return value;
        }
        if (JavaRewriterUtil.hasSetterForType(componentType, setterName, value.getClass())) {
            return value;
        }
        if (componentType.getName().equalsIgnoreCase("com.vaadin.flow.component.charts.Chart") && JavaRewriterUtil.hasSetterForType(JavaRewriterUtil.getClass("com.vaadin.flow.component.charts.model.Configuration"), setterName, value.getClass())) {
            return value;
        }
        if (JavaRewriterUtil.hasSetterForType(componentType, setterName, Component.class) && value instanceof JavaComponent) {
            return value;
        }
        Enum<?> enumValue = JavaRewriterUtil.getEnumValue(componentType, setterName, value.toString());
        if (enumValue != null) {
            return enumValue;
        }
        if (setterName.equals("addItem") && value instanceof ArrayList) {
            return value;
        }
        List<Method> setters = JavaRewriterUtil.findSetters(componentType, setterName);
        for (Method setter : setters) {
            Class<?> setterType = JavaRewriterUtil.getSetterType(setter);
            if (setterType == Instant.class) {
                Instant instant = JavaRewriterUtil.parseInstant((String)value);
                if (instant == null) {
                    throw new IllegalArgumentException("Unable to parse Instant from " + String.valueOf(value));
                }
                NameExpr scope = new NameExpr(Instant.class.getName());
                return new MethodCallExpr((Expression)scope, "ofEpochSecond").addArgument(JavaRewriterUtil.toExpression(instant.getEpochSecond()));
            }
            if (setterType == Integer.class && value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (Double.TYPE.equals(setterType) && value instanceof Integer) {
                return value;
            }
            if (setterType != LocalTime.class || !(value instanceof String)) continue;
            try {
                return LocalTime.parse((String)value);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Unable to find suitable setter for " + componentType.getName() + "." + setterName + " for value of type " + value.getClass().getName());
    }

    private static Instant parseInstant(String value) {
        if (value.equals("now") || value.equals("right now")) {
            return Instant.now();
        }
        if (value.equals("yesterday")) {
            return Instant.now().minusSeconds(86400L);
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").parse((CharSequence)value, LocalDateTime::from).toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return DateTimeFormatter.ofPattern("dd.MM.yyyy").parse((CharSequence)value, LocalDate::from).atTime(0, 0).toInstant(ZoneOffset.UTC);
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    return null;
                }
            }
        }
    }

    public static Class<?> getClass(String name) throws IllegalArgumentException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            JavaRewriterUtil.getLogger().debug("Class " + name + " not found", (Throwable)e);
            if (name.contains(".")) {
                int lastDot = name.lastIndexOf(46);
                return JavaRewriterUtil.getClass(name.substring(0, lastDot) + "$" + name.substring(lastDot + 1));
            }
            throw new IllegalArgumentException("Class " + name + " not found", e);
        }
    }

    public static boolean hasSetterForType(Class<?> componentType, String setterName, Class<?> valueType) {
        return JavaRewriterUtil.findSetters(componentType, setterName).stream().anyMatch(method -> {
            if (JavaRewriterUtil.getSetterType(method).isAssignableFrom(valueType)) {
                return true;
            }
            return WRAPPER_TYPE_MAP.containsKey(valueType) && JavaRewriterUtil.getSetterType(method).isAssignableFrom(WRAPPER_TYPE_MAP.get(valueType));
        });
    }

    public static Enum<?> getEnumValue(Class<?> componentType, String setterName, String value) {
        List<Method> setters = JavaRewriterUtil.findSetters(componentType, setterName);
        for (Method setter : setters) {
            Class<?> setterType = JavaRewriterUtil.getSetterType(setter);
            if (!setterType.isEnum()) continue;
            for (Object enumValue : setterType.getEnumConstants()) {
                if (!enumValue.toString().equals(value.toUpperCase(Locale.ENGLISH))) continue;
                return (Enum)enumValue;
            }
        }
        return null;
    }

    private static List<Method> findSetters(Class<?> componentType, String setterName) {
        return Arrays.stream(componentType.getMethods()).filter(method -> method.getName().equals(setterName)).filter(method -> method.getParameterCount() == 1).toList();
    }

    private static Class<?> getSetterType(Method setter) {
        return setter.getParameterTypes()[0];
    }

    public static void removeArgumentCalls(List<MethodCallExpr> methods, List<? extends Expression> argumentsToRemove, boolean removeMethodIfNoArgs) {
        for (MethodCallExpr methodCall : methods) {
            JavaRewriterUtil.removeArgumentCalls(methodCall, argumentsToRemove, removeMethodIfNoArgs);
        }
    }

    public static boolean removeArgumentCalls(MethodCallExpr methodCallExpr, List<? extends Expression> argumentsToRemove, boolean removeMethodIfNoArgs) {
        ArrayList<Expression> willRemoveArg = new ArrayList<Expression>();
        block0: for (Expression argument : methodCallExpr.getArguments()) {
            for (Expression expression : argumentsToRemove) {
                if (!JavaRewriterUtil.equalsByNameAsString(argument, expression)) continue;
                willRemoveArg.add(argument);
                continue block0;
            }
        }
        for (Expression argument : willRemoveArg) {
            boolean remove = argument.remove();
            if (remove) continue;
            throw new IllegalArgumentException("Argument remove has failed for " + methodCallExpr.getNameAsString() + ", " + String.valueOf(argument));
        }
        if (removeMethodIfNoArgs && methodCallExpr.getArguments().isEmpty()) {
            JavaRewriterUtil.removeStatement((Node)methodCallExpr);
        }
        return true;
    }

    public static InsertionPoint findLocationBefore(Expression expr) {
        InsertionPoint loc = JavaRewriterUtil.findLocationAfter(expr);
        if (loc.getBlock() != null) {
            return new InsertionPoint(loc.getBlock(), loc.getIndex() - 1);
        }
        return new InsertionPoint(loc.getDeclaration(), loc.getIndex() - 1);
    }

    public static InsertionPoint findLocationAfter(Expression expr) {
        try {
            BlockStmt insertBlock = JavaRewriterUtil.findBlockOrThrow((Node)expr);
            int insertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)expr) + 1;
            return new InsertionPoint(insertBlock, insertIndex);
        }
        catch (IllegalArgumentException e) {
            ClassOrInterfaceDeclaration insertBlock = JavaRewriterUtil.findNameExprOrThrow((Node)expr);
            int insertIndex = JavaRewriterUtil.findDeclarationIndex((Node)expr) + 1;
            return new InsertionPoint(insertBlock, insertIndex);
        }
    }

    public static InsertionPoint findLocationAtEnd(Statement statement) {
        BlockStmt insertBlock = JavaRewriterUtil.findBlockOrThrow((Node)statement);
        int insertIndex = insertBlock.getStatements().size();
        return new InsertionPoint(insertBlock, insertIndex);
    }

    public static void addFieldAfter(FieldDeclaration newField, FieldDeclaration reference) {
        ClassOrInterfaceDeclaration classDeclaration = JavaRewriterUtil.findAncestorOrThrow((Node)reference, ClassOrInterfaceDeclaration.class);
        NodeList members = classDeclaration.getMembers();
        int referenceIndex = members.indexOf((Object)reference);
        members.add(referenceIndex + 1, (Node)newField);
    }

    public static <T extends Node> T clone(T node) {
        Node newNode = node.clone();
        JavaRewriterUtil.clearData(newNode);
        return (T)newNode;
    }

    private static void clearData(Node node) {
        HashSet dataKeys = new HashSet(node.getDataKeys());
        dataKeys.forEach(arg_0 -> ((Node)node).removeData(arg_0));
        for (Node child : node.getChildNodes()) {
            JavaRewriterUtil.clearData(child);
        }
    }

    public static Optional<Expression> getAttachArgument(ComponentInfo component) {
        if (component.attachCall() == null) {
            return Optional.empty();
        }
        Optional<Expression> attachArg = JavaRewriterUtil.findReference((NodeList<Expression>)component.attachCall().getNodeWithArguments().getArguments(), component);
        if (attachArg.isEmpty() && component.attachCall().expression().isMethodCallExpr()) {
            MethodCallExpr methodCallExpr = component.attachCall().expression().asMethodCallExpr();
            for (Expression argument : methodCallExpr.getArguments()) {
                ObjectCreationExpr objectCreationExpr;
                if (!(argument instanceof ObjectCreationExpr) || !(attachArg = JavaRewriterUtil.findReference((NodeList<Expression>)(objectCreationExpr = (ObjectCreationExpr)argument).getArguments(), component)).isPresent()) continue;
                return attachArg;
            }
        }
        return attachArg;
    }

    public static Expression getAttachArgumentOrThrow(ComponentInfo component) {
        return JavaRewriterUtil.getAttachArgument(component).orElseThrow(() -> new IllegalArgumentException("No attach argument found for the component"));
    }

    public static boolean setNameExprScope(MethodCallExpr newCall, NameExpr nameExpr) {
        Optional scope = newCall.getScope();
        if (scope.isEmpty()) {
            return false;
        }
        if (((Expression)scope.get()).isMethodCallExpr()) {
            return JavaRewriterUtil.setNameExprScope(((Expression)scope.get()).asMethodCallExpr(), nameExpr);
        }
        newCall.setScope((Expression)nameExpr);
        return true;
    }

    public static boolean typesEqual(ResolvedType javaParserType, Class<?> javaReflectionType) {
        ResolvedTypeVariable typeVariable;
        ResolvedTypeParameterDeclaration typeParameter;
        if (javaParserType.isReferenceType()) {
            ResolvedReferenceType refType = javaParserType.asReferenceType();
            return refType.getQualifiedName().equals(javaReflectionType.getName().replace("$", "."));
        }
        if (javaParserType.isArray() && javaReflectionType.isArray()) {
            ResolvedArrayType arrayType = javaParserType.asArrayType();
            ResolvedType resolvedArrayComponentType = arrayType.getComponentType();
            TypeDescriptor.OfField javaArrayComponentType = javaReflectionType.componentType();
            return JavaRewriterUtil.typesEqual(resolvedArrayComponentType, javaArrayComponentType);
        }
        if (javaParserType.isTypeVariable() && (typeParameter = (typeVariable = javaParserType.asTypeVariable()).asTypeParameter()) instanceof ReflectionTypeParameter && javaReflectionType.getName().equals("java.lang.Object")) {
            return true;
        }
        JavaRewriterUtil.getLogger().debug("Do not know how to compare type {} with {}", (Object)javaParserType, javaReflectionType);
        return false;
    }

    public static boolean isArrayArgument(String className, String methodName, int argumentIndex) {
        try {
            Class parameterType;
            ParameterizedType parameterizedType;
            Type type;
            Class<?> clazz = JavaRewriterUtil.getClass(className);
            HashSet<Method> methods = new HashSet<Method>(Arrays.stream(clazz.getMethods()).toList());
            Type genericSuperclass = clazz.getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class && (parameterType = (Class)type).getName().equals("com.vaadin.flow.component.Composite")) {
                Class compositeClazz = (Class)parameterizedType.getActualTypeArguments()[0];
                methods.addAll(Arrays.stream(compositeClazz.getMethods()).toList());
            }
            return methods.stream().filter(f -> f.getName().equals(methodName)).anyMatch(method -> {
                Parameter[] parameters = method.getParameters();
                Parameter seekingParam = argumentIndex < parameters.length ? parameters[argumentIndex] : parameters[parameters.length - 1];
                return seekingParam.getType().isArray();
            });
        }
        catch (Exception ex) {
            JavaRewriterUtil.getLogger().debug("Could not find argument index of {}", (Object)(className + "/" + methodName), (Object)ex);
            return false;
        }
    }

    public static boolean appendExpressionAsNextSiblingInBlockAncestor(Node original, Statement newExpression) {
        BlockStmt ancestor = JavaRewriterUtil.findAncestor(original, BlockStmt.class);
        if (ancestor == null) {
            return false;
        }
        if (original.getRange().isEmpty()) {
            return false;
        }
        Range originalRange = (Range)original.getRange().get();
        for (int i = 0; i < ancestor.getStatements().size(); ++i) {
            Range stmtRange;
            Statement statement = ancestor.getStatement(i);
            if (!statement.getRange().isPresent() || !originalRange.overlapsWith(stmtRange = (Range)statement.getRange().get())) continue;
            ancestor.addStatement(i + 1, newExpression);
            return true;
        }
        return false;
    }

    public static Optional<Expression> getScopeIgnoreComposite(ComponentInfo componentInfo, MethodCallExpr expr) {
        if (componentInfo.containerComposite()) {
            Expression expression;
            Optional scopeOpt = expr.getScope();
            if (scopeOpt.isPresent() && (expression = (Expression)scopeOpt.get()).isMethodCallExpr() && ((MethodCallExpr)expression).getNameAsString().equals("getContent")) {
                return JavaRewriterUtil.getScopeIgnoreComposite(componentInfo, expression.asMethodCallExpr());
            }
            return Optional.empty();
        }
        return expr.getScope();
    }

    public static boolean isNodeInCompositeClass(Node node) {
        ClassOrInterfaceDeclaration classDefinition = JavaRewriterUtil.findAncestorOrThrow(node, ClassOrInterfaceDeclaration.class);
        return classDefinition.getExtendedTypes().stream().anyMatch(type -> type.getNameAsString().equals("Composite"));
    }

    public static Optional<Constructor<?>> findConstructor(Class<? extends Component> componentType, ObjectCreationExpr objectCreationExpr) {
        try {
            ResolvedConstructorDeclaration resolved = objectCreationExpr.resolve();
            List<Constructor> candidates = Arrays.stream(componentType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == resolved.getNumberOfParams()).filter(c -> {
                for (int i = 0; i < resolved.getNumberOfParams(); ++i) {
                    ResolvedType paramType = resolved.getParam(i).getType();
                    if (JavaRewriterUtil.typesEqual(paramType, c.getParameterTypes()[i])) continue;
                    return false;
                }
                return true;
            }).toList();
            if (candidates.isEmpty()) {
                return Optional.empty();
            }
            if (candidates.size() > 1) {
                throw new IllegalStateException("Multiple constructors found for " + componentType.getName() + ": " + String.valueOf(candidates));
            }
            return Optional.of(candidates.get(0));
        }
        catch (UnsolvedSymbolException e) {
            throw new IllegalStateException("Unable to resolve constructor for " + componentType.getName() + ": " + String.valueOf(objectCreationExpr), e);
        }
    }

    public static ObjectCreationExpr createComponentConstructor(JavaComponent javaComponent, ClassOrInterfaceType componentType, String dataEntityRecordName, Consumer<String> importAdder) {
        ObjectCreationExpr constructor = null;
        if (componentType.getName().asString().equals("Grid") || componentType.getName().asString().equals("TreeGrid")) {
            Optional typeArgument = componentType.getTypeArguments().flatMap(typeArguments -> typeArguments.stream().findFirst());
            ClassExpr classExpr = new ClassExpr((com.github.javaparser.ast.type.Type)typeArgument.orElse(StaticJavaParser.parseClassOrInterfaceType((String)dataEntityRecordName)));
            constructor = new ObjectCreationExpr(null, componentType, new NodeList((Node[])new Expression[]{classExpr}));
        } else if (componentType.getName().asString().equals("SideNavItem") && !javaComponent.props().containsKey("text")) {
            constructor = new ObjectCreationExpr(null, componentType, new NodeList((Node[])new Expression[]{new StringLiteralExpr("")}));
        } else if (componentType.getName().asString().equals("Chart") && javaComponent.props().containsKey("type")) {
            constructor = new ObjectCreationExpr(null, componentType, new NodeList((Node[])new Expression[]{new NameExpr("ChartType." + JavaRewriterUtil.codeToUpperCase(javaComponent.props().get("type").toString()))}));
            importAdder.accept("com.vaadin.flow.component.charts.model.ChartType");
            javaComponent.props().remove("type");
        } else {
            constructor = new ObjectCreationExpr(null, componentType, new NodeList());
        }
        return constructor;
    }

    private static String codeToUpperCase(String code) {
        return code.toUpperCase(Locale.ENGLISH);
    }

    public static Optional<String> getSingleStringParamConstructor(ClassOrInterfaceType type, Set<String> setters) {
        Class<?> componentType = JavaRewriterUtil.getClass(type.getNameWithScope());
        Optional<Constructor> constructor = Arrays.stream(componentType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0] == String.class).findFirst();
        if (constructor.isEmpty()) {
            return Optional.empty();
        }
        String mappedProperty = JavaRewriterUtil.getMappedProperty(constructor.get(), 0);
        if (mappedProperty != null && setters.contains(mappedProperty)) {
            return Optional.of(mappedProperty);
        }
        return Optional.empty();
    }

    public static String getMappedProperty(Constructor<?> c, int propertyIndex) {
        return ConstructorAnalyzer.get().getMappings(c).entrySet().stream().filter(entry -> (Integer)entry.getKey() == propertyIndex).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static String generateVariableName(JavaComponent javaComponent, ClassOrInterfaceType type, InsertionPoint insertionPoint) {
        if (javaComponent.metadata() != null) {
            if (javaComponent.metadata().getFieldVariableName() != null) {
                return javaComponent.metadata().getFieldVariableName();
            }
            if (javaComponent.metadata().getLocalVariableName() != null) {
                return javaComponent.metadata().getLocalVariableName();
            }
        }
        String variableBaseName = JavaRewriterUtil.generateVariableBaseName(type.getNameAsString(), (String)javaComponent.props().get("text"), (String)javaComponent.props().get("label"));
        return insertionPoint.getFreeVariableName(variableBaseName);
    }

    private static String generateVariableBaseName(String classSimpleName, String textProperty, String labelProperty) {
        if (textProperty != null) {
            return JavaRewriterUtil.getJavaIdentifier(textProperty, 0);
        }
        if (labelProperty != null) {
            return JavaRewriterUtil.getJavaIdentifier(labelProperty, 0);
        }
        return classSimpleName.toLowerCase(Locale.ENGLISH);
    }

    public static String regenerateVariableName(ComponentInfo componentInfo, String newText, String newLabel) {
        String variableBaseName = JavaRewriterUtil.generateVariableBaseName(componentInfo.type().getSimpleName(), newText, newLabel);
        String newVariableName = null;
        if (componentInfo.localVariableName() != null) {
            newVariableName = JavaRewriterUtil.findFreeVariableName(variableBaseName, JavaRewriterUtil.findBlock((Node)componentInfo.localVariableDeclarator()));
        } else if (componentInfo.fieldName() != null) {
            newVariableName = JavaRewriterUtil.findFreeVariableName(variableBaseName, JavaRewriterUtil.findAncestorOrThrow((Node)componentInfo.fieldDeclaration(), ClassOrInterfaceDeclaration.class));
        }
        if (newVariableName != null) {
            JavaRewriterUtil.renameVariable(componentInfo, newVariableName);
        }
        return newVariableName;
    }

    private static void renameVariable(ComponentInfo componentInfo, String newVariableName) {
        VariableDeclarator variableDeclarator = componentInfo.getVariableDeclarator();
        JavaRewriterUtil.findMethodCalls(componentInfo).forEach(methodCall -> {
            Optional maybeScope = methodCall.getScope();
            if (maybeScope.isEmpty()) {
                return;
            }
            Expression scope = (Expression)maybeScope.get();
            if (scope instanceof Resolvable) {
                Resolvable resolvable = (Resolvable)scope;
                if (scope instanceof NodeWithSimpleName) {
                    NodeWithSimpleName nodeWithSimpleName = (NodeWithSimpleName)scope;
                    Object resolved = resolvable.resolve();
                    if (resolved instanceof JavaParserVariableDeclaration) {
                        JavaParserVariableDeclaration javaParserVariableDeclaration = (JavaParserVariableDeclaration)resolved;
                        if (javaParserVariableDeclaration.getVariableDeclarator() != variableDeclarator) return;
                        nodeWithSimpleName.setName(newVariableName);
                        return;
                    }
                    if (resolved instanceof JavaParserFieldDeclaration) {
                        JavaParserFieldDeclaration javaParserFieldDeclaration = (JavaParserFieldDeclaration)resolved;
                        if (javaParserFieldDeclaration.getVariableDeclarator() != variableDeclarator) return;
                        nodeWithSimpleName.setName(newVariableName);
                        return;
                    }
                    JavaRewriterUtil.getLogger().debug("Unhandled resolved type for {}: {}", (Object)nodeWithSimpleName.getClass(), resolved.getClass());
                    return;
                }
            }
            JavaRewriterUtil.getLogger().debug("Unhandled scope: {}", scope.getClass());
        });
        JavaRewriterUtil.findParameterUsage(componentInfo).forEach(parameter -> {
            if (parameter instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)parameter;
                nameExpr.setName(newVariableName);
            } else {
                JavaRewriterUtil.getLogger().debug("Unhandled parameter type: {}", parameter.getClass());
            }
        });
        if (variableDeclarator != null) {
            variableDeclarator.setName(newVariableName);
        }
        if (componentInfo.assignmentExpression() != null) {
            Expression target = componentInfo.assignmentExpression().getTarget();
            if (target instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)target;
                nameExpr.setName(newVariableName);
            } else {
                JavaRewriterUtil.getLogger().debug("Unhandled assignment expression target type: {}", target.getClass());
            }
        }
    }

    public static boolean functionAffectsVariableName(String functionName) {
        return functionName.equals("setText") || functionName.equals("setLabel");
    }

    public static boolean isVariableNameAutoGenerated(ComponentInfo componentInfo, String currentText, String currentLabel) {
        String variableBaseName = JavaRewriterUtil.generateVariableBaseName(componentInfo.type().getSimpleName().toLowerCase(Locale.ENGLISH), currentText, currentLabel);
        String currentName = JavaRewriterUtil.getFieldOrVariableName(componentInfo);
        if (currentName == null) {
            return false;
        }
        if (!currentName.startsWith(variableBaseName)) {
            return false;
        }
        String suffix = currentName.substring(variableBaseName.length());
        return suffix.isEmpty() || JavaRewriterUtil.isNumber(suffix);
    }

    private static boolean isNumber(String suffix) {
        try {
            return String.valueOf(Integer.parseInt(suffix, 10)).equals(suffix);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<MethodCallExpr> findCalls(Class<?> classWithMethods, ComponentInfo componentInfo) {
        List<MethodCallExpr> methodCallsInComponentScope = JavaRewriterUtil.findMethodCalls(componentInfo, Node.TreeTraversal.POSTORDER);
        return methodCallsInComponentScope.stream().filter(methodCallExpr -> {
            ResolvedMethodDeclaration r = methodCallExpr.resolve();
            if (!r.declaringType().getQualifiedName().equals(classWithMethods.getName())) {
                return false;
            }
            return JavaRewriterUtil.scopeIs(methodCallExpr, componentInfo.localVariableName() != null ? componentInfo.localVariableName() : componentInfo.fieldName());
        }).toList();
    }

    @Nonnull
    public static MethodCallExpr addFunctionCall(ComponentInfo componentInfo, String function, List<Expression> parameterExpressions) {
        JavaRewriter.ExtractInlineVariableResult extractInlineVariableResult;
        MethodCallExpr added;
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        if (!functionCalls.isEmpty() && (added = JavaRewriterUtil.addAfterLastFunctionCall(functionCalls, function, parameterExpressions.toArray(new Expression[0]))) != null) {
            return added;
        }
        int addAfterStatementIndex = -2;
        BlockStmt scope = componentInfo.componentCreateScope();
        if (componentInfo.localVariableDeclarator() != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.localVariableDeclarator());
        } else if (componentInfo.fieldDeclaration() != null && componentInfo.fieldDeclarationAndAssignment() == null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.assignmentExpression());
        } else if (componentInfo.fieldDeclarationAndAssignment() != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex(componentInfo.attachCall().getNode()) - 1;
            scope = componentInfo.componentAttachScope().orElseThrow(() -> new IllegalArgumentException("Component " + String.valueOf(componentInfo) + " has no attach information"));
        }
        if (addAfterStatementIndex >= -1) {
            NameExpr variable = new NameExpr(JavaRewriterUtil.getFieldOrVariableName(componentInfo));
            MethodCallExpr newCall = new MethodCallExpr((Expression)variable, function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            scope.addStatement(addAfterStatementIndex + 1, (Statement)new ExpressionStmt((Expression)newCall));
            return newCall;
        }
        if (componentInfo.routeConstructor() != null) {
            MethodCallExpr methodCallScope = JavaRewriterUtil.isNodeInCompositeClass((Node)componentInfo.routeConstructor()) ? new MethodCallExpr("getContent", new Expression[0]) : null;
            MethodCallExpr newCall = new MethodCallExpr((Expression)methodCallScope, function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            BlockStmt body = componentInfo.routeConstructor().getBody();
            body.addStatement((Expression)newCall);
            return newCall;
        }
        if (componentInfo.isAnonymousComponent() && !componentInfo.isReturnValue() && (extractInlineVariableResult = JavaRewriterUtil.extractInlineVariableToLocalVariable(componentInfo)) != null) {
            MethodCallExpr newCall = new MethodCallExpr((Expression)new NameExpr(extractInlineVariableResult.newVariableName()), function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            extractInlineVariableResult.blockStmt().addStatement(extractInlineVariableResult.index() + 1, (Expression)newCall);
            return newCall;
        }
        throw new IllegalStateException("Unable to determine where to add function call");
    }

    public static Optional<Expression> getOutermostScope(MethodCallExpr methodCallExpr) {
        Optional scope = methodCallExpr.getScope();
        while (scope.isPresent() && ((Expression)scope.get()).isMethodCallExpr()) {
            methodCallExpr = ((Expression)scope.get()).asMethodCallExpr();
            scope = methodCallExpr.getScope();
        }
        return scope;
    }

    public static void removeFromChainedStyleCall(MethodCallExpr methodCallExpr) {
        Optional scope = methodCallExpr.getScope();
        Optional<String> methodScopeName = scope.filter(Expression::isMethodCallExpr).map(Expression::asMethodCallExpr).map(NodeWithSimpleName::getNameAsString);
        Optional parentNode = methodCallExpr.getParentNode();
        Optional<ExpressionStmt> parentExpressionStmt = parentNode.filter(ExpressionStmt.class::isInstance).map(ExpressionStmt.class::cast);
        boolean callsBefore = methodScopeName.isPresent() && !methodScopeName.get().equals("getStyle");
        boolean callsAfter = parentExpressionStmt.isEmpty();
        if (!callsBefore && !callsAfter) {
            parentExpressionStmt.get().remove();
            return;
        }
        if (callsBefore) {
            if (scope.isEmpty()) {
                throw new IllegalArgumentException("Scope cannot be empty when there are calls before this in the chain");
            }
            if (callsAfter) {
                if (parentNode.isEmpty()) {
                    throw new IllegalArgumentException("Parent node is empty even when there is a call after this in the chain");
                }
                MethodCallExpr callAfterThis = (MethodCallExpr)parentNode.get();
                MethodCallExpr callBeforeThis = (MethodCallExpr)scope.get();
                callAfterThis.setScope((Expression)callBeforeThis);
            } else {
                parentExpressionStmt.get().setExpression((Expression)scope.get());
            }
            return;
        }
        throw new IllegalArgumentException("Not sure how to remove style call " + String.valueOf(methodCallExpr) + " in context of " + String.valueOf(JavaRewriterUtil.findAncestor((Node)methodCallExpr, ExpressionStmt.class)));
    }

    private static String toCamelCase(String input) {
        StringBuilder result = new StringBuilder();
        boolean convertNext = false;
        for (char c : input.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                if (convertNext) {
                    result.append(Character.toUpperCase(c));
                    convertNext = false;
                    continue;
                }
                result.append(c);
                continue;
            }
            convertNext = true;
        }
        return result.toString();
    }

    public static void moveAboveMethodsAndConstructors(BodyDeclaration<?> toMove, ClassOrInterfaceDeclaration classOrInterface) {
        int fieldIndex = classOrInterface.getMembers().indexOf(toMove);
        int newIndex = -1;
        for (int i = 0; i < fieldIndex; ++i) {
            BodyDeclaration member = classOrInterface.getMember(i);
            if (!member.isConstructorDeclaration() && !member.isMethodDeclaration()) continue;
            newIndex = i;
            break;
        }
        if (newIndex != -1) {
            classOrInterface.getMembers().add(newIndex, toMove);
        }
    }

    public static com.github.javaparser.ast.type.Type createEmptyType() {
        ClassOrInterfaceType toDeleteType = new ClassOrInterfaceType();
        toDeleteType.setName("DELETE_THIS");
        return toDeleteType;
    }

    static {
        NORMALIZED_PATTERN = Pattern.compile("\\p{M}");
        SANITIZE_PATTERN = Pattern.compile("[^a-zA-Z0-9 -]");
        SPACE_PATTERN = Pattern.compile("\\s+");
        WRAPPER_TYPE_MAP = new HashMap(16);
        WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        WRAPPER_TYPE_MAP.put(Void.class, Void.TYPE);
    }
}

