/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.observer.AstObserver;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.vaadin.copilot.javarewriter.AttachExpression;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.ConstructorAnalyzer;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaDataProviderHandler;
import com.vaadin.copilot.javarewriter.JavaRewriterMerger;
import com.vaadin.copilot.javarewriter.JavaRewriterObserver;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.JavaStyleRewriter;
import com.vaadin.copilot.javarewriter.LumoRewriterUtil;
import com.vaadin.copilot.javarewriter.custom.CustomComponentHandle;
import com.vaadin.copilot.javarewriter.custom.CustomComponentHandler;
import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JavaRewriter {
    private static final String UNKNOWN_WHERE = "Unknown where: ";
    private static final String CHART_SERIES_CLASS = "ChartSeries";
    private static final String ADD_CLASS_NAMES_METHOD = "addClassNames";
    private static final String SET_SPACING_METHOD = "setSpacing";
    private static final String ADD_ITEM_METHOD = "addItem";
    private final String source;
    private final JavaRewriterObserver observer = new JavaRewriterObserver();
    private final ParserConfiguration parserConfiguration = new ParserConfiguration();
    protected CompilationUnit compilationUnit;

    public JavaRewriter(String source) {
        this(source, false);
    }

    public JavaRewriter(String source, boolean solveJdkClassesBySimpleName) {
        this.source = source;
        this.parseSource(source, solveJdkClassesBySimpleName);
    }

    private void parseSource(String source, boolean solveJdkClassesBySimpleName) {
        this.parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver(false));
        if (solveJdkClassesBySimpleName) {
            combinedTypeSolver.add((TypeSolver)new ClassLoaderTypeSolver(ClassLoaderTypeSolver.class.getClassLoader()){

                public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
                    if (name.contains(".")) {
                        return SymbolReference.unsolved();
                    }
                    for (String pkg : Arrays.asList(LocalDateTime.class.getPackageName(), Map.class.getPackageName())) {
                        SymbolReference ref = super.tryToSolveType(pkg + "." + name);
                        if (!ref.isSolved()) continue;
                        return ref;
                    }
                    return SymbolReference.unsolved();
                }
            });
        }
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        this.parserConfiguration.setSymbolResolver((SymbolResolver)symbolSolver);
        StaticJavaParser.setConfiguration((ParserConfiguration)this.parserConfiguration);
        this.compilationUnit = StaticJavaParser.parse((String)source);
        this.compilationUnit.registerForSubtree((AstObserver)this.observer);
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public String getResult() {
        return JavaRewriterMerger.apply(this.observer.getAddedOrModifiedNodes(), this.observer.getRemovedRanges(), this.source);
    }

    public int getFirstModifiedRow() {
        int row = 1;
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != this.getResult().charAt(i)) {
                return row;
            }
            if (this.source.charAt(i) != '\n') continue;
            ++row;
        }
        return -1;
    }

    public ReplaceResult replaceFunctionCall(ComponentInfo componentInfo, String function, Object value) {
        boolean replaced;
        String currentText = null;
        String currentLabel = null;
        boolean affectsVariableName = JavaRewriterUtil.functionAffectsVariableName(function);
        boolean variableNameAutoGenerated = false;
        if (affectsVariableName) {
            String label;
            String text;
            Object currentTextProperty = this.getPropertyValue(componentInfo, "text");
            Object currentLabelProperty = this.getPropertyValue(componentInfo, "label");
            currentText = currentTextProperty instanceof String ? (text = (String)currentTextProperty) : null;
            currentLabel = currentLabelProperty instanceof String ? (label = (String)currentLabelProperty) : null;
            variableNameAutoGenerated = JavaRewriterUtil.isVariableNameAutoGenerated(componentInfo, currentText, currentLabel);
        }
        if (!(replaced = this.replaceConstructorParam(componentInfo, function, value))) {
            this.replaceOrAddCall(componentInfo, function, value);
        }
        if (variableNameAutoGenerated) {
            String string;
            String newLabel;
            String string2;
            String newText = function.equals("setText") && value instanceof String ? (string2 = (String)value) : null;
            String string3 = newLabel = function.equals("setLabel") && value instanceof String ? (string = (String)value) : null;
            if (newText != null || newLabel != null) {
                return new ReplaceResult(JavaRewriterUtil.regenerateVariableName(componentInfo, newText, newLabel));
            }
        }
        return new ReplaceResult(null);
    }

    public void addImport(String qualifiedName, boolean isStatic, boolean isAsterisk) {
        JavaRewriterUtil.addImport(this.compilationUnit, qualifiedName, isStatic, isAsterisk);
    }

    private boolean replaceConstructorParam(ComponentInfo componentInfo, String function, Object value) {
        Optional<Map.Entry> mapping;
        ObjectCreationExpr objectCreationExpr = componentInfo.objectCreationExpr();
        Optional<Constructor<?>> constructor = JavaRewriterUtil.findConstructor(componentInfo.type(), objectCreationExpr);
        Optional<Map> mappings = constructor.map(c -> ConstructorAnalyzer.get().getMappings((Constructor<?>)c));
        if (mappings.isPresent() && (mapping = mappings.get().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(function)).findFirst()).isPresent()) {
            objectCreationExpr.setArgument(((Integer)mapping.get().getKey()).intValue(), JavaRewriterUtil.toExpression(value));
            return true;
        }
        return false;
    }

    public void addCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        this.doReplaceOrAddCall(componentInfo, function, false, parameters);
    }

    public void replaceOrAddCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        this.doReplaceOrAddCall(componentInfo, function, true, parameters);
    }

    private void doReplaceOrAddCall(ComponentInfo componentInfo, String function, boolean replace, Object ... parameters) {
        ArrayList<Expression> parameterExpressions = new ArrayList<Expression>();
        for (Object parameter : parameters) {
            parameterExpressions.add(JavaRewriterUtil.toExpression(parameter));
        }
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        MethodCallExpr functionCall = functionCalls.stream().filter(m -> m.getNameAsString().equals(function)).findFirst().orElse(null);
        if (replace && functionCall != null) {
            if (parameterExpressions.size() == 1) {
                functionCall.setArgument(0, (Expression)parameterExpressions.get(0));
            }
            return;
        }
        JavaRewriterUtil.addFunctionCall(componentInfo, function, parameterExpressions);
    }

    public Object getPropertyValue(ComponentInfo componentInfo, String property) {
        Optional<Constructor<?>> maybeConstructor;
        String setterName = JavaRewriterUtil.getSetterName(property, componentInfo.type(), false);
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> candidates = functionCalls.stream().filter(m -> m.getNameAsString().equals(setterName)).toList();
        if (!candidates.isEmpty()) {
            MethodCallExpr setterCall = candidates.get(candidates.size() - 1);
            Expression arg = (Expression)setterCall.getArguments().get(0);
            return JavaRewriterUtil.fromExpression(arg, setterCall.resolve().getParam(0).getType());
        }
        ObjectCreationExpr createExpression = componentInfo.objectCreationExpr();
        if (createExpression != null && (maybeConstructor = JavaRewriterUtil.findConstructor(componentInfo.type(), createExpression)).isPresent()) {
            Constructor<?> constructor = maybeConstructor.get();
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                String mappedProperty = JavaRewriterUtil.getMappedProperty(constructor, i);
                if (!setterName.equals(mappedProperty)) continue;
                return JavaRewriterUtil.fromExpression(createExpression.getArgument(i), createExpression.resolve().getParam(i).getType());
            }
        }
        return null;
    }

    public List<JavaStyleRewriter.StyleInfo> getStyles(ComponentInfo componentInfo) {
        return JavaStyleRewriter.getStyles(componentInfo);
    }

    public void setStyle(ComponentInfo component, String property, String value) {
        JavaStyleRewriter.setStyle(component, property, value);
    }

    public void setSizing(ComponentInfo componentInfo, Map<String, String> changes) {
        JavaStyleRewriter.setSizing(componentInfo, changes);
    }

    public ComponentInfo findComponentInfo(ComponentTypeAndSourceLocation typeAndSourceLocation) {
        return ComponentInfo.find(typeAndSourceLocation, this);
    }

    public boolean delete(ComponentInfo componentInfo) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> otherMethodCalls = JavaRewriterUtil.findMethodCallNonStatements(componentInfo);
        List<Expression> parameterUsages = JavaRewriterUtil.findParameterUsage(componentInfo);
        Optional attachRange = componentInfo.attachCall().getNode().getRange();
        if (attachRange.isPresent()) {
            parameterUsages = parameterUsages.stream().filter(parameter -> parameter.getRange().isPresent() && !((Range)parameter.getRange().get()).overlapsWith((Range)attachRange.get())).toList();
        }
        parameterUsages.forEach(expr -> {
            if (expr.getParentNode().isPresent() && ((Expression)expr.getParentNode().get()).isMethodCallExpr()) {
                MethodCallExpr methodCallExpr = (MethodCallExpr)expr.getParentNode().get();
                Optional classNameOpt = JavaRewriterUtil.findAncestor((Node)methodCallExpr, ClassOrInterfaceDeclaration.class).getFullyQualifiedName();
                if (classNameOpt.isEmpty()) {
                    throw new IllegalArgumentException("Could not find source class");
                }
                int argumentPosition = methodCallExpr.getArgumentPosition(expr);
                boolean arrayArgument = JavaRewriterUtil.isArrayArgument((String)classNameOpt.get(), methodCallExpr.getNameAsString(), argumentPosition);
                if (arrayArgument) {
                    JavaRewriterUtil.removeArgumentCalls(methodCallExpr, List.of(expr), true);
                } else if (methodCallExpr.getArguments().size() == 1) {
                    JavaRewriterUtil.removeStatement((Node)methodCallExpr);
                } else {
                    throw new IllegalArgumentException("Cannot handle " + methodCallExpr.getNameAsString() + " method");
                }
            }
        });
        functionCalls.forEach(expr -> JavaRewriterUtil.findAncestorOrThrow((Node)expr, Statement.class).remove());
        if (componentInfo.fieldDeclaration() != null) {
            componentInfo.fieldDeclaration().remove();
            if (componentInfo.fieldDeclarationAndAssignment() == null) {
                JavaRewriterUtil.removeStatement((Node)componentInfo.objectCreationExpr());
            }
        } else if (componentInfo.localVariableDeclarator() != null) {
            JavaRewriterUtil.removeStatement((Node)componentInfo.localVariableDeclarator());
        }
        otherMethodCalls.forEach(methodCall -> {
            if (!JavaRewriterUtil.removeFromStringConcatenation((Node)methodCall)) {
                JavaRewriterUtil.removeStatement((Node)methodCall);
            }
        });
        this.removeAttachCall(componentInfo);
        return true;
    }

    private Optional<Expression> removeAttachCall(ComponentInfo componentInfo) {
        Optional<Expression> addArgument = JavaRewriterUtil.getAttachArgument(componentInfo);
        addArgument.ifPresent(Node::remove);
        if (componentInfo.attachCall() != null && componentInfo.attachCall().getNodeWithArguments().getArguments().isEmpty()) {
            JavaRewriterUtil.removeStatement(componentInfo.attachCall().getNode());
        }
        return addArgument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveComponent(ComponentInfo component, ComponentInfo container, ComponentInfo reference, Where where) {
        ObjectCreationExpr toAdd;
        if (container == null) {
            throw new IllegalArgumentException("Container component must be non-null");
        }
        if (component.equals(container) || component.equals(reference) || container.equals(reference)) {
            throw new IllegalArgumentException("Component, container and reference must be different");
        }
        this.removeAttachCall(component);
        List<MethodCallExpr> containerFunctionCalls = JavaRewriterUtil.findMethodCallStatements(container);
        String componentFieldOrVariableName = JavaRewriterUtil.getFieldOrVariableName(component);
        Object object = toAdd = componentFieldOrVariableName == null ? component.objectCreationExpr() : new NameExpr(componentFieldOrVariableName);
        if (where == Where.APPEND) {
            String containerVariableName;
            if (reference != null) {
                throw new IllegalArgumentException("Reference component must be null when appending");
            }
            MethodCallExpr added = JavaRewriterUtil.addAfterLastFunctionCall(containerFunctionCalls, "add", new Expression[]{toAdd});
            if (added != null) return;
            InsertionPoint afterCreateExpr = JavaRewriterUtil.findLocationAfter((Expression)container.objectCreationExpr());
            String string = containerVariableName = container.localVariableName() == null ? container.fieldName() : container.localVariableName();
            if (containerVariableName == null) {
                ExtractInlineVariableResult extracted = JavaRewriterUtil.extractInlineVariableToLocalVariable(container);
                if (extracted == null) {
                    throw new IllegalArgumentException("Could not extract inline variable to local variable");
                }
                containerVariableName = extracted.newVariableName();
            }
            afterCreateExpr.add((Statement)new ExpressionStmt((Expression)JavaRewriterUtil.createMethodCall((Expression)new NameExpr(containerVariableName), "add", new Expression[]{toAdd})));
            return;
        } else {
            if (where != Where.BEFORE) throw new IllegalArgumentException(UNKNOWN_WHERE + String.valueOf((Object)where));
            if (reference == null) {
                throw new IllegalArgumentException("Reference component must be non-null when moving before");
            }
            Optional<Expression> referenceAddArgument = JavaRewriterUtil.findReference((NodeList<Expression>)reference.attachCall().getNodeWithArguments().getArguments(), reference);
            if (!referenceAddArgument.isPresent()) throw new IllegalArgumentException("Reference component not found in the add call");
            int refAddIndex = reference.attachCall().getNodeWithArguments().getArguments().indexOf((Object)referenceAddArgument.get());
            reference.attachCall().getNodeWithArguments().getArguments().add(refAddIndex, (Node)toAdd);
            List<MethodCallExpr> componentFunctionCalls = JavaRewriterUtil.findMethodCallStatements(component);
            if (componentFunctionCalls.isEmpty()) return;
            MethodCallExpr lastCall = componentFunctionCalls.get(componentFunctionCalls.size() - 1);
            BlockStmt insertBlock = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, BlockStmt.class);
            int finalAddLocation = JavaRewriterUtil.findBlockStatementIndex((Node)lastCall) + 1;
            int attachCallIndex = JavaRewriterUtil.findBlockStatementIndex(reference.attachCall().getNode());
            List<MethodCallExpr> allAddCalls = containerFunctionCalls.stream().filter(m -> m.getNameAsString().equals(reference.attachCall().getNodeWithSimpleName().getName().asString())).toList();
            for (MethodCallExpr addCall : allAddCalls) {
                int addCallIndex = JavaRewriterUtil.findBlockStatementIndex((Node)addCall);
                if (addCallIndex < attachCallIndex || addCallIndex >= finalAddLocation) continue;
                Statement statement = JavaRewriterUtil.findAncestorOrThrow((Node)addCall, Statement.class);
                statement.remove();
                insertBlock.addStatement(finalAddLocation - 1, statement);
            }
        }
    }

    public void duplicate(ComponentInfo component) {
        this.duplicate(component, true);
    }

    public DuplicateInfo duplicate(ComponentInfo component, boolean handleAdd) {
        String oldName;
        if (component.routeConstructor() != null) {
            throw new IllegalArgumentException("Cannot duplicate a route class");
        }
        InsertionPoint insertionPoint = this.findInsertionPointForAppend(component);
        ArrayList<MethodCallExpr> childAddCalls = new ArrayList<MethodCallExpr>();
        VariableDeclarationExpr variableDeclaration = null;
        AssignExpr assignExpr = null;
        String duplicatedName = null;
        if (component.localVariableName() != null) {
            oldName = component.localVariableName();
            duplicatedName = JavaRewriterUtil.findFreeVariableName(component.localVariableName(), insertionPoint.getBlock());
            VariableDeclarator newLocalVariable = JavaRewriterUtil.clone(component.localVariableDeclarator());
            newLocalVariable.setName(duplicatedName);
            variableDeclaration = new VariableDeclarationExpr(newLocalVariable);
            JavaRewriterUtil.appendExpressionAsNextSiblingInBlockAncestor((Node)component.localVariableDeclarator(), (Statement)new ExpressionStmt((Expression)variableDeclaration));
        } else if (component.fieldName() != null) {
            FieldDeclaration newField;
            oldName = component.fieldName();
            duplicatedName = insertionPoint.getFreeVariableName(component.fieldName());
            if (component.fieldDeclarationAndAssignment() != null) {
                newField = JavaRewriterUtil.clone(component.fieldDeclarationAndAssignment());
                if (newField.getVariables().isNonEmpty()) {
                    variableDeclaration = new VariableDeclarationExpr(newField.getVariable(0));
                }
            } else {
                newField = JavaRewriterUtil.clone(component.fieldDeclaration());
                if (newField.getVariables().size() > 1) {
                    newField.getVariables().removeIf(variableDeclarator -> !variableDeclarator.getNameAsString().equals(oldName));
                }
                assignExpr = JavaRewriterUtil.clone(component.assignmentExpression());
                assignExpr.setTarget((Expression)new NameExpr(duplicatedName));
                JavaRewriterUtil.appendExpressionAsNextSiblingInBlockAncestor((Node)component.assignmentExpression(), (Statement)new ExpressionStmt((Expression)assignExpr));
            }
            newField.getVariable(0).setName(duplicatedName);
            JavaRewriterUtil.addFieldAfter(newField, component.fieldDeclaration());
        } else {
            oldName = null;
        }
        if (duplicatedName != null) {
            List<MethodCallExpr> calls = JavaRewriterUtil.findMethodCallStatements(component);
            for (MethodCallExpr call : calls) {
                MethodCallExpr newCall = JavaRewriterUtil.clone(call);
                JavaRewriterUtil.setNameExprScope(newCall, new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)newCall));
                if (!newCall.getNameAsString().equals("add")) continue;
                childAddCalls.add(newCall);
            }
            List<Expression> parameterUsages = JavaRewriterUtil.findParameterUsage(component);
            Optional attachCallRangeOptional = component.attachCall().getNodeWithRange().getRange();
            if (attachCallRangeOptional.isPresent()) {
                Range attachRange = (Range)attachCallRangeOptional.get();
                parameterUsages = parameterUsages.stream().filter(parameter -> parameter.getRange().isPresent() && !((Range)parameter.getRange().get()).overlapsWith(attachRange)).toList();
            }
            for (Expression parameterUsage : parameterUsages) {
                MethodCallExpr methodCallExpr = JavaRewriterUtil.findAncestorOrThrow((Node)parameterUsage, MethodCallExpr.class);
                int argumentPosition = methodCallExpr.getArgumentPosition(parameterUsage);
                boolean addAsArg = false;
                Optional<Expression> scope = JavaRewriterUtil.getScopeIgnoreComposite(component, methodCallExpr);
                if (scope.isEmpty() || scope.get().isThisExpr()) {
                    Optional classNameOpt = JavaRewriterUtil.findAncestor((Node)parameterUsage, ClassOrInterfaceDeclaration.class).getFullyQualifiedName();
                    if (classNameOpt.isEmpty()) {
                        throw new IllegalArgumentException("Could not find source class");
                    }
                    addAsArg = JavaRewriterUtil.isArrayArgument((String)classNameOpt.get(), methodCallExpr.getNameAsString(), argumentPosition);
                }
                if (addAsArg) {
                    methodCallExpr.getArguments().add(argumentPosition + 1, (Node)new NameExpr(duplicatedName));
                    continue;
                }
                MethodCallExpr clone = JavaRewriterUtil.clone(methodCallExpr);
                clone.setArgument(argumentPosition, (Expression)new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)clone));
            }
        }
        if (handleAdd) {
            ObjectCreationExpr expressionToAdd;
            int addIndex;
            Expression componentAddArgument = JavaRewriterUtil.getAttachArgumentOrThrow(component);
            Optional<Expression> parentNode = componentAddArgument.getParentNode().map(Expression.class::cast);
            if (parentNode.isPresent() && parentNode.get().isObjectCreationExpr()) {
                ObjectCreationExpr objectCreationExpr = parentNode.get().asObjectCreationExpr();
                addIndex = objectCreationExpr.getArguments().indexOf((Object)componentAddArgument) + 1;
                expressionToAdd = objectCreationExpr;
            } else {
                addIndex = component.attachCall().getNodeWithArguments().getArgumentPosition(componentAddArgument) + 1;
                expressionToAdd = component.attachCall().getNodeWithArguments();
            }
            if (duplicatedName != null) {
                expressionToAdd.getArguments().add(addIndex, (Node)new NameExpr(duplicatedName));
            } else {
                expressionToAdd.getArguments().add(addIndex, (Node)((Expression)JavaRewriterUtil.clone(component.objectCreationExpr())));
            }
        }
        Map<String, String> nameMappings = oldName != null ? Collections.singletonMap(oldName, duplicatedName) : Collections.emptyMap();
        return new DuplicateInfo(nameMappings, childAddCalls, variableDeclaration, assignExpr);
    }

    public void addComponentUsingTemplate(ComponentInfo referenceComponent, Where where, List<JavaComponent> template, AddTemplateOptions options) {
        InsertionPoint insertionPoint = this.findInsertionPointForAppend(referenceComponent, where);
        if (where == Where.APPEND) {
            if (referenceComponent.routeConstructor() != null) {
                this.createComponentStatements(insertionPoint, null, template, "this", null, options);
            } else {
                this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(referenceComponent), null, options);
            }
        } else if (where == Where.BEFORE) {
            this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(referenceComponent), referenceComponent, options);
        } else {
            throw new IllegalArgumentException(UNKNOWN_WHERE + String.valueOf((Object)where));
        }
    }

    private InsertionPoint findInsertionPointForAppend(ComponentInfo component) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(component);
        if (!functionCalls.isEmpty()) {
            MethodCallExpr lastCall = functionCalls.get(functionCalls.size() - 1);
            return JavaRewriterUtil.findLocationAfter((Expression)lastCall);
        }
        if (component.routeConstructor() != null) {
            return JavaRewriterUtil.findLocationAtEnd((Statement)component.routeConstructor().getBody());
        }
        return JavaRewriterUtil.findLocationBefore(component.attachCall().expression());
    }

    public InsertionPoint findInsertionPointForAppend(ComponentInfo component, Where where) {
        if (where == Where.APPEND) {
            return this.findInsertionPointForAppend(component);
        }
        if (where == Where.BEFORE) {
            BlockStmt insertBlock = component.componentCreateScope();
            int insertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)component.objectCreationExpr());
            return new InsertionPoint(insertBlock, insertIndex);
        }
        throw new IllegalArgumentException(UNKNOWN_WHERE + String.valueOf((Object)where));
    }

    public void setAlignment(ComponentInfo component, String alignItemsClassName, String justifyContentClassName) {
        LumoRewriterUtil.removeClassNameArgs(component, "AlignItems", "JustifyContent");
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        if (alignItemsClassName != null) {
            this.addOrReplaceLumoClass(component, "AlignItems", alignItemsClassName);
        }
        if (justifyContentClassName != null) {
            this.addOrReplaceLumoClass(component, "JustifyContent", justifyContentClassName);
        }
    }

    public void setGap(ComponentInfo component, String lumoClassAll, String lumoClassColumn, String lumoClassRow) {
        MethodCallExpr call;
        LumoRewriterUtil.removeClassNameArgs(component, "Gap", "Gap.Column", "Gap.Row");
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        methodCallStatements.stream().filter(methodCallExpr -> StringUtils.equals((CharSequence)methodCallExpr.getNameAsString(), (CharSequence)SET_SPACING_METHOD)).findAny().ifPresent(JavaRewriterUtil::removeStatement);
        LumoRewriterUtil.removeThemeArgStartsWith(methodCallStatements, "spacing");
        if (lumoClassAll != null) {
            this.addOrReplaceLumoClass(component, "Gap", lumoClassAll);
        }
        if (lumoClassRow != null) {
            this.addOrReplaceLumoClass(component, "Gap.Row", lumoClassRow);
        }
        if (lumoClassColumn != null) {
            this.addOrReplaceLumoClass(component, "Gap.Column", lumoClassColumn);
        }
        if (lumoClassAll == null && lumoClassColumn == null && lumoClassRow == null && (call = JavaRewriterUtil.addAfterLastFunctionCall(methodCallStatements, SET_SPACING_METHOD, new Expression[]{new BooleanLiteralExpr(false)})) == null) {
            this.replaceOrAddCall(component, SET_SPACING_METHOD, false);
        }
    }

    private void addOrReplaceLumoClass(ComponentInfo component, String lumoUtilityClassName, String cssClassName) {
        List<Expression> gapExpressions = LumoRewriterUtil.getLumoMethodArgExpressions(List.of(lumoUtilityClassName), List.of(cssClassName));
        boolean added = LumoRewriterUtil.addClassNameWithArgs(component, gapExpressions);
        if (!added) {
            this.replaceOrAddCall(component, ADD_CLASS_NAMES_METHOD, gapExpressions.toArray(new Object[0]));
        }
    }

    public void setPadding(ComponentInfo component, String all, String top, String right, String bottom, String left) {
        String[] lumoPaddingInnerClassNames = new String[]{"Padding", "Padding.Bottom", "Padding.End", "Padding.Horizontal", "Padding.Left", "Padding.Right", "Padding.Start", "Padding.Top", "Padding.Vertical"};
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        methodCallStatements.stream().filter(methodCallExpr -> StringUtils.equals((CharSequence)methodCallExpr.getNameAsString(), (CharSequence)"setPadding")).forEach(JavaRewriterUtil::removeStatement);
        LumoRewriterUtil.removeSetThemeArgs(methodCallStatements, "padding");
        LumoRewriterUtil.removeClassNameArgs(component, lumoPaddingInnerClassNames);
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        if (all != null) {
            this.addOrReplaceLumoClass(component, "Padding", all);
        }
        if (top != null) {
            this.addOrReplaceLumoClass(component, "Padding.Top", top);
        }
        if (right != null) {
            this.addOrReplaceLumoClass(component, "Padding.Right", right);
        }
        if (bottom != null) {
            this.addOrReplaceLumoClass(component, "Padding.Bottom", bottom);
        }
        if (left != null) {
            this.addOrReplaceLumoClass(component, "Padding.Left", left);
        }
    }

    public void mergeAndReplace(List<ComponentInfo> components, JavaComponent wrapperComponent) {
        ComponentInfo firstComponent = components.get(0);
        BlockStmt firstComponentAttachScope = firstComponent.componentAttachScope().orElseThrow(() -> new IllegalArgumentException("Routes cannot be wrapped"));
        for (int i = 1; i < components.size(); ++i) {
            ComponentInfo component = components.get(i);
            Optional<BlockStmt> componentAttachScope = component.componentAttachScope();
            if (!componentAttachScope.isEmpty() && componentAttachScope.get() == firstComponentAttachScope) continue;
            throw new IllegalArgumentException("Only components attached in the same block are currently supported");
        }
        int wrapperInsertIndex = JavaRewriterUtil.findBlockStatementIndex(firstComponent.attachCall().getNode());
        InsertionPoint firstComponentAttachLocation = new InsertionPoint(firstComponentAttachScope, wrapperInsertIndex);
        List<VariableDeclarator> statements = this.createComponentStatements(firstComponentAttachLocation, null, wrapperComponent, false, null, null, new AddTemplateOptions(false));
        NameExpr wrapperVariable = new NameExpr(statements.get(0).getNameAsString());
        MethodCallExpr addCall = new MethodCallExpr((Expression)wrapperVariable, "add");
        Node wrapperAdd = null;
        for (int i = 0; i < components.size(); ++i) {
            Optional<Expression> componentAddArgument;
            ComponentInfo component = components.get(i);
            if (i == 0) {
                componentAddArgument = Optional.of(JavaRewriterUtil.getAttachArgumentOrThrow(component));
                Optional maybeParent = componentAddArgument.flatMap(Node::getParentNode);
                if (maybeParent.isEmpty()) {
                    throw new IllegalArgumentException("No add argument found for the first component");
                }
                wrapperAdd = (Node)maybeParent.get();
                wrapperAdd.replace((Node)componentAddArgument.get(), (Node)wrapperVariable);
            } else {
                componentAddArgument = this.removeAttachCall(component);
            }
            componentAddArgument.ifPresent(arg_0 -> ((MethodCallExpr)addCall).addArgument(arg_0));
        }
        if (wrapperAdd == null) {
            throw new IllegalArgumentException("Wrapper was never added");
        }
        firstComponentAttachLocation.getBlock().addStatement(JavaRewriterUtil.findBlockStatementIndex(wrapperAdd), (Expression)addCall);
    }

    public void replaceCallParameter(NodeWithArguments<?> call, String oldVariableName, String newVariableName) {
        call.getArguments().stream().forEach(arg -> {
            if (arg.isNameExpr() && arg.asNameExpr().getNameAsString().equals(oldVariableName)) {
                arg.asNameExpr().setName(newVariableName);
            }
        });
    }

    public void createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> template, String layoutVariableName, ComponentInfo referenceComponent, AddTemplateOptions options) {
        for (JavaComponent javaComponent : template) {
            Optional<CustomComponentHandle> customComponentHandleOpt = CustomComponentHandler.get(javaComponent);
            if (customComponentHandleOpt.isPresent()) {
                customComponentHandleOpt.get().createComponentStatements(this, javaComponent, insertionPoint, parent, layoutVariableName, referenceComponent, options);
                continue;
            }
            this.createComponentStatements(insertionPoint, parent, javaComponent, true, layoutVariableName, referenceComponent, options);
        }
    }

    public List<VariableDeclarator> createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, JavaComponent maybeJavaComponent, boolean attach, String layoutVariableName, ComponentInfo referenceComponent, AddTemplateOptions options) {
        ArrayList<VariableDeclarator> createdVariables = new ArrayList<VariableDeclarator>();
        if ("Message".equals(maybeJavaComponent.tag()) || "Item".equals(maybeJavaComponent.tag()) || "RadioButton".equals(maybeJavaComponent.tag()) || "CustomField".equals(maybeJavaComponent.tag())) {
            return createdVariables;
        }
        String componentClassName = maybeJavaComponent.className() != null ? maybeJavaComponent.className() : FlowComponentQuirks.getClassForComponent(maybeJavaComponent);
        JavaComponent javaComponent = componentClassName.equals("com.vaadin.flow.component.treegrid.TreeGrid") ? maybeJavaComponent.withTag("TreeGrid") : maybeJavaComponent;
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        HashMap setters = new HashMap();
        Class<?> componentType = JavaRewriterUtil.getClass(fullType.getNameWithScope());
        JavaRewriterUtil.addImport(this.compilationUnit, fullType.getNameWithScope());
        ClassOrInterfaceType variableType = JavaRewriterUtil.clone(fullType).removeScope();
        ClassOrInterfaceType itemsType = null;
        String itemsTypeName = javaComponent.metadata().getItemType();
        if (itemsTypeName != null) {
            itemsType = JavaRewriterUtil.clone(StaticJavaParser.parseClassOrInterfaceType((String)itemsTypeName)).removeScope();
        }
        ClassOrInterfaceType typeForInstantiation = JavaRewriterUtil.clone(variableType);
        String dataEntityRecordName = JavaRewriterUtil.findFreeRecordName("DataEntity", JavaRewriterUtil.findAncestor((Node)insertionPoint.getBlock(), ClassOrInterfaceDeclaration.class));
        ObjectCreationExpr initializer = JavaRewriterUtil.createComponentConstructor(javaComponent, typeForInstantiation, dataEntityRecordName, neededImport -> JavaRewriterUtil.addImport(this.compilationUnit, neededImport));
        if (itemsType != null) {
            initializer.getType().setTypeArguments(new Type[]{JavaRewriterUtil.createEmptyType()});
            JavaRewriterUtil.addImport(this.compilationUnit, itemsTypeName);
            variableType.setTypeArguments(new Type[]{itemsType});
        }
        String variableName = JavaRewriterUtil.generateVariableName(javaComponent, variableType, insertionPoint);
        if (options.javaFieldsForLeafComponents() && javaComponent.children().isEmpty()) {
            ClassOrInterfaceDeclaration classType = JavaRewriterUtil.findAncestorOrThrow((Node)insertionPoint.getBlock(), ClassOrInterfaceDeclaration.class);
            FieldDeclaration fieldDeclaration = classType.addFieldWithInitializer((Type)variableType, variableName, (Expression)initializer, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.FINAL});
            JavaRewriterUtil.moveAboveMethodsAndConstructors(fieldDeclaration, classType);
        } else {
            VariableDeclarator decl = new VariableDeclarator((Type)variableType, variableName, (Expression)initializer);
            VariableDeclarationExpr declarationExpr = new VariableDeclarationExpr(decl);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)declarationExpr));
            createdVariables.add(decl);
        }
        NameExpr variableReference = new NameExpr(variableName);
        JavaDataProviderHandler.FieldOrVariable fieldOrVariable = new JavaDataProviderHandler.FieldOrVariable((Expression)variableReference, (Type)variableType, initializer);
        if (javaComponent.tag() != null && javaComponent.tag().equalsIgnoreCase("Chart")) {
            this.insertSetter(insertionPoint, fieldOrVariable.reference(), "setMinHeight", "400px", this.compilationUnit, javaComponent);
        }
        JavaDataProviderHandler.handleDataStatementsAndClearDataProps(this.compilationUnit, fieldOrVariable, javaComponent, insertionPoint, dataEntityRecordName);
        javaComponent.props().forEach((prop, value) -> {
            if (prop.startsWith("_")) {
                return;
            }
            if (FlowComponentQuirks.skipProps(javaComponent, prop)) {
                return;
            }
            SetterAndValue setterAndValue = JavaRewriterUtil.getSetterAndValue(componentType, prop, value);
            setters.put(setterAndValue.setter(), setterAndValue.value());
        });
        JavaRewriterUtil.getSingleStringParamConstructor(fullType, setters.keySet()).ifPresent(constructorProp -> {
            Object value = setters.remove(constructorProp);
            this.getParameterList(insertionPoint, value).forEach(arg_0 -> ((ObjectCreationExpr)initializer).addArgument(arg_0));
        });
        for (Map.Entry setter : setters.entrySet()) {
            Object value2 = setter.getValue();
            if (value2 instanceof JavaComponent) {
                JavaComponent javaComponentValue = (JavaComponent)value2;
                value2 = this.createSubComponentStatements(insertionPoint, javaComponent, List.of(javaComponentValue), options).get(0);
            } else if (((String)setter.getKey()).equalsIgnoreCase(ADD_ITEM_METHOD) && value2 instanceof List) {
                List list = (List)value2;
                for (Object item : list) {
                    this.insertItemsPropToAddItem(this.compilationUnit, javaComponent, insertionPoint, fieldOrVariable.reference(), null, (String)setter.getKey(), item);
                }
                continue;
            }
            this.insertSetter(insertionPoint, fieldOrVariable.reference(), (String)setter.getKey(), value2, this.compilationUnit, javaComponent);
        }
        List<JavaComponent> methodChildren = FlowComponentQuirks.getMethodCallChildren(javaComponent);
        javaComponent.children().removeAll(methodChildren);
        this.createMethodCallChildrenStatements(insertionPoint, javaComponent, methodChildren, fieldOrVariable.reference(), dataEntityRecordName);
        List<JavaComponent> children = javaComponent.children().stream().map(child -> {
            if (FlowComponentQuirks.isTabSheetDefinition(child)) {
                JavaComponent tabContent;
                if (child.children().isEmpty()) {
                    HashMap<String, Object> emptyText = new HashMap<String, Object>();
                    emptyText.put("text", "");
                    tabContent = new JavaComponent("div", null, emptyText, Collections.emptyList());
                } else {
                    tabContent = child.children().get(0);
                }
                tabContent.props().put("_label", child.props().get("label"));
                return tabContent;
            }
            return child;
        }).toList();
        this.createComponentStatements(insertionPoint, javaComponent, children, variableName, null, options);
        if (attach) {
            this.attachComponent(insertionPoint, javaComponent, parent, layoutVariableName, referenceComponent, fieldOrVariable.reference(), variableName);
        }
        return createdVariables;
    }

    public void attachComponent(InsertionPoint insertionPoint, JavaComponent component, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, Expression variableNameExpr, String variableName) {
        if (component.tag() != null && component.tag().equalsIgnoreCase(CHART_SERIES_CLASS)) {
            MethodCallExpr getConfigurationCall = new MethodCallExpr((Expression)new NameExpr(layoutVariableName), "getConfiguration", new NodeList());
            MethodCallExpr addSeriesCall = new MethodCallExpr((Expression)getConfigurationCall, "addSeries", new NodeList((Node[])new Expression[]{variableNameExpr}));
            insertionPoint.add((Statement)new ExpressionStmt((Expression)addSeriesCall));
        } else if (referenceComponent != null) {
            AttachExpression referenceAttach = referenceComponent.attachCall();
            if (referenceAttach.getNodeWithArguments().getArguments().size() == 1) {
                ExpressionStmt addCall = this.createAddCall(component, parent, (Expression)referenceAttach.getNodeWithOptionalScope().getScope().orElse(JavaRewriterUtil.isNodeInCompositeClass(referenceAttach.getNode()) ? new MethodCallExpr("getContent", new Expression[0]) : null), variableNameExpr);
                BlockStmt block = JavaRewriterUtil.findAncestorOrThrow(referenceAttach.getNode(), BlockStmt.class);
                block.addStatement(JavaRewriterUtil.findBlockStatementIndex(referenceAttach.getNode()), (Statement)addCall);
            } else {
                Object referenceArgument = layoutVariableName == null ? referenceComponent.objectCreationExpr() : (Expression)referenceAttach.getNodeWithArguments().getArguments().stream().filter(arg -> {
                    NameExpr nameExpr;
                    return arg instanceof NameExpr && (nameExpr = (NameExpr)arg).getNameAsString().equals(layoutVariableName);
                }).findFirst().orElse(null);
                if (referenceArgument == null) {
                    throw new IllegalArgumentException("Did not find reference argument ('" + variableName + "') in " + String.valueOf(referenceAttach));
                }
                int index = referenceAttach.getNodeWithArguments().getArguments().indexOf(referenceArgument);
                referenceAttach.getNodeWithArguments().getArguments().add(index, (Node)variableNameExpr);
            }
        } else if (layoutVariableName != null) {
            NameExpr scope = null;
            if (!layoutVariableName.equals("this")) {
                scope = new NameExpr(layoutVariableName);
            } else if (JavaRewriterUtil.isNodeInCompositeClass((Node)insertionPoint.getBlock())) {
                scope = new MethodCallExpr("getContent", new Expression[0]);
            }
            ExpressionStmt addCall = this.createAddCall(component, parent, (Expression)scope, variableNameExpr);
            insertionPoint.add((Statement)addCall);
        } else {
            throw new IllegalArgumentException("Either layoutVariableName or referenceAttach must be given to attach a component");
        }
    }

    public NodeList<Expression> getParameterList(InsertionPoint insertionPoint, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return new NodeList();
            }
            if (list.get(0) instanceof JavaComponent) {
                return JavaRewriterUtil.toExpressionList(this.createSubComponentStatements(insertionPoint, null, list, new AddTemplateOptions(false)));
            }
        }
        return JavaRewriterUtil.toExpressionList(value);
    }

    public void insertSetter(InsertionPoint insertionPoint, Expression owner, String setterName, Object value, CompilationUnit compilationUnit, JavaComponent javaComponent) {
        if (setterName.equals("setStyle")) {
            this.insertStyles(insertionPoint, owner, (Map)value);
        } else if (setterName.equals("setClassName")) {
            Expression addClassNameExp = LumoRewriterUtil.createAddClassNameExprUsingLumoVariables(owner, value, compilationUnit);
            if (addClassNameExp == null) {
                NodeList<Expression> parameterExpression = this.getParameterList(insertionPoint, value);
                addClassNameExp = new MethodCallExpr(owner, setterName, parameterExpression);
            }
            insertionPoint.add((Statement)new ExpressionStmt(addClassNameExp));
        } else if (setterName.equals("setSlot")) {
            MethodCallExpr getElement = new MethodCallExpr(owner, "getElement");
            MethodCallExpr setAttributeCall = new MethodCallExpr((Expression)getElement, "setAttribute", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression("slot"), JavaRewriterUtil.toExpression(value)}));
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setAttributeCall));
        } else if (javaComponent.tag() != null && javaComponent.tag().equalsIgnoreCase("Chart") && !setterName.equals("setMinHeight")) {
            if (setterName.equals("setAdditionalOptions")) {
                Map additionalOptions = (Map)value;
                for (Map.Entry entry : additionalOptions.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (!key.equalsIgnoreCase("xAxis") && !key.equalsIgnoreCase("yAxis")) continue;
                    Map axis = (Map)val;
                    for (Map.Entry entryAxis : axis.entrySet()) {
                        String keyAxis = (String)entryAxis.getKey();
                        Object valAxis = entryAxis.getValue();
                        if (keyAxis.equalsIgnoreCase("categories")) {
                            insertionPoint.add((Statement)new ExpressionStmt(FlowComponentQuirks.getPropertySetExpression(compilationUnit, javaComponent, key, keyAxis, valAxis, owner, insertionPoint)));
                            continue;
                        }
                        if (!keyAxis.equalsIgnoreCase("title")) continue;
                        insertionPoint.add((Statement)new ExpressionStmt(FlowComponentQuirks.getPropertySetExpression(compilationUnit, javaComponent, key, keyAxis, valAxis, owner, insertionPoint)));
                    }
                }
            } else {
                NodeList<Expression> parameterExpression = this.getParameterList(insertionPoint, value);
                MethodCallExpr setterCall = new MethodCallExpr(FlowComponentQuirks.getPropertySetExpression(compilationUnit, javaComponent, null, setterName, value, owner, insertionPoint), setterName, parameterExpression);
                insertionPoint.add((Statement)new ExpressionStmt((Expression)setterCall));
            }
        } else if (javaComponent.tag() != null && javaComponent.tag().equalsIgnoreCase(CHART_SERIES_CLASS) && setterName.equals("setPlotOptions")) {
            insertionPoint.add((Statement)new ExpressionStmt(FlowComponentQuirks.getPropertySetExpression(compilationUnit, javaComponent, null, setterName, value, owner, insertionPoint)));
        } else {
            List list;
            NodeList<Expression> parameterExpression = this.getParameterList(insertionPoint, value);
            if (CHART_SERIES_CLASS.equals(javaComponent.tag()) && "setData".equals(setterName) && value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof JavaComponent) {
                parameterExpression = this.wrapWithListOf(parameterExpression);
                JavaRewriterUtil.addImport(compilationUnit, "java.util.List");
            }
            MethodCallExpr setterCall = new MethodCallExpr(owner, setterName, parameterExpression);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setterCall));
            if (value instanceof Enum) {
                JavaRewriterUtil.addImport(compilationUnit, value.getClass().getCanonicalName());
            }
        }
    }

    private NodeList<Expression> wrapWithListOf(NodeList<Expression> parameterExpression) {
        return new NodeList((Node[])new Expression[]{new MethodCallExpr((Expression)new NameExpr("List"), "of", parameterExpression)});
    }

    private void insertStyles(InsertionPoint insertionPoint, Expression owner, Map<String, String> styles) {
        MethodCallExpr finalCall = new MethodCallExpr(owner, "getStyle");
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            finalCall = new MethodCallExpr((Expression)finalCall, "set", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression(entry.getKey()), JavaRewriterUtil.toExpression(entry.getValue())}));
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)finalCall));
    }

    private NodeList<Expression> createSubComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> components, AddTemplateOptions options) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        for (JavaComponent javaComponent : components) {
            variables.addAll(this.createComponentStatements(insertionPoint, parent, javaComponent, false, null, null, options));
        }
        return new NodeList((Node[])((Expression[])variables.stream().map(VariableDeclarator::getName).map(NameExpr::new).toArray(NameExpr[]::new)));
    }

    private ExpressionStmt createAddCall(JavaComponent component, JavaComponent parent, Expression scope, Expression toAdd) {
        String methodName = "add";
        NodeList parameters = new NodeList((Node[])new Expression[]{toAdd});
        if (parent != null) {
            if (parent.tag().equals("SideNav") || parent.tag().equals("SideNavItem")) {
                methodName = ADD_ITEM_METHOD;
            } else if (parent.tag().equals("TabSheet")) {
                parameters.add(0, (Node)new StringLiteralExpr((String)component.props().get("_label")));
            }
        }
        return new ExpressionStmt((Expression)new MethodCallExpr(scope, methodName, parameters));
    }

    protected String getSource() {
        return this.source;
    }

    private void createMethodCallChildrenStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> methodChildren, Expression owner, String dataEntityRecordName) {
        ArrayList<JavaComponent> gridColumns = new ArrayList<JavaComponent>();
        ArrayList<JavaComponent> gridTreeColumns = new ArrayList<JavaComponent>();
        for (JavaComponent child : methodChildren) {
            if (FlowComponentQuirks.isGridTreeColumnDefinition(child)) {
                gridTreeColumns.add(child);
            }
            if (FlowComponentQuirks.isGridColumnDefinition(child)) {
                gridColumns.add(child);
                continue;
            }
            List<MethodCallExpr> expression = FlowComponentQuirks.getMethodCallExprFromComponent(this.compilationUnit, child, owner, dataEntityRecordName);
            for (MethodCallExpr methodCallExpr : expression) {
                insertionPoint.add((Statement)new ExpressionStmt((Expression)methodCallExpr));
            }
        }
        if (!gridColumns.isEmpty()) {
            List<Map<String, Object>> itemsFromProperty = parent.getItemsFromProperty();
            List supportedColumnsKeys = itemsFromProperty.stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toSet()).stream().collect(Collectors.toList());
            ArrayList<String> addedColumns = new ArrayList<String>();
            MethodCallExpr expression = new MethodCallExpr(owner, "setColumns");
            for (JavaComponent gridColumn : gridColumns) {
                String columnName = gridColumn.props().get("path").toString();
                if (!FlowComponentQuirks.isGridColumnDefinition(gridColumn) || !supportedColumnsKeys.contains(columnName) || addedColumns.contains(columnName)) continue;
                expression.addArgument((Expression)new StringLiteralExpr(columnName));
                addedColumns.add(columnName);
            }
            insertionPoint.add((Statement)new ExpressionStmt((Expression)expression));
        }
        if (!gridTreeColumns.isEmpty()) {
            MethodCallExpr expression = new MethodCallExpr(owner, "setHierarchyColumn");
            for (JavaComponent gridTreeColumn : gridTreeColumns) {
                expression.addArgument((Expression)new StringLiteralExpr(gridTreeColumn.props().get("path").toString()));
            }
            insertionPoint.add((Statement)new ExpressionStmt((Expression)expression));
        }
    }

    private void insertItemsPropToAddItem(CompilationUnit compilationUnit, JavaComponent javaComponent, InsertionPoint insertionPoint, Expression owner, Expression parent, String setterName, Object value) {
        if (!javaComponent.tag().equals("MenuBar") || !setterName.equals(ADD_ITEM_METHOD)) {
            throw new IllegalArgumentException("Invalid or not supported items to be added separately for " + javaComponent.tag() + " and setter " + setterName + " with value " + value.getClass().getName());
        }
        JavaRewriterUtil.addImport(compilationUnit, "com.vaadin.flow.component.contextmenu.MenuItem");
        JavaRewriterUtil.addImport(compilationUnit, "com.vaadin.flow.component.contextmenu.SubMenu");
        FlowComponentQuirks.menuBarInsertItemsPropsToAddItem(javaComponent, insertionPoint, owner, parent, setterName, value, false);
    }

    public void addComment(ComponentInfo componentInfo, String comment, CommentType commentType) {
        LineComment lineComment;
        Node targetNode = this.getNodeForAddingComment(componentInfo);
        if (targetNode != null) {
            switch (commentType.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    lineComment = new LineComment(comment);
                    break;
                }
                case 1: {
                    lineComment = new BlockComment(comment);
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to determine the target node for the component.");
        }
        LineComment newComment = lineComment;
        targetNode.setComment((Comment)newComment);
    }

    private Node getNodeForAddingComment(ComponentInfo componentInfo) {
        if (componentInfo.localVariableDeclarator() != null) {
            return componentInfo.localVariableDeclarator().getParentNode().orElse(null);
        }
        if (componentInfo.assignmentExpression() != null) {
            return componentInfo.assignmentExpression();
        }
        if (componentInfo.fieldDeclaration() != null) {
            return componentInfo.fieldDeclaration();
        }
        if (componentInfo.fieldDeclarationAndAssignment() != null) {
            return componentInfo.fieldDeclarationAndAssignment();
        }
        if (componentInfo.routeConstructor() != null) {
            return componentInfo.routeConstructor();
        }
        if (componentInfo.attachCall() != null) {
            return componentInfo.attachCall().getNode();
        }
        return null;
    }

    public record ReplaceResult(String variableRenamedTo) {
    }

    public static enum Where {
        BEFORE,
        APPEND;

    }

    public record ExtractInlineVariableResult(BlockStmt blockStmt, String newVariableName, int index) {
    }

    public record DuplicateInfo(Map<String, String> nameMapping, List<MethodCallExpr> childAddCalls, VariableDeclarationExpr variableDeclaration, AssignExpr assignExpr) {
    }

    public record AddTemplateOptions(boolean javaFieldsForLeafComponents) {
    }

    public static enum CommentType {
        LINE,
        BLOCK;

    }

    public record SetterAndValue(String setter, Object value) {
    }

    public static enum AlignmentMode {
        ALIGN_ITEMS,
        SELF_HORIZONTALLY,
        SELF_VERTICALLY;

    }

    public record Code(String code) {
    }
}

