/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ComponentSourceFinder;
import com.vaadin.copilot.JavaSourcePathDetector;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.JsonObject;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Util {
    private static final Pattern endsWithNumber = Pattern.compile("([0-9]+)$");

    public static String increaseTrailingNumber(String filename) {
        String[] parts = filename.split("\\.", 2);
        String base = parts[0];
        String extension = parts[1];
        Matcher matcher = endsWithNumber.matcher(base);
        if (matcher.find()) {
            return base.substring(0, matcher.start()) + (Integer.parseInt(matcher.group()) + 1) + "." + extension;
        }
        return base + "1." + extension;
    }

    public static File getSinglePackage(File javaSourceFolder) {
        File[] files = javaSourceFolder.listFiles();
        if (files == null || files.length == 0 || files.length > 1) {
            return javaSourceFolder;
        }
        if (files[0].isDirectory()) {
            return Util.getSinglePackage(files[0]);
        }
        return javaSourceFolder;
    }

    public static String titleCase(String input) {
        return Arrays.stream(input.split(" ")).map(SharedUtil::capitalize).collect(Collectors.joining(" "));
    }

    public static Path replaceFolderInPath(Path path, String oldFolderName, String newFolderName, String parentFolder) {
        Path newPath = path.isAbsolute() ? Path.of("/", new String[0]) : Path.of("", new String[0]);
        boolean inParent = false;
        for (Path part : path) {
            newPath = inParent && part.toString().equals(oldFolderName) ? newPath.resolve(newFolderName) : newPath.resolve(part);
            inParent = parentFolder.equals(part.toString());
        }
        return newPath;
    }

    public static Optional<Path> findCommonAncestor(List<Path> paths) {
        if (paths == null || paths.isEmpty()) {
            return Optional.empty();
        }
        Path commonPath = paths.get(0);
        for (int i = 1; i < paths.size(); ++i) {
            Path otherPath = paths.get(i);
            commonPath = Path.of(StringUtils.getCommonPrefix((String[])new String[]{commonPath.toString(), otherPath.toString()}), new String[0]);
        }
        return Optional.of(commonPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<File> findCurrentViewFile(ProjectManager projectManager, JsonObject currentView) {
        if (currentView == null) {
            return Optional.empty();
        }
        if (currentView.hasKey("views") && currentView.getArray("views").length() > 0) {
            return Optional.of(new File(currentView.getArray("views").getString(0)));
        }
        if (currentView.hasKey("uiId")) {
            int uiId = (int)currentView.getNumber("uiId");
            VaadinSession session = projectManager.getVaadinSession();
            session.lock();
            try {
                UI ui = session.getUIById(uiId);
                Optional<File> optional = Optional.of(new ComponentSourceFinder(projectManager)._getSourceLocation(ui.getCurrentView()).javaFile());
                return optional;
            }
            finally {
                session.unlock();
            }
        }
        return Optional.empty();
    }

    public static Optional<JavaSourcePathDetector.ModuleInfo> findCurrentModule(ProjectManager projectManager, JsonObject currentView) {
        return Util.findCurrentViewFile(projectManager, currentView).flatMap(ProjectFileManager.getInstance()::findModule);
    }
}

