package com.vaadin.copilot.communication;

public enum CopilotServerResponseCode {
    COPILOT_INTERNAL_ERROR(-400), //
    COPILOT_AUTHORISATION_FAILED(-401), //
    EXTERNAL_AUTHORISATION_FAILED(-402), //
    COPILOT_TOKEN_LIMIT_REACHED(-403), //
    COPILOT_REQUEST_LIMIT_REACHED(-404), //
    USER_TOKEN_LIMIT_REACHED(-405), //
    USER_REQUEST_LIMIT_REACHED(-406), //
    EMBEDDED_CONTEXT_RETRIEVAL(-407), //
    LOG_DATABASE(-408), //
    VECTOR_DATABASE(-409), //
    OUTPUT_SIZE_TOO_LONG(-410), //
    PROMPT_SIZE_TOO_LONG(-411), //
    EXTERNAL_SERVER_OVERLOADED(-412), //
    EXTERNAL_SERVER_UNREACHABLE(-413), //
    PROCESSOR(-414), //
    AI_MODEL(-415), //
    ERROR_REQUEST(-2), //
    ERROR(-1), //
    NOTHING(0), //
    HILLA_REACT(1), //
    FLOW(2), //
    LOCAL(3); //

    private final int code;

    CopilotServerResponseCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }
}
