/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.AccessRequirement;
import com.vaadin.copilot.AccessRequirementUtil;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.VaadinServletContext;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiServiceHandler
implements CopilotCommand {
    private final ProjectManager projectManager;
    private final VaadinServletContext context;

    public UiServiceHandler(ProjectManager projectManager, VaadinServletContext context) {
        this.projectManager = projectManager;
        this.context = context;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-browser-callables")) {
            JsonObject returnData = Json.createObject();
            returnData.put("reqId", data.getString("reqId"));
            List<SpringBridge.EndpointInfo> browserCallables = SpringBridge.getEndpoints(this.context);
            JsonArray browserCallableJson = (JsonArray)browserCallables.stream().sorted(UiServiceHandler::sortByClassName).map(browserCallable -> {
                JsonObject json = Json.createObject();
                json.put("className", browserCallable.endpointClass().getName());
                json.put("filename", this.projectManager.getFileForClass(browserCallable.endpointClass()).getAbsolutePath());
                json.put("lineNumber", 1.0);
                json.put("methodName", browserCallable.method().getName());
                json.put("parameters", (JsonValue)Arrays.stream(browserCallable.method().getParameters()).map(param -> {
                    JsonObject paramInfo = Json.createObject();
                    paramInfo.put("name", param.getName());
                    paramInfo.put("type", param.getType().getName());
                    return paramInfo;
                }).collect(JsonUtils.asArray()));
                try {
                    AccessRequirement req = AccessRequirementUtil.getAccessRequirement(browserCallable.method(), browserCallable.endpointClass());
                    json.put("accessRequirement", (JsonValue)JsonUtils.beanToJson((Object)req));
                }
                catch (Exception e) {
                    UiServiceHandler.getLogger().error("Unable to determine access requirement", (Throwable)e);
                }
                return json;
            }).collect(JsonUtils.asArray());
            returnData.put("browserCallables", (JsonValue)browserCallableJson);
            devToolsInterface.send("resp" + command, returnData);
            return true;
        }
        return false;
    }

    public static int sortByClassName(SpringBridge.EndpointInfo e1, SpringBridge.EndpointInfo e2) {
        if (!e1.endpointClass().equals(e2.endpointClass())) {
            return e1.endpointClass().getName().compareTo(e2.endpointClass().getName());
        }
        return e1.method().getName().compareTo(e2.method().getName());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(UiServiceHandler.class);
    }
}

