/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.JavaRewriter;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class LumoRewriterUtil {
    private static final String addClassName = "addClassName";
    private static final String addClassNames = "addClassNames";
    private static final String setClassName = "setClassName";
    private static final List<String> classNameMethods = List.of("addClassName", "addClassNames", "setClassName");

    public static void removeThemeArgStartsWith(List<MethodCallExpr> methodCallStatements, String startsWith) {
        List<MethodCallExpr> themeAddCalls = LumoRewriterUtil.getThemeAddCalls(methodCallStatements);
        for (MethodCallExpr addCall : themeAddCalls) {
            List argsToRemove = addCall.getArguments().stream().filter(f -> f.isStringLiteralExpr() && f.asStringLiteralExpr().asString().startsWith(startsWith)).collect(Collectors.toList());
            JavaRewriterUtil.removeArgumentCalls(addCall, argsToRemove, true);
        }
    }

    public static void removeThemeArgs(List<MethodCallExpr> methodCallStatements, List<String> args) {
        List<MethodCallExpr> themeAddCalls = LumoRewriterUtil.getThemeAddCalls(methodCallStatements);
        for (MethodCallExpr addCall : themeAddCalls) {
            List argsToRemove = addCall.getArguments().stream().filter(f -> f.isStringLiteralExpr() && args.contains(f.asStringLiteralExpr().asString())).collect(Collectors.toList());
            JavaRewriterUtil.removeArgumentCalls(addCall, argsToRemove, true);
        }
    }

    public static boolean addClassNameWithArgs(ComponentInfo component, List<Expression> arguments) {
        Optional<MethodCallExpr> addClassNamesOptional;
        MethodCallExpr methodClassExpr;
        if (component.routeConstructor() != null) {
            methodClassExpr = new MethodCallExpr();
        } else {
            if (JavaRewriterUtil.inlineAssignment(component)) {
                JavaRewriter.ExtractInlineVariableResult extractInlineVariableResult = JavaRewriterUtil.extractInlineVariableToLocalVariable(component);
                if (extractInlineVariableResult == null) {
                    return false;
                }
                MethodCallExpr methodClassExpr2 = new MethodCallExpr((Expression)new NameExpr(extractInlineVariableResult.newVariableName()), addClassName);
                arguments.forEach(arg_0 -> ((MethodCallExpr)methodClassExpr2).addArgument(arg_0));
                extractInlineVariableResult.blockStmt().addStatement(extractInlineVariableResult.index() + 1, (Expression)methodClassExpr2);
                return true;
            }
            String varName = component.localVariableName() != null ? component.localVariableName() : component.fieldName();
            methodClassExpr = new MethodCallExpr((Expression)new NameExpr(varName), addClassName);
        }
        arguments.forEach(arg_0 -> ((MethodCallExpr)methodClassExpr).addArgument(arg_0));
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        List<MethodCallExpr> classNameMethodCalls = methodCallStatements.stream().filter(f -> classNameMethods.contains(f.getNameAsString())).toList();
        for (int i = classNameMethodCalls.size() - 1; i >= 0; --i) {
            if (!classNameMethodCalls.get(i).getNameAsString().equals(setClassName)) continue;
            classNameMethodCalls = classNameMethodCalls.subList(i + 1, classNameMethodCalls.size());
            break;
        }
        if ((addClassNamesOptional = classNameMethodCalls.stream().filter(f -> f.getNameAsString().equals(addClassNames)).findAny()).isPresent()) {
            arguments.forEach(arg -> ((MethodCallExpr)addClassNamesOptional.get()).addArgument(arg));
            return true;
        }
        return JavaRewriterUtil.addAfterLastFunctionCall(methodCallStatements, addClassNames, (Expression[])arguments.toArray(Expression[]::new));
    }

    public static void removeClassNameArgs(ComponentInfo component, String ... lumoUtilityClassNames) {
        List<String> classNameDefinitionMethodNames = List.of(addClassName, addClassNames, setClassName);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        List<MethodCallExpr> classNameDefinitionMethods = methodCallStatements.stream().filter(f -> classNameDefinitionMethodNames.contains(f.getNameAsString())).toList();
        ArrayList<Expression> argsWillBeRemoved = new ArrayList<Expression>();
        for (String lumoUtilityClassName : lumoUtilityClassNames) {
            argsWillBeRemoved.addAll(LumoRewriterUtil.getPossibleLumoUtilityMethodArgExpressions(lumoUtilityClassName));
        }
        JavaRewriterUtil.removeArgumentCalls(classNameDefinitionMethods, argsWillBeRemoved, true);
    }

    public static void addLumoUtilityImport(CompilationUnit compilationUnit) {
        JavaRewriterUtil.addImport(compilationUnit, "com.vaadin.flow.theme.lumo.LumoUtility");
    }

    private static List<Expression> getPossibleLumoUtilityMethodArgExpressions(String lumoInnerClassName) {
        BiMap<String, String> utilityClasses = LumoRewriterUtil.getLumoFieldsNameValueMap(lumoInnerClassName);
        ArrayList<Expression> lumoRelatedUtilityClasses = new ArrayList<Expression>();
        lumoRelatedUtilityClasses.addAll(utilityClasses.keySet().stream().map(arg -> new FieldAccessExpr((Expression)new NameExpr("LumoUtility." + lumoInnerClassName), arg)).toList());
        lumoRelatedUtilityClasses.addAll(utilityClasses.values().stream().map(StringLiteralExpr::new).toList());
        return lumoRelatedUtilityClasses;
    }

    public static List<Expression> getLumoMethodArgExpressions(String lumoInnerClassName, List<String> classNames) {
        BiMap<String, String> classKeyValueMap = LumoRewriterUtil.getLumoFieldsNameValueMap(lumoInnerClassName);
        return classNames.stream().map(lumoClassValue -> (String)classKeyValueMap.inverse().get(lumoClassValue)).filter(Objects::nonNull).map(arg -> new FieldAccessExpr((Expression)new NameExpr("LumoUtility." + lumoInnerClassName), arg)).map(k -> k).toList();
    }

    private static BiMap<String, String> getLumoFieldsNameValueMap(String innerClassName) {
        try {
            HashBiMap biMap = HashBiMap.create();
            Class<?> lumoUtilityClazz = JavaRewriterUtil.getClass("com.vaadin.flow.theme.lumo.LumoUtility$" + innerClassName);
            for (Field declaredField : lumoUtilityClazz.getDeclaredFields()) {
                String name = declaredField.getName();
                String value = (String)declaredField.get(null);
                biMap.put((Object)name, (Object)value);
            }
            return biMap;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("There is no lumo utility field named " + innerClassName);
        }
    }

    private static List<MethodCallExpr> getThemeAddCalls(List<MethodCallExpr> methodCallStatements) {
        return methodCallStatements.stream().filter(methodCallExpr -> methodCallExpr.getScope().isPresent()).filter(methodCallExpr -> ((Expression)methodCallExpr.getScope().get()).toString().contains("getThemeList")).filter(methodCallExpr -> methodCallExpr.getNameAsString().equals("add") || methodCallExpr.getNameAsString().equals("addAll")).collect(Collectors.toList());
    }
}

