/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.SpringBridge;
import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.javarewriter.JavaModifier;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.theme.Theme;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInitializer
implements CopilotCommand {
    public static final String SUCCESS_KEY = "success";
    public static final String REASON_KEY = "reason";
    public static final String INIT_APP_RESULT = "copilot-init-app-result";
    public static final String INIT_APP_ADD_DEVTOOLS_RESULT = "copilot-init-app-add-devtools-result";
    public static final String REFRESH_KEY = "refresh";
    private final ProjectManager projectManager;
    private final VaadinServletContext context;

    public ApplicationInitializer(ProjectManager projectManager, VaadinServletContext context) {
        this.projectManager = projectManager;
        this.context = context;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("init-app")) {
            String framework = data.getString("framework");
            try {
                this.initApp(framework, devToolsInterface, data.getString("reqId"));
            }
            catch (IOException e) {
                ApplicationInitializer.getLogger().error("Unable to initialize project", (Throwable)e);
            }
            return true;
        }
        if (command.equals("init-app-add-devtools")) {
            try {
                this.addSpringDevTools(devToolsInterface, data.getString("reqId"));
            }
            catch (IOException e) {
                ApplicationInitializer.getLogger().error("Unable to add Spring Dev Tools", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void addSpringDevTools(DevToolsInterface devToolsInterface, String reqId) throws IOException {
        JsonObject responseData = Json.createObject();
        responseData.put("reqId", reqId);
        File pomXml = new File(this.projectManager.getProjectRoot(), "pom.xml");
        if (!pomXml.exists()) {
            ErrorHandler.setError(responseData, "There is no pom.xml file at " + pomXml.getAbsolutePath());
            devToolsInterface.send(INIT_APP_ADD_DEVTOOLS_RESULT, responseData);
            return;
        }
        Object pomContent = this.projectManager.readFile(pomXml);
        int dependencyInProject = ((String)pomContent).indexOf("vaadin-spring-boot-starter");
        int endDependencyTag = ((String)pomContent).indexOf("</dependency>", dependencyInProject);
        int indent = endDependencyTag - ((String)pomContent).lastIndexOf("\n", endDependencyTag) - 1;
        int endOfDependency = endDependencyTag + "</dependency>".length();
        String newDependency = "<dependency>\n    <groupId>org.springframework.boot</groupId>\n    <artifactId>spring-boot-devtools</artifactId>\n    <optional>true</optional>\n</dependency>\n";
        newDependency = newDependency.replaceAll("(^|\n)", "\n" + " ".repeat(indent));
        pomContent = ((String)pomContent).substring(0, endOfDependency) + newDependency + ((String)pomContent).substring(endOfDependency);
        this.projectManager.writeFile(pomXml, "Add Spring Dev Tools", (String)pomContent);
        devToolsInterface.send(INIT_APP_ADD_DEVTOOLS_RESULT, responseData);
    }

    private void initApp(String framework, DevToolsInterface devToolsInterface, String reqId) throws IOException {
        File toOpen;
        JsonObject responseData = Json.createObject();
        responseData.put("reqId", reqId);
        if (!SpringBridge.isSpringAvailable()) {
            responseData.put(SUCCESS_KEY, false);
            responseData.put(REASON_KEY, "This only works for Spring Boot projects");
            devToolsInterface.send(INIT_APP_RESULT, responseData);
            return;
        }
        HashMap<? extends File, String> toWrite = new HashMap<File, String>();
        Class<?> applicationClass = SpringBridge.getApplicationClass(this.context);
        Theme themeAnnotation = applicationClass.getAnnotation(Theme.class);
        if (themeAnnotation == null) {
            String themeName = "my-theme";
            toWrite.putAll(new JavaModifier(this.projectManager).modify(applicationClass, operations -> {
                operations.addClassAnnotation(Theme.class, themeName);
                operations.addInterface(AppShellConfigurator.class);
            }));
            toWrite.putAll(this.createTheme(this.projectManager, themeName));
        }
        if (framework.equals("flow")) {
            Map<? extends File, String> flowView = this.addFlowView(this.projectManager, applicationClass);
            toWrite.putAll(flowView);
            toOpen = flowView.keySet().iterator().next();
        } else if (framework.equals("hilla")) {
            Map<File, String> hillaView = this.addHillaView(this.projectManager);
            toWrite.putAll(hillaView);
            toOpen = hillaView.keySet().iterator().next();
        } else {
            responseData.put(SUCCESS_KEY, false);
            responseData.put(REASON_KEY, "Unknown framework " + framework);
            devToolsInterface.send(INIT_APP_RESULT, responseData);
            return;
        }
        for (Map.Entry entry : toWrite.entrySet()) {
            this.projectManager.writeFile((File)entry.getKey(), "Project generation", (String)entry.getValue());
        }
        if (toOpen != null) {
            try {
                Thread.sleep(1000L);
                IdeUtils.openFile(toOpen, 1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        responseData.put(SUCCESS_KEY, true);
        responseData.put(REFRESH_KEY, true);
        devToolsInterface.send(INIT_APP_RESULT, responseData);
    }

    private Map<File, String> addHillaView(ProjectManager projectManager) {
        File frontendFolder = projectManager.getFrontendFolder();
        File viewFile = new File(new File(frontendFolder, "views"), "@index.tsx");
        String viewTemplate = ApplicationInitializer.getViewTemplate(projectManager, viewFile);
        return Collections.singletonMap(viewFile, viewTemplate);
    }

    private Map<? extends File, String> addFlowView(ProjectManager projectManager, Class<?> applicationClass) {
        File applicationFile = projectManager.getFileForClass(applicationClass);
        String basePackage = applicationClass.getPackage().getName();
        File viewFolder = new File(applicationFile.getParentFile(), "views");
        File viewFile = new File(viewFolder, "HomeView.java");
        String relativeViewName = projectManager.getProjectRelativeName(viewFile);
        String viewPackage = basePackage + ".views";
        String content = String.format("package %s;\n\nimport com.vaadin.flow.component.html.H1;\nimport com.vaadin.flow.component.html.Paragraph;\nimport com.vaadin.flow.component.orderedlayout.VerticalLayout;\nimport com.vaadin.flow.router.Route;\n\n@Route(\"\")\npublic class HomeView extends VerticalLayout {\n\n    public HomeView() {\n\n        add(new H1(\"Welcome to your new application\"));\n        add(new Paragraph(\"This is the home view\"));\n\n        add(new Paragraph(\"You can edit this view in %s\"));\n\n    }\n}\n", viewPackage, relativeViewName);
        return Collections.singletonMap(viewFile, content);
    }

    private static String getViewTemplate(ProjectManager projectManager, File viewFile) {
        String relativeViewName = projectManager.getProjectRelativeName(viewFile);
        return String.format("export default function HomeView() {\n  return (\n    <div>\n      <h1>Welcome to your new application</h1>\n      <p>This is the home view.</p>\n      <p>\n        You can edit this view in <code>%s</code> or by\n        activating Copilot by clicking the icon in the lower right corner\n      </p>\n    </div>\n  );\n}\n\n", relativeViewName);
    }

    private Map<File, String> createTheme(ProjectManager projectManager, String themeName) {
        File frontendFolder = projectManager.getFrontendFolder();
        File themeFolder = new File(new File(frontendFolder, "themes"), themeName);
        File stylesCss = new File(themeFolder, "styles.css");
        if (!themeFolder.exists()) {
            return Collections.singletonMap(stylesCss, "");
        }
        return Collections.emptyMap();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ApplicationInitializer.class);
    }
}

