/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Range;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.vaadin.copilot.javarewriter.AttachExpression;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.copilot.javarewriter.ConstructorAnalyzer;
import com.vaadin.copilot.javarewriter.FlowComponentQuirks;
import com.vaadin.copilot.javarewriter.InsertionPoint;
import com.vaadin.copilot.javarewriter.JavaComponent;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.copilot.javarewriter.LumoRewriterUtil;
import com.vaadin.flow.shared.util.SharedUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JavaRewriter {
    private final String source;
    private final ParserConfiguration parserConfiguration = new ParserConfiguration();
    protected CompilationUnit compilationUnit;

    public JavaRewriter(String source) {
        this.source = source;
        this.parseSource(source);
    }

    private void parseSource(String source) {
        this.parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver(false));
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        this.parserConfiguration.setSymbolResolver((SymbolResolver)symbolSolver);
        StaticJavaParser.setConfiguration((ParserConfiguration)this.parserConfiguration);
        this.compilationUnit = (CompilationUnit)LexicalPreservingPrinter.setup((Node)StaticJavaParser.parse((String)source));
    }

    public String getResult() {
        return LexicalPreservingPrinter.print((Node)this.compilationUnit);
    }

    public int getFirstModifiedRow() {
        int row = 1;
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != this.getResult().charAt(i)) {
                return row;
            }
            if (this.source.charAt(i) != '\n') continue;
            ++row;
        }
        return -1;
    }

    public boolean replaceFunctionCall(ComponentInfo componentInfo, String function, Object value) {
        if (this.replaceConstructorParam(componentInfo, function, value)) {
            return true;
        }
        return this.replaceOrAddCall(componentInfo, function, value);
    }

    private boolean replaceConstructorParam(ComponentInfo componentInfo, String function, Object value) {
        Optional<Map.Entry> mapping;
        ObjectCreationExpr objectCreationExpr = componentInfo.objectCreationExpr();
        Optional<Constructor<?>> constructor = JavaRewriterUtil.findConstructor(componentInfo.type(), objectCreationExpr);
        Optional<Map> mappings = constructor.map(c -> ConstructorAnalyzer.get().getMappings((Constructor<?>)c));
        if (mappings.isPresent() && (mapping = mappings.get().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(function)).findFirst()).isPresent()) {
            objectCreationExpr.setArgument(((Integer)mapping.get().getKey()).intValue(), JavaRewriterUtil.toExpression(value));
            return true;
        }
        return false;
    }

    private String getMappedProperty(Constructor<?> c, int propertyIndex) {
        return ConstructorAnalyzer.get().getMappings(c).entrySet().stream().filter(entry -> (Integer)entry.getKey() == propertyIndex).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public boolean addCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        return this.doReplaceOrAddCall(componentInfo, function, false, parameters);
    }

    public boolean replaceOrAddCall(ComponentInfo componentInfo, String function, Object ... parameters) {
        return this.doReplaceOrAddCall(componentInfo, function, true, parameters);
    }

    private boolean doReplaceOrAddCall(ComponentInfo componentInfo, String function, boolean replace, Object ... parameters) {
        ExtractInlineVariableResult extractInlineVariableResult;
        ArrayList<Expression> parameterExpressions = new ArrayList<Expression>();
        for (Object parameter : parameters) {
            parameterExpressions.add(JavaRewriterUtil.toExpression(parameter));
        }
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        MethodCallExpr functionCall = functionCalls.stream().filter(m -> m.getNameAsString().equals(function)).findFirst().orElse(null);
        if (replace && functionCall != null) {
            if (parameterExpressions.size() == 1) {
                functionCall.setArgument(0, (Expression)parameterExpressions.get(0));
            }
            return true;
        }
        if (!functionCalls.isEmpty() && JavaRewriterUtil.addAfterLastFunctionCall(functionCalls, function, parameterExpressions.toArray(new Expression[0]))) {
            return true;
        }
        int addAfterStatementIndex = -1;
        BlockStmt scope = componentInfo.componentCreateScope();
        if (componentInfo.localVariableDeclarator() != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.localVariableDeclarator());
        } else if (componentInfo.fieldDeclaration() != null && componentInfo.fieldDeclarationAndAssignment() == null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex((Node)componentInfo.assignmentExpression());
        } else if (componentInfo.fieldDeclarationAndAssignment() != null) {
            addAfterStatementIndex = JavaRewriterUtil.findBlockStatementIndex(componentInfo.attachCall().getNode()) - 1;
            scope = componentInfo.componentAttachScope();
        }
        if (addAfterStatementIndex >= 0) {
            NameExpr variable = new NameExpr(JavaRewriterUtil.getFieldOrVariableName(componentInfo));
            MethodCallExpr newCall = new MethodCallExpr((Expression)variable, function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            scope.addStatement(addAfterStatementIndex + 1, (Statement)new ExpressionStmt((Expression)newCall));
            return true;
        }
        if (JavaRewriterUtil.inlineAssignment(componentInfo) && (extractInlineVariableResult = JavaRewriterUtil.extractInlineVariableToLocalVariable(componentInfo)) != null) {
            MethodCallExpr newCall = new MethodCallExpr((Expression)new NameExpr(extractInlineVariableResult.newVariableName()), function);
            parameterExpressions.forEach(arg_0 -> ((MethodCallExpr)newCall).addArgument(arg_0));
            extractInlineVariableResult.blockStmt.addStatement(extractInlineVariableResult.index + 1, (Expression)newCall);
            return true;
        }
        throw new IllegalStateException("Unable to determine where to add function call");
    }

    public Object getPropertyValue(ComponentInfo componentInfo, String property) {
        Optional<Constructor<?>> maybeConstructor;
        String setterName = JavaRewriterUtil.getSetterName(property, componentInfo.type(), false);
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> candidates = functionCalls.stream().filter(m -> m.getNameAsString().equals(setterName)).toList();
        if (!candidates.isEmpty()) {
            MethodCallExpr setterCall = candidates.get(candidates.size() - 1);
            Expression arg = (Expression)setterCall.getArguments().get(0);
            return JavaRewriterUtil.fromExpression(arg, setterCall.resolve().getParam(0).getType());
        }
        ObjectCreationExpr createExpression = componentInfo.objectCreationExpr();
        if (createExpression != null && (maybeConstructor = JavaRewriterUtil.findConstructor(componentInfo.type(), createExpression)).isPresent()) {
            Constructor<?> constructor = maybeConstructor.get();
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                String mappedProperty = this.getMappedProperty(constructor, i);
                if (!setterName.equals(mappedProperty)) continue;
                return JavaRewriterUtil.fromExpression(createExpression.getArgument(i), createExpression.resolve().getParam(i).getType());
            }
        }
        return null;
    }

    public ComponentInfo findComponentInfo(ComponentTypeAndSourceLocation typeAndSourceLocation) {
        return ComponentInfo.find(typeAndSourceLocation, this);
    }

    public boolean delete(ComponentInfo componentInfo) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(componentInfo);
        List<MethodCallExpr> otherMethodCalls = JavaRewriterUtil.findMethodCallNonStatements(componentInfo);
        functionCalls.forEach(expr -> JavaRewriterUtil.findAncestorOrThrow((Node)expr, Statement.class).remove());
        if (componentInfo.fieldDeclaration() != null) {
            componentInfo.fieldDeclaration().remove();
            if (componentInfo.fieldDeclarationAndAssignment() == null) {
                JavaRewriterUtil.removeStatement((Node)componentInfo.objectCreationExpr());
            }
        } else if (componentInfo.localVariableDeclarator() != null) {
            JavaRewriterUtil.removeStatement((Node)componentInfo.localVariableDeclarator());
        }
        otherMethodCalls.forEach(methodCall -> {
            if (!JavaRewriterUtil.removeFromStringConcatenation((Node)methodCall)) {
                JavaRewriterUtil.removeStatement((Node)methodCall);
            }
        });
        this.removeAttachCall(componentInfo);
        List<Expression> parameterUsage = JavaRewriterUtil.findParameterUsage(componentInfo);
        parameterUsage.forEach(expr -> {
            if (JavaRewriterUtil.hasAncestor((Node)expr, Statement.class)) {
                JavaRewriterUtil.removeStatement((Node)expr);
            }
        });
        return true;
    }

    private Optional<Expression> removeAttachCall(ComponentInfo componentInfo) {
        Optional<Expression> addArgument = JavaRewriterUtil.getAttachArgument(componentInfo);
        addArgument.ifPresent(Node::remove);
        if (componentInfo.attachCall() != null && componentInfo.attachCall().getNodeWithArguments().getArguments().isEmpty()) {
            JavaRewriterUtil.removeStatement(componentInfo.attachCall().getNode());
        }
        return addArgument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveComponent(ComponentInfo component, ComponentInfo container, ComponentInfo reference, Where where) {
        ObjectCreationExpr toAdd;
        if (container == null) {
            throw new IllegalArgumentException("Container component must be non-null");
        }
        if (component.equals(container) || component.equals(reference) || container.equals(reference)) {
            throw new IllegalArgumentException("Component, container and reference must be different");
        }
        this.removeAttachCall(component);
        List<MethodCallExpr> containerFunctionCalls = JavaRewriterUtil.findMethodCallStatements(container);
        String componentFieldOrVariableName = JavaRewriterUtil.getFieldOrVariableName(component);
        Object object = toAdd = componentFieldOrVariableName == null ? component.objectCreationExpr() : new NameExpr(componentFieldOrVariableName);
        if (where == Where.APPEND) {
            if (reference != null) {
                throw new IllegalArgumentException("Reference component must be null when appending");
            }
            boolean added = JavaRewriterUtil.addAfterLastFunctionCall(containerFunctionCalls, "add", new Expression[]{toAdd});
            if (added) return;
            throw new IllegalArgumentException("No add call found for the container component");
        }
        if (where != Where.BEFORE) throw new IllegalArgumentException("Unknown where: " + String.valueOf((Object)where));
        if (reference == null) {
            throw new IllegalArgumentException("Reference component must be non-null when moving before");
        }
        Optional<Expression> referenceAddArgument = JavaRewriterUtil.findReference((NodeList<Expression>)reference.attachCall().getNodeWithArguments().getArguments(), reference);
        if (!referenceAddArgument.isPresent()) throw new IllegalArgumentException("Reference component not found in the add call");
        int refAddIndex = reference.attachCall().getNodeWithArguments().getArguments().indexOf((Object)referenceAddArgument.get());
        reference.attachCall().getNodeWithArguments().getArguments().add(refAddIndex, (Node)toAdd);
        List<MethodCallExpr> componentFunctionCalls = JavaRewriterUtil.findMethodCallStatements(component);
        if (componentFunctionCalls.isEmpty()) return;
        MethodCallExpr lastCall = componentFunctionCalls.get(componentFunctionCalls.size() - 1);
        BlockStmt insertBlock = JavaRewriterUtil.findAncestorOrThrow((Node)lastCall, BlockStmt.class);
        int finalAddLocation = JavaRewriterUtil.findBlockStatementIndex((Node)lastCall) + 1;
        int attachCallIndex = JavaRewriterUtil.findBlockStatementIndex(reference.attachCall().getNode());
        List<MethodCallExpr> allAddCalls = containerFunctionCalls.stream().filter(m -> m.getNameAsString().equals(reference.attachCall().getNodeWithSimpleName().getName().asString())).toList();
        for (MethodCallExpr addCall : allAddCalls) {
            int addCallIndex = JavaRewriterUtil.findBlockStatementIndex((Node)addCall);
            if (addCallIndex < attachCallIndex || addCallIndex >= finalAddLocation) continue;
            Statement statement = JavaRewriterUtil.findAncestorOrThrow((Node)addCall, Statement.class);
            statement.remove();
            insertBlock.addStatement(finalAddLocation - 1, statement);
        }
    }

    public void duplicate(ComponentInfo component) {
        this.duplicate(component, true);
    }

    public DuplicateInfo duplicate(ComponentInfo component, boolean handleAdd) {
        String oldName;
        if (component.routeConstructor() != null) {
            throw new IllegalArgumentException("Cannot duplicate a route class");
        }
        InsertionPoint insertionPoint = this.findInsertionPointForAppend(component);
        ArrayList<MethodCallExpr> childAddCalls = new ArrayList<MethodCallExpr>();
        String duplicatedName = null;
        if (component.localVariableName() != null) {
            oldName = component.localVariableName();
            duplicatedName = JavaRewriterUtil.findFreeVariableName(component.localVariableName(), insertionPoint.getBlock());
            VariableDeclarator newLocalVariable = JavaRewriterUtil.clone(component.localVariableDeclarator());
            newLocalVariable.setName(duplicatedName);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)new VariableDeclarationExpr(newLocalVariable)));
        } else if (component.fieldName() != null) {
            FieldDeclaration newField;
            oldName = component.fieldName();
            duplicatedName = JavaRewriterUtil.findFreeVariableName(component.fieldName(), insertionPoint.getBlock());
            if (component.fieldDeclarationAndAssignment() != null) {
                newField = JavaRewriterUtil.clone(component.fieldDeclarationAndAssignment());
            } else {
                newField = JavaRewriterUtil.clone(component.fieldDeclaration());
                AssignExpr newAssignment = JavaRewriterUtil.clone(component.assignmentExpression());
                newAssignment.setTarget((Expression)new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)newAssignment));
            }
            newField.getVariable(0).setName(duplicatedName);
            JavaRewriterUtil.addFieldAfter(newField, component.fieldDeclaration());
        } else {
            oldName = null;
        }
        if (duplicatedName != null) {
            List<MethodCallExpr> calls = JavaRewriterUtil.findMethodCallStatements(component);
            for (MethodCallExpr call : calls) {
                MethodCallExpr newCall = JavaRewriterUtil.clone(call);
                JavaRewriterUtil.setNameExprScope(newCall, new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)newCall));
                if (!newCall.getNameAsString().equals("add")) continue;
                childAddCalls.add(newCall);
            }
            List<Expression> parameterUsages = JavaRewriterUtil.findParameterUsage(component);
            Optional attachCallRangeOptional = component.attachCall().getNodeWithRange().getRange();
            if (attachCallRangeOptional.isPresent()) {
                Range attachRange = (Range)attachCallRangeOptional.get();
                parameterUsages = parameterUsages.stream().filter(parameter -> parameter.getRange().isPresent() && !((Range)parameter.getRange().get()).overlapsWith(attachRange)).toList();
            }
            for (Expression parameterUsage : parameterUsages) {
                MethodCallExpr methodCallExpr = JavaRewriterUtil.findAncestorOrThrow((Node)parameterUsage, MethodCallExpr.class);
                int argumentPosition = methodCallExpr.getArgumentPosition(parameterUsage);
                boolean addAsArg = false;
                Optional scope = methodCallExpr.getScope();
                if (scope.isEmpty() || ((Expression)scope.get()).isThisExpr()) {
                    Optional classNameOpt = JavaRewriterUtil.findAncestor((Node)parameterUsage, ClassOrInterfaceDeclaration.class).getFullyQualifiedName();
                    if (classNameOpt.isEmpty()) {
                        throw new IllegalArgumentException("Could not find source class");
                    }
                    addAsArg = JavaRewriterUtil.isArrayArgument((String)classNameOpt.get(), methodCallExpr.getNameAsString(), argumentPosition);
                }
                if (addAsArg) {
                    methodCallExpr.getArguments().add(argumentPosition + 1, (Node)new NameExpr(duplicatedName));
                    continue;
                }
                MethodCallExpr clone = JavaRewriterUtil.clone(methodCallExpr);
                clone.setArgument(argumentPosition, (Expression)new NameExpr(duplicatedName));
                insertionPoint.add((Statement)new ExpressionStmt((Expression)clone));
            }
        }
        if (handleAdd) {
            ObjectCreationExpr expressionToAdd;
            int addIndex;
            Expression componentAddArgument = JavaRewriterUtil.getAttachArgumentOrThrow(component);
            Optional<Expression> parentNode = componentAddArgument.getParentNode().map(Expression.class::cast);
            if (parentNode.isPresent() && parentNode.get().isObjectCreationExpr()) {
                ObjectCreationExpr objectCreationExpr = parentNode.get().asObjectCreationExpr();
                addIndex = objectCreationExpr.getArguments().indexOf((Object)componentAddArgument) + 1;
                expressionToAdd = objectCreationExpr;
            } else {
                addIndex = component.attachCall().getNodeWithArguments().getArgumentPosition(componentAddArgument) + 1;
                expressionToAdd = component.attachCall().getNodeWithArguments();
            }
            if (duplicatedName != null) {
                expressionToAdd.getArguments().add(addIndex, (Node)new NameExpr(duplicatedName));
            } else {
                expressionToAdd.getArguments().add(addIndex, (Node)((Expression)JavaRewriterUtil.clone(component.objectCreationExpr())));
            }
        }
        Map<String, String> nameMappings = oldName != null ? Collections.singletonMap(oldName, duplicatedName) : Collections.emptyMap();
        return new DuplicateInfo(nameMappings, childAddCalls);
    }

    public void addComponentUsingTemplate(ComponentInfo referenceComponent, ComponentInfo layout, Where where, List<JavaComponent> template) {
        if (where == Where.APPEND) {
            if (referenceComponent != null || layout == null) {
                throw new IllegalArgumentException("Reference component must be null and layout must be non-null when appending");
            }
            InsertionPoint insertionPoint = this.findInsertionPointForAppend(layout);
            if (layout.routeConstructor() != null) {
                this.createComponentStatements(insertionPoint, null, template, "this", null);
            } else {
                this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(layout), null);
            }
        } else if (where == Where.BEFORE) {
            BlockStmt insertBlock = referenceComponent.componentCreateScope();
            int insertIndex = JavaRewriterUtil.findBlockStatementIndex((Node)referenceComponent.objectCreationExpr());
            InsertionPoint insertionPoint = new InsertionPoint(insertBlock, insertIndex);
            this.createComponentStatements(insertionPoint, null, template, JavaRewriterUtil.getFieldOrVariableName(referenceComponent), referenceComponent);
        } else {
            throw new IllegalArgumentException("Unknown where: " + String.valueOf((Object)where));
        }
    }

    private InsertionPoint findInsertionPointForAppend(ComponentInfo component) {
        List<MethodCallExpr> functionCalls = JavaRewriterUtil.findMethodCallStatements(component);
        if (!functionCalls.isEmpty()) {
            MethodCallExpr lastCall = functionCalls.get(functionCalls.size() - 1);
            return JavaRewriterUtil.findLocationAfter((Expression)lastCall);
        }
        if (component.routeConstructor() != null) {
            return JavaRewriterUtil.findLocationAtEnd((Statement)component.routeConstructor().getBody());
        }
        return JavaRewriterUtil.findLocationBefore(component.attachCall().expression());
    }

    public void setAlignment(ComponentInfo component, AlignmentMode alignmentMode, boolean selected, List<String> lumoClasses) {
        String[] stringArray;
        if (alignmentMode == AlignmentMode.ALIGN_ITEMS) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "AlignItems";
            stringArray = stringArray2;
            stringArray2[1] = "JustifyContent";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "AlignSelf";
        }
        String[] lumoUtilityInnerClassNames = stringArray;
        LumoRewriterUtil.removeClassNameArgs(component, lumoUtilityInnerClassNames);
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        if (selected) {
            ArrayList<Expression> parameterToAddList = new ArrayList<Expression>();
            for (String lumoUtilityInnerClassName : lumoUtilityInnerClassNames) {
                parameterToAddList.addAll(LumoRewriterUtil.getLumoMethodArgExpressions(lumoUtilityInnerClassName, lumoClasses));
            }
            boolean added = LumoRewriterUtil.addClassNameWithArgs(component, parameterToAddList);
            if (!added) {
                this.replaceOrAddCall(component, "addClassNames", parameterToAddList.toArray(new Object[0]));
            }
        }
    }

    public void setGap(ComponentInfo component, String newValue) {
        LumoRewriterUtil.removeClassNameArgs(component, "Gap", "Gap.Column", "Gap.Row");
        LumoRewriterUtil.addLumoUtilityImport(this.compilationUnit);
        List<MethodCallExpr> methodCallStatements = JavaRewriterUtil.findMethodCallStatements(component);
        methodCallStatements.stream().filter(methodCallExpr -> StringUtils.equals((CharSequence)methodCallExpr.getNameAsString(), (CharSequence)"setSpacing")).findAny().ifPresent(JavaRewriterUtil::removeStatement);
        LumoRewriterUtil.removeThemeArgStartsWith(methodCallStatements, "spacing");
        if (StringUtils.isNotEmpty((CharSequence)newValue)) {
            List<Expression> gapExpressions = LumoRewriterUtil.getLumoMethodArgExpressions("Gap", List.of(newValue));
            boolean added = LumoRewriterUtil.addClassNameWithArgs(component, gapExpressions);
            if (!added) {
                this.replaceOrAddCall(component, "addClassNames", gapExpressions.toArray(new Object[0]));
            }
        } else {
            boolean added = JavaRewriterUtil.addAfterLastFunctionCall(methodCallStatements, "setSpacing", new Expression[]{new BooleanLiteralExpr(false)});
            if (!added) {
                this.replaceOrAddCall(component, "setSpacing", false);
            }
        }
    }

    public void mergeAndReplace(List<ComponentInfo> components, JavaComponent wrapperComponent) {
        ComponentInfo firstComponent = components.get(0);
        if (firstComponent.componentAttachScope() == null) {
            throw new IllegalArgumentException("Routes cannot be wrapped");
        }
        for (int i = 1; i < components.size(); ++i) {
            ComponentInfo component = components.get(i);
            if (component.componentAttachScope() == firstComponent.componentAttachScope()) continue;
            throw new IllegalArgumentException("Only components attached in the same block are currently supported");
        }
        int wrapperInsertIndex = JavaRewriterUtil.findBlockStatementIndex(firstComponent.attachCall().getNode());
        InsertionPoint firstComponentAttachLocation = new InsertionPoint(firstComponent.componentAttachScope(), wrapperInsertIndex);
        List<VariableDeclarator> statements = this.createComponentStatements(firstComponentAttachLocation, null, wrapperComponent, false, null, null);
        NameExpr wrapperVariable = new NameExpr(statements.get(0).getNameAsString());
        MethodCallExpr addCall = new MethodCallExpr((Expression)wrapperVariable, "add");
        Node wrapperAdd = null;
        for (int i = 0; i < components.size(); ++i) {
            Optional<Expression> componentAddArgument;
            ComponentInfo component = components.get(i);
            if (i == 0) {
                componentAddArgument = Optional.of(JavaRewriterUtil.getAttachArgumentOrThrow(component));
                Optional maybeParent = componentAddArgument.flatMap(Node::getParentNode);
                if (maybeParent.isEmpty()) {
                    throw new IllegalArgumentException("No add argument found for the first component");
                }
                wrapperAdd = (Node)maybeParent.get();
                wrapperAdd.replace((Node)componentAddArgument.get(), (Node)wrapperVariable);
            } else {
                componentAddArgument = this.removeAttachCall(component);
            }
            componentAddArgument.ifPresent(arg_0 -> ((MethodCallExpr)addCall).addArgument(arg_0));
        }
        if (wrapperAdd == null) {
            throw new IllegalArgumentException("Wrapper was never added");
        }
        firstComponentAttachLocation.getBlock().addStatement(JavaRewriterUtil.findBlockStatementIndex(wrapperAdd), (Expression)addCall);
    }

    public void replaceCallParameter(MethodCallExpr call, String oldVariableName, String newVariableName) {
        call.getArguments().stream().forEach(arg -> {
            if (arg.isNameExpr() && arg.asNameExpr().getNameAsString().equals(oldVariableName)) {
                arg.asNameExpr().setName(newVariableName);
            }
        });
    }

    private void createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> template, String layoutVariableName, ComponentInfo referenceComponent) {
        for (JavaComponent javaComponent : template) {
            this.createComponentStatements(insertionPoint, parent, javaComponent, true, layoutVariableName, referenceComponent);
        }
    }

    private List<VariableDeclarator> createComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, JavaComponent javaComponent, boolean attach, String layoutVariableName, ComponentInfo referenceComponent) {
        ArrayList<VariableDeclarator> createdVariables = new ArrayList<VariableDeclarator>();
        String componentClassName = javaComponent.className() != null ? javaComponent.className() : FlowComponentQuirks.getClassForTag(javaComponent.tag());
        ClassOrInterfaceType fullType = StaticJavaParser.parseClassOrInterfaceType((String)componentClassName);
        HashMap setters = new HashMap();
        Class<?> componentType = JavaRewriterUtil.getClass(fullType.getNameWithScope());
        javaComponent.props().forEach((prop, value) -> {
            SetterAndValue setterAndValue = JavaRewriterUtil.getSetterAndValue(componentType, prop, value);
            setters.put(setterAndValue.setter(), setterAndValue.value());
        });
        JavaRewriterUtil.addImport(this.compilationUnit, fullType.getNameWithScope());
        ClassOrInterfaceType type = fullType.clone().removeScope();
        ObjectCreationExpr constructor = new ObjectCreationExpr(null, type, new NodeList());
        this.getSingleParamConstructor(fullType, setters.keySet()).ifPresent(constructorProp -> {
            Object value = setters.remove(constructorProp);
            this.getParameterList(insertionPoint, value).forEach(arg_0 -> ((ObjectCreationExpr)constructor).addArgument(arg_0));
        });
        String variableBaseName = type.getNameAsString().toLowerCase(Locale.ENGLISH);
        if (javaComponent.props().containsKey("text")) {
            variableBaseName = SharedUtil.firstToLower((String)SharedUtil.dashSeparatedToCamelCase((String)((String)javaComponent.props().get("text")).replace(' ', '-')));
            variableBaseName = JavaRewriterUtil.getJavaIdentifier(variableBaseName);
        }
        String variableName = insertionPoint.getFreeVariableName(variableBaseName);
        NameExpr variableNameExpr = new NameExpr(variableName);
        VariableDeclarator decl = new VariableDeclarator((Type)type, variableName, (Expression)constructor);
        VariableDeclarationExpr declarationExpr = new VariableDeclarationExpr(decl);
        createdVariables.add(decl);
        insertionPoint.add((Statement)new ExpressionStmt((Expression)declarationExpr));
        for (Map.Entry setter : setters.entrySet()) {
            Object value2 = setter.getValue();
            if (value2 instanceof JavaComponent) {
                JavaComponent javaComponentValue = (JavaComponent)value2;
                value2 = this.createSubComponentStatements(insertionPoint, javaComponent, List.of(javaComponentValue)).get(0);
            }
            this.insertSetter(insertionPoint, (Expression)variableNameExpr, (String)setter.getKey(), value2);
        }
        this.createComponentStatements(insertionPoint, javaComponent, javaComponent.children(), variableName, null);
        if (attach) {
            this.attachComponent(insertionPoint, parent, layoutVariableName, referenceComponent, variableNameExpr, variableName);
        }
        return createdVariables;
    }

    private void attachComponent(InsertionPoint insertionPoint, JavaComponent parent, String layoutVariableName, ComponentInfo referenceComponent, NameExpr variableNameExpr, String variableName) {
        if (referenceComponent != null) {
            AttachExpression referenceAttach = referenceComponent.attachCall();
            if (referenceAttach.getNodeWithArguments().getArguments().size() == 1) {
                ExpressionStmt addCall = this.createAddCall(parent, referenceAttach.getNodeWithOptionalScope().getScope().orElse(null), (Expression)variableNameExpr);
                BlockStmt block = JavaRewriterUtil.findAncestorOrThrow(referenceAttach.getNode(), BlockStmt.class);
                block.addStatement(JavaRewriterUtil.findBlockStatementIndex(referenceAttach.getNode()), (Statement)addCall);
            } else {
                Object referenceArgument = layoutVariableName == null ? referenceComponent.objectCreationExpr() : (Expression)referenceAttach.getNodeWithArguments().getArguments().stream().filter(arg -> {
                    NameExpr nameExpr;
                    return arg instanceof NameExpr && (nameExpr = (NameExpr)arg).getNameAsString().equals(layoutVariableName);
                }).findFirst().orElse(null);
                if (referenceArgument == null) {
                    throw new IllegalArgumentException("Did not find reference argument ('" + variableName + "') in " + String.valueOf(referenceAttach));
                }
                int index = referenceAttach.getNodeWithArguments().getArguments().indexOf(referenceArgument);
                referenceAttach.getNodeWithArguments().getArguments().add(index, (Node)variableNameExpr);
            }
        } else if (layoutVariableName != null) {
            NameExpr scope = null;
            if (!layoutVariableName.equals("this")) {
                scope = new NameExpr(layoutVariableName);
            }
            ExpressionStmt addCall = this.createAddCall(parent, (Expression)scope, (Expression)variableNameExpr);
            insertionPoint.add((Statement)addCall);
        } else {
            throw new IllegalArgumentException("Either layoutVariableName or referenceAttach must be given to attach a component");
        }
    }

    private NodeList<Expression> getParameterList(InsertionPoint insertionPoint, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return new NodeList();
            }
            if (list.get(0) instanceof JavaComponent) {
                return JavaRewriterUtil.toExpressionList(this.createSubComponentStatements(insertionPoint, null, list));
            }
        }
        return JavaRewriterUtil.toExpressionList(value);
    }

    private void insertSetter(InsertionPoint insertionPoint, Expression owner, String setterName, Object value) {
        if (setterName.equals("setStyle")) {
            this.insertStyles(insertionPoint, owner, (Map)value);
        } else if (setterName.equals("setSlot")) {
            MethodCallExpr getElement = new MethodCallExpr(owner, "getElement");
            MethodCallExpr setAttributeCall = new MethodCallExpr((Expression)getElement, "setAttribute", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression("slot"), JavaRewriterUtil.toExpression(value)}));
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setAttributeCall));
        } else {
            NodeList<Expression> parameterExpression = this.getParameterList(insertionPoint, value);
            MethodCallExpr setterCall = new MethodCallExpr(owner, setterName, parameterExpression);
            insertionPoint.add((Statement)new ExpressionStmt((Expression)setterCall));
        }
    }

    private void insertStyles(InsertionPoint insertionPoint, Expression owner, Map<String, String> styles) {
        MethodCallExpr finalCall = new MethodCallExpr(owner, "getStyle");
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            finalCall = new MethodCallExpr((Expression)finalCall, "set", new NodeList((Node[])new Expression[]{JavaRewriterUtil.toExpression(entry.getKey()), JavaRewriterUtil.toExpression(entry.getValue())}));
        }
        insertionPoint.add((Statement)new ExpressionStmt((Expression)finalCall));
    }

    private NodeList<Expression> createSubComponentStatements(InsertionPoint insertionPoint, JavaComponent parent, List<JavaComponent> components) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        for (JavaComponent javaComponent : components) {
            variables.addAll(this.createComponentStatements(insertionPoint, parent, javaComponent, false, null, null));
        }
        return new NodeList((Node[])((Expression[])variables.stream().map(VariableDeclarator::getName).map(NameExpr::new).toArray(NameExpr[]::new)));
    }

    private Optional<String> getSingleParamConstructor(ClassOrInterfaceType type, Set<String> setters) {
        Class<?> componentType = JavaRewriterUtil.getClass(type.getNameWithScope());
        Optional<Constructor> constructor = Arrays.stream(componentType.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0] == String.class).findFirst();
        if (constructor.isEmpty()) {
            return Optional.empty();
        }
        String mappedProperty = this.getMappedProperty(constructor.get(), 0);
        if (mappedProperty != null && setters.contains(mappedProperty)) {
            return Optional.of(mappedProperty);
        }
        return Optional.empty();
    }

    private ExpressionStmt createAddCall(JavaComponent parent, Expression scope, Expression toAdd) {
        String methodName = "add";
        if (parent != null && parent.tag().equals("SideNav")) {
            methodName = "addItem";
        }
        return new ExpressionStmt((Expression)new MethodCallExpr(scope, methodName, new NodeList((Node[])new Expression[]{toAdd})));
    }

    protected String getSource() {
        return this.source;
    }

    public record ExtractInlineVariableResult(BlockStmt blockStmt, String newVariableName, int index) {
    }

    public static enum Where {
        BEFORE,
        APPEND;

    }

    public record DuplicateInfo(Map<String, String> nameMapping, List<MethodCallExpr> childAddCalls) {
    }

    public static enum AlignmentMode {
        ALIGN_ITEMS,
        SELF_HORIZONTALLY,
        SELF_VERTICALLY;

    }

    public record SetterAndValue(String setter, Object value) {
    }

    public record Code(String code) {
    }
}

